<?php
/**
 * Akeeba Engine
 * The PHP-only site backup engine
 *
 * @copyright Copyright (c)2006-2019 Nicholas K. Dionysopoulos / Akeeba Ltd
 * @license   GNU GPL version 3 or, at your option, any later version
 * @package   akeebaengine
 */

namespace Akeeba\Engine\Postproc;



use Akeeba\Engine\Factory;
use Akeeba\Engine\Util\Transfer\FtpCurl as TransferFtpCurl;

class Ftpcurl extends Ftp
{
	public function __construct()
	{
		parent::__construct();

		$this->engineKey = 'engine.postproc.ftpcurl.';
	}

	protected function makeConnector()
	{
		Factory::getLog()->debug(__CLASS__ . ':: Connecting to remote FTP');

		$options = $this->getConfig();

		return new TransferFtpCurl($options);
	}
}
