<?php
/**
 * @package    solo
 * @copyright  Copyright (c)2014-2019 Nicholas K. Dionysopoulos / Akeeba Ltd
 * @license    GNU GPL version 3 or later
 */

use Awf\Text\Text;

defined('_AKEEBA') or die();

/** @var \Solo\View\S3import\Html $this */

$router = $this->getContainer()->router;

?>
<form name="adminForm" id="adminForm" action="@route('index.php?view=s3import')" method="POST"
      role="form">

    <div class="akeeba-hidden-fields-container">
        <input type="hidden" id="ak_s3import_folder" name="folder" value="<?php echo $this->root ?>" />
    </div>

    <div class="akeeba-panel--information">
        <div class="akeeba-form--inline">

            <div class="akeeba-form-group">
                <input type="text" size="40" name="s3access" id="s3access"
                       value="{{{ $this->s3access }}}"
                       placeholder="@lang('COM_AKEEBA_CONFIG_S3ACCESSKEY_TITLE')" />
            </div>
            <div class="akeeba-form-group">
                <input type="password" size="40" name="s3secret" id="s3secret"
                       value="{{{ $this->s3secret }}}"
                       placeholder="@lang('COM_AKEEBA_CONFIG_S3SECRETKEY_TITLE')" />
            </div>

	        @if(empty($this->buckets))
            <div class="akeeba-form-group">
                <button class="akeeba-btn--primary" type="submit" onclick="this.form.submit(); return false;">
                    <span class="akion-wifi"></span>
			        @lang('COM_AKEEBA_S3IMPORT_LABEL_CONNECT')
                </button>
            </div>
	        @else
            <div class="akeeba-form-group">
		        {{ $this->bucketSelect }}
            </div>
            <div class="akeeba-form-group">
                <button class="akeeba-btn--primary" type="submit" onclick="this.form.submit(); return false;">
                    <span class="akion-folder"></span>
			        @lang('COM_AKEEBA_S3IMPORT_LABEL_CHANGEBUCKET')
                </button>
            </div>
	        @endif
        </div>
	</div>

    <div class="akeeba-panel--information">
		<div id="ak_crumbs_container">
			<ul class="akeeba-breadcrumb">
				<li>
					<a href="@route('index.php?view=s3import&task=main&folder=')">
						@lang('SOLO_COMMON_LBL_ROOT')
					</a>
                    <span class="divider">/</span>
				</li>

				@if (!empty($this->crumbs))
					<?php $runningCrumb = ''; $i = 0; ?>
					@foreach($this->crumbs as $crumb)
						<?php $runningCrumb .= $crumb . '/'; $i++; ?>
                        <li>
                            <a href="<?php echo $router->route('index.php?view=s3import&task=main&folder=' . urlencode($runningCrumb)) ?>">
								{{{  htmlentities($crumb) }}}
                            </a>
	                        @if ($i < count($this->crumbs))
                                <span class="divider">/</span>
	                        @endif
                        </li>
					@endforeach
                @endif
			</ul>
		</div>
	</div>

    <div class="akeeba-container--50-50">
        <div id="ak_folder_container" class="akeeba-panel--primary">
            <header class="akeeba-block-header">
                <h3>
                    @lang('COM_AKEEBA_FILEFILTERS_LABEL_DIRS')
                </h3>
            </header>

            <div id="folders">
                @if(!empty($this->contents['folders']))
                    @foreach($this->contents['folders'] as $name => $record)
                    <div class="folder-container">
                        <a href="<?php echo $router->route('index.php?view=s3import&task=main&folder=' . $record['prefix']) ?>">
                            <span class="akion-ios-folder"></span>
                            {{ basename($name) }}
                        </a>
                    </div>
                    @endforeach
                @endif
            </div>
        </div>

        <div id="ak_files_container" class="akeeba-panel--primary">
            <header class="akeeba-block-header">
                <h3>
                    @lang('COM_AKEEBA_FILEFILTERS_LABEL_FILES')
                </h3>
            </header>
            <div id="files">
                @if(!empty($this->contents['files']))
                    @foreach($this->contents['files'] as $name => $record)
                    <div class="file-container">
                        <a href="<?php echo $router->route('index.php?view=s3import&task=downloadToServer&part=-1&frag=-1&layout=downloading&file=' . $name) ?>">
                            <span class="akion-document"></span>
                            {{ basename($record['name']) }}
                        </a>
                    </div>
                    @endforeach
                @endif
            </div>
        </div>
    </div>
</form>
