<?php
/**
 * @package    solo
 * @copyright  Copyright (c)2014-2019 Nicholas K. Dionysopoulos / Akeeba Ltd
 * @license    GNU GPL version 3 or later
 */

defined('_AKEEBA') or die;

/** @var  Solo\View\Alice\Html $this */

$js = <<< JS

;// This comment is intentionally put here to prevent badly written plugins from causing a Javascript error
// due to missing trailing semicolon and/or newline in their code.
function postMyForm()
{
	document.forms.adminForm.submit();
}

akeeba.System.documentReady(function(){
	window.setTimeout(postMyForm, 250);
});

JS;
?>
@inlineJs($js)


<div class="akeeba-panel--info">
	<header class="akeeba-block-header">
		<h3>
			@lang('COM_AKEEBA_ALICE_ANALYZE_LABEL_PROGRESS')
		</h3>
	</header>
	<h4>
		{{ $this->currentSection }}
	</h4>
	<p>
		{{ $this->currentCheck }}
	</p>
	<div class="akeeba-progress">
		<div class="akeeba-progress-fill" style="width:{{ $this->percentage }}%"></div>
		<div class="akeeba-progress-status">
			{{ $this->percentage }}%
		</div>
	</div>
	<p>
		<img src="@media('media://com_akeeba/icons/spinner.gif')"
			 alt="@lang('COM_AKEEBA_ALICE_ANALYZE_LABEL_PROGRESS')" />
	</p>
</div>

<form name="adminForm" id="adminForm" action="@route('index.php')" method="post">
	<input name="view" value="Alice" type="hidden" />
	<input name="task" value="step" type="hidden" />
    <input type="hidden" name="token" value="@token()" />
</form>