<?php
/**
 * @package    solo
 * @copyright  Copyright (c)2014-2019 Nicholas K. Dionysopoulos / Akeeba Ltd
 * @license    GNU GPL version 3 or later
 */

namespace Solo\View\Multidb;

use Awf\Text\Text;
use Awf\Uri\Uri;
use Awf\Utils\Template;
use Solo\Helper\Escape;
use Solo\Model\Multidb;
use Solo\View\ViewTraits\ProfileIdAndName;

class Html extends \Solo\View\Html
{
	use ProfileIdAndName;

	/**
	 * The view's interface data encoded in JSON format
	 *
	 * @var  string
	 */
	public $json = '';

	public function onBeforeMain()
	{
		// Get a JSON representation of the database connection data
		/** @var Multidb $model */
		$model = $this->getModel();
		$databases = $model->get_databases();
		$json = json_encode($databases);
		$this->json =  $json;

		$this->getProfileIdAndName();

		// Load additional Javascript
		Template::addJs('media://js/solo/multidb.js', $this->container->application);
		Template::addJs('media://js/solo/fsfilters.js', $this->container->application);

		$this->loadCommonJavascript();

		return true;
	}

	/**
	 * Load the common Javascript for this feature: language strings, image locations
	 */
	protected function loadCommonJavascript()
	{
		$strings                                               = array();
		$strings['COM_AKEEBA_FILEFILTERS_UIROOT']              = Escape::escapeJS(Text::_('COM_AKEEBA_FILEFILTERS_LABEL_UIROOT'));
		$strings['COM_AKEEBA_FILEFILTERS_LABEL_UIERRORFILTER'] = Escape::escapeJS(Text::_('COM_AKEEBA_FILEFILTERS_LABEL_UIERRORFILTER'));

		$keys = array('COM_AKEEBA_MULTIDB_GUI_LBL_HOST', 'COM_AKEEBA_MULTIDB_GUI_LBL_PORT', 'COM_AKEEBA_MULTIDB_GUI_LBL_USERNAME', 'COM_AKEEBA_MULTIDB_GUI_LBL_PASSWORD',
		              'COM_AKEEBA_MULTIDB_GUI_LBL_DATABASE', 'COM_AKEEBA_MULTIDB_GUI_LBL_PREFIX', 'COM_AKEEBA_MULTIDB_GUI_LBL_TEST', 'COM_AKEEBA_MULTIDB_GUI_LBL_SAVE',
		              'COM_AKEEBA_MULTIDB_GUI_LBL_CANCEL', 'COM_AKEEBA_MULTIDB_GUI_LBL_LOADING', 'COM_AKEEBA_MULTIDB_GUI_LBL_CONNECTOK',
		              'COM_AKEEBA_MULTIDB_GUI_LBL_CONNECTFAIL', 'COM_AKEEBA_MULTIDB_GUI_LBL_SAVEFAIL', 'COM_AKEEBA_MULTIDB_GUI_LBL_DRIVER');

		$translations = "";

		foreach ($keys as $key)
		{
			$t = Escape::escapeJS(Text::_($key));
			$translations .= "\takeeba.Multidb.translations['$key'] = '$t';\n";
		}

		$loadingGif = Escape::escapeJS(Uri::base(false, $this->container) . 'media/loading.gif');
		$ajaxURL = Escape::escapeJS($this->getContainer()->router->route('index.php?view=multidb&task=ajax&format=raw'));
		$json = Escape::escapeJS($this->json,"'");

		$js = <<< JS

akeeba.loadScripts.push(function() {
		akeeba.Fsfilters.translations['COM_AKEEBA_FILEFILTERS_UIROOT'] = '{$strings['COM_AKEEBA_FILEFILTERS_UIROOT']}';
		akeeba.Fsfilters.translations['COM_AKEEBA_FILEFILTERS_LABEL_UIERRORFILTER'] = '{$strings['COM_AKEEBA_FILEFILTERS_LABEL_UIERRORFILTER']}';
		akeeba.Fsfilters.loadingGif = '$loadingGif';

$translations
		
		akeeba.System.params.AjaxURL = '$ajaxURL';
		akeeba.Multidb.render(eval($json));
});

JS;

		$this->getContainer()->application->getDocument()->addScriptDeclaration($js);
	}

} 
