<?php
/**
 * @package    solo
 * @copyright  Copyright (c)2014-2019 Nicholas K. Dionysopoulos / Akeeba Ltd
 * @license    GNU GPL version 3 or later
 */

use Awf\Text\Text;

defined('_AKEEBA') or die();

/** @var \Solo\View\Users\Html $this */

/** @var \Solo\Model\Users $model */
$model = $this->getModel();

$permissions = [
	'backup'	=> false,
	'configure'	=> false,
	'download'	=> false,
];

$tfa = [
	'method'	=> 'none',
	'yubikey'	=> '',
	'google'	=> '',
	'otep'		=> [],
];

if ($model->id)
{
	$user = $this->getContainer()->userManager->getUser($model->id);

	$permissions = [
		'backup'	=> $user->getPrivilege('akeeba.backup', false),
		'configure'	=> $user->getPrivilege('akeeba.configure', false),
		'download'	=> $user->getPrivilege('akeeba.download', false),
	];
	$tfa = [
		'method'	=> $user->getParameters()->get('tfa.method', 'none'),
		'yubikey'	=> $user->getParameters()->get('tfa.yubikey', ''),
		'google'	=> $user->getParameters()->get('tfa.google', ''),
		'otep'		=> $user->getParameters()->get('tfa.otep', []),
	];

	if (empty($tfa['google']))
	{
		$totp = new \Awf\Encrypt\Totp(30, 6, 10);
		$tfa['google'] = $totp->generateSecret();
	}
}

?>
<form name="adminForm" id="adminForm" action="<?php echo $this->container->router->route('index.php?view=users'); ?>" method="post"
      role="form" class="akeeba-form--horizontal">

	<div>
		<h3><?php echo \Awf\Text\Text::_('SOLO_USERS_HEAD_BASIC'); ?></h3>

		<div class="akeeba-form-group">
			<label for="username">
				<?php echo \Awf\Text\Text::_('SOLO_USERS_FIELD_USERNAME'); ?> *
			</label>
            <input type="text" name="username" maxlength="255" size="50"
                   value="<?php echo $this->escape($model->username); ?>"
                   class="form-control" required />
		</div>

		<div class="akeeba-form-group">
			<label for="password">
				<?php echo \Awf\Text\Text::_('SOLO_USERS_FIELD_PASSWORD'); ?>
			</label>
            <input type="password" name="password" maxlength="255" size="50"
                   value=""
                   class="form-control" />
		</div>

		<div class="akeeba-form-group">
			<label for="repeatpassword">
				<?php echo \Awf\Text\Text::_('SOLO_USERS_FIELD_PASSWORDREPEAT'); ?>
			</label>
            <input type="password" name="repeatpassword" maxlength="255" size="50"
                   value=""
                   class="form-control" />
		</div>

		<div class="akeeba-form-group">
			<label for="email">
				<?php echo \Awf\Text\Text::_('SOLO_USERS_FIELD_EMAIL'); ?> *
			</label>
            <input type="email" name="email" maxlength="255" size="50"
                   value="<?php echo $this->escape($model->email); ?>"
                   class="form-control" required />
		</div>

		<div class="akeeba-form-group">
			<label for="name">
				<?php echo \Awf\Text\Text::_('SOLO_USERS_FIELD_NAME'); ?>
			</label>
            <input type="text" name="name" maxlength="255" size="50"
                   value="<?php echo $this->escape($model->name); ?>"
                   class="form-control" />
		</div>

		<div class="akeeba-form-group">
			<label for="name">
				<?php echo \Awf\Text\Text::_('SOLO_USERS_FIELDSET_PERMISSIONS'); ?>
			</label>
			<div class="akeeba-form-group--checkbox">
                <label>
                    <input type="checkbox" name="permissions[backup]" <?php echo $permissions['backup'] ? 'checked' : ''; ?>>
					<?php echo \Awf\Text\Text::_('SOLO_USERS_FIELD_PERMISSIONS_BACKUP'); ?>
                </label>
			</div>
		</div>

        <div class="akeeba-form-group--checkbox--pull-right">
            <label>
                <input type="checkbox" name="permissions[configure]" <?php echo $permissions['configure'] ? 'checked' : ''; ?>>
		        <?php echo \Awf\Text\Text::_('SOLO_USERS_FIELD_PERMISSIONS_CONFIGURE'); ?>
            </label>
        </div>

        <div class="akeeba-form-group--checkbox--pull-right">
            <label>
                <input type="checkbox" name="permissions[download]" <?php echo $permissions['download'] ? 'checked' : ''; ?>>
		        <?php echo \Awf\Text\Text::_('SOLO_USERS_FIELD_PERMISSIONS_DOWNLOAD'); ?>
            </label>
        </div>
	</div>

	<div>
		<h3><?php echo \Awf\Text\Text::_('SOLO_USERS_HEAD_TFA'); ?></h3>

		<p>
			<?php echo \Awf\Text\Text::_('SOLO_USERS_LBL_ABOUTTFA'); ?>
		</p>
	</div>

<?php if(empty($tfa['method']) || ($tfa['method'] == 'none')): ?>
	<div class="akeeba-form-group">
		<label for="tfa[method]">
			<?php echo \Awf\Text\Text::_('SOLO_USERS_LBL_TFAMETHOD'); ?>
		</label>
        <?php echo \Solo\Helper\Setup::tfaMethods('tfa[method]', $tfa['method']); ?>

	</div>

	<div id="tfa_containers">
		<?php echo $this->loadAnyTemplate('Users/tfa_none', ['tfa' => $tfa]); ?>
		<?php echo $this->loadAnyTemplate('Users/tfa_yubikey', ['tfa' => $tfa]); ?>
		<?php echo $this->loadAnyTemplate('Users/tfa_google', ['tfa' => $tfa]); ?>
	</div>
<?php else: ?>
	<div class="akeeba-form-group">
		<label for="tfa[keep]">
			<?php echo \Awf\Text\Text::_('SOLO_USERS_LBL_TFAENABLE'); ?>
		</label>
        <select class="form-control" name="tfa[keep]" id="tfa[keep]">
            <option value="1" checked="checked"><?php echo \Awf\Text\Text::_('SOLO_YES'); ?></option>
            <option value="0"><?php echo \Awf\Text\Text::_('SOLO_NO'); ?></option>
        </select>

		<div id="otep_containers">
			<?php echo $this->loadAnyTemplate('Users/tfa_oteps', ['tfa' => $tfa]); ?>
		</div>
	</div>
<?php endif; ?>

    <div class="akeeba-hidden-fields-container">
        <input type="hidden" name="task" value="" />
        <input type="hidden" name="id" value="<?php echo $model->id; ?>" />
        <input type="hidden" name="<?php echo $this->container->session->getCsrfToken()->getValue(); ?>" value="1">
    </div>
</form>
