<?php
/**
 * @package    solo
 * @copyright  Copyright (c)2014-2019 Nicholas K. Dionysopoulos / Akeeba Ltd
 * @license    GNU GPL version 3 or later
 */

use Awf\Text\Text;

defined('_AKEEBA') or die();

/** @var \Solo\View\Upload\Html $this */

$errorParts   = explode("\n", $this->errorMessage, 2);
$errorHeader  = $errorParts[0];
$errorDetails = (count($errorParts) > 1) ? $errorParts[1] : '';

?>
<div class="akeeba-panel--failure">
	<h3>
		<?php echo \Awf\Text\Text::_('COM_AKEEBA_TRANSFER_MSG_FAILED'); ?>
	</h3>
	<p>
		<?php echo $this->escape($errorHeader); ?>

	</p>
	<?php if(!empty($errorDetails)): ?>
		<pre><?php echo $this->escape($errorDetails); ?></pre>
	<?php endif; ?>
</div>
