<?php
/**
 * @package    solo
 * @copyright  Copyright (c)2014-2019 Nicholas K. Dionysopoulos / Akeeba Ltd
 * @license    GNU GPL version 3 or later
 */

use Awf\Text\Text;
use Awf\Utils\Template;
use Solo\Helper\Escape;

defined('_AKEEBA') or die();

$router = $this->getContainer()->router;

/** @var \Solo\View\Setup\Html $this */

$headJavascript = <<< JS
akeeba.System.documentReady(function() {
   akeeba.Setup.init();
});
JS;

Template::addJs('media://js/solo/gui-helpers.js', $this->getContainer()->application);
Template::addJs('media://js/solo/modal.js', $this->getContainer()->application);
Template::addJs('media://js/solo/ajax.js', $this->getContainer()->application);
Template::addJs('media://js/solo/system.js', $this->getContainer()->application);
Template::addJs('media://js/solo/tooltip.js', $this->getContainer()->application);
Template::addJs('media://js/piecon.js', $this->getContainer()->application);
Template::addJs('media://js/solo/setup.js', $this->getContainer()->application);

$this->getContainer()->application->getDocument()->addScriptDeclaration($headJavascript);
?>
<?php echo $this->loadAnyTemplate('CommonTemplates/FTPBrowser'); ?>;
<?php echo $this->loadAnyTemplate('CommonTemplates/SFTPBrowser'); ?>;
<?php echo $this->loadAnyTemplate('CommonTemplates/FTPConnectionTest'); ?>;

<form
        action="<?php echo \Awf\Uri\Uri::rebase('?view=setup&task=finish', $this->getContainer()); ?>" method="post"
        name="setupForm" id="setupForm"
        class="akeeba-form--horizontal" role="form">

<div class="akeeba-panel--info">
	<header class="akeeba-block-header">
		<h3>
			<span class="akion-ios-gear"></span>
			<?php echo \Awf\Text\Text::_('SOLO_SETUP_LBL_APPSETUP'); ?>
		</h3>
	</header>
	<div>
			<div class="akeeba-form-group">
				<label for="timezone">
					<?php echo \Awf\Text\Text::_('SOLO_SETUP_LBL_TIMEZONE'); ?>
				</label>
				<?php echo \Solo\Helper\Setup::timezoneSelect($this->params['timezone']); ?>

                <p class="akeeba-help-text">
					<?php echo \Awf\Text\Text::_('SOLO_SETUP_LBL_TIMEZONE_HELP'); ?>
                </p>
			</div>

			<div class="akeeba-form-group">
				<label for="live_site">
					<?php echo \Awf\Text\Text::_('SOLO_SETUP_LBL_LIVESITE'); ?>
				</label>
                <input type="text" name="live_site" id="live_site" value="<?php echo $this->params['live_site']; ?>">
                <p class="akeeba-help-text">
					<?php echo \Awf\Text\Text::_('SOLO_SETUP_LBL_LIVESITE_HELP'); ?>
                </p>
			</div>

			<div class="akeeba-form-group">
				<label for="session_timeout">
					<?php echo \Awf\Text\Text::_('SOLO_SETUP_LBL_SESSIONTIMEOUT'); ?>
				</label>
                <input type="text" name="session_timeout" id="session_timeout" value="<?php echo $this->params['session_timeout']; ?>">
                <p class="akeeba-help-text">
					<?php echo \Awf\Text\Text::_('SOLO_SETUP_LBL_SESSIONTIMEOUT_HELP'); ?>
                </p>
			</div>

			<div class="akeeba-form-group">
				<label for="fs_driver">
					<?php echo \Awf\Text\Text::_('SOLO_SETUP_LBL_FS_DRIVER'); ?>
				</label>
				<?php echo \Solo\Helper\Setup::fsDriverSelect($this->params['fs.driver']); ?>

                <p class="akeeba-help-text">
					<?php echo \Awf\Text\Text::_('SOLO_SETUP_LBL_FS_DRIVER_HELP'); ?>
                </p>
			</div>

			<div id="ftp_options">
				<div class="akeeba-form-group">
					<label for="fs_host">
						<?php echo \Awf\Text\Text::_('SOLO_SETUP_LBL_FS_FTP_HOST'); ?>
					</label>
                    <input type="text" name="fs_host" id="fs_host" value="<?php echo $this->params['fs.host']; ?>">
                    <p class="akeeba-help-text">
						<?php echo \Awf\Text\Text::_('SOLO_SETUP_LBL_FS_FTP_HOST_HELP'); ?>
                    </p>
				</div>

				<div class="akeeba-form-group">
					<label for="fs_port">
						<?php echo \Awf\Text\Text::_('SOLO_SETUP_LBL_FS_FTP_PORT'); ?>
					</label>
                    <input type="text" name="fs_port" id="fs_port" value="<?php echo $this->params['fs.port']; ?>">
                    <p class="akeeba-help-text">
						<?php echo \Awf\Text\Text::_('SOLO_SETUP_LBL_FS_FTP_PORT_HELP'); ?>
                    </p>
				</div>

				<div class="akeeba-form-group">
					<label for="fs_username">
						<?php echo \Awf\Text\Text::_('SOLO_SETUP_LBL_FS_FTP_USERNAME'); ?>
					</label>
                    <input type="text" name="fs_username" id="fs_username" value="<?php echo $this->params['fs.username']; ?>">
                    <p class="akeeba-help-text">
						<?php echo \Awf\Text\Text::_('SOLO_SETUP_LBL_FS_FTP_USERNAME_HELP'); ?>
                    </p>
				</div>

				<div class="akeeba-form-group">
					<label for="fs_password">
						<?php echo \Awf\Text\Text::_('SOLO_SETUP_LBL_FS_FTP_PASSWORD'); ?>
					</label>
                    <input type="password" name="fs_password" id="fs_password" value="<?php echo $this->params['fs.password']; ?>">
                    <p class="akeeba-help-text">
						<?php echo \Awf\Text\Text::_('SOLO_SETUP_LBL_FS_FTP_PASSWORD_HELP'); ?>
                    </p>
				</div>

				<div class="akeeba-form-group">
					<label for="fs_directory">
						<?php echo \Awf\Text\Text::_('SOLO_SETUP_LBL_FS_FTP_DIRECTORY'); ?>
					</label>

					<input type="text" name="fs_directory" id="fs_directory" value="<?php echo $this->params['fs.directory']; ?>" />

					<p class="akeeba-help-text">
						<?php echo \Awf\Text\Text::_('SOLO_SETUP_LBL_FS_FTP_DIRECTORY_HELP'); ?>
                    </p>
				</div>
			</div>
	</div>
</div>

<div class="akeeba-panel--info">
	<header class="akeeba-block-header">
		<h3>
			<span class="akion-person-stalker"></span>
			<?php echo \Awf\Text\Text::_('SOLO_SETUP_LBL_USERSETUP'); ?>
		</h3>
	</header>
	<div>
		<p><?php echo \Awf\Text\Text::_('SOLO_SETUP_LBL_USERSETUP_TEXT'); ?></p>

		<div class="akeeba-form-group">
			<label for="user_username">
				<?php echo \Awf\Text\Text::_('SOLO_SETUP_LBL_USER_USERNAME'); ?>
			</label>
			<div class="col-sm-10">
				<input type="text" name="user_username" id="user_username" value="<?php echo $this->params['user.username']; ?>">
				<div class="help-block">
					<?php echo \Awf\Text\Text::_('SOLO_SETUP_LBL_USER_USERNAME_HELP'); ?>
				</div>
			</div>
		</div>

		<div class="akeeba-form-group">
			<label for="user_password">
				<?php echo \Awf\Text\Text::_('SOLO_SETUP_LBL_USER_PASSWORD'); ?>
			</label>
            <input type="password" name="user_password" id="user_password" value="<?php echo $this->params['user.password']; ?>">
            <p class="akeeba-help-text">
				<?php echo \Awf\Text\Text::_('SOLO_SETUP_LBL_USER_PASSWORD_HELP'); ?>
            </p>
		</div>

		<div class="akeeba-form-group">
			<label for="user_password2">
				<?php echo \Awf\Text\Text::_('SOLO_SETUP_LBL_USER_PASSWORD2'); ?>
			</label>
            <input type="password" name="user_password2" id="user_password2" value="<?php echo $this->params['user.password2']; ?>">
            <p class="akeeba-help-text">
				<?php echo \Awf\Text\Text::_('SOLO_SETUP_LBL_USER_PASSWORD2_HELP'); ?>
            </p>
		</div>

		<div class="akeeba-form-group">
			<label for="user_email">
				<?php echo \Awf\Text\Text::_('SOLO_SETUP_LBL_USER_EMAIL'); ?>
			</label>
            <input type="text" name="user_email" id="user_email" value="<?php echo $this->params['user.email']; ?>">
            <p class="akeeba-help-text">
				<?php echo \Awf\Text\Text::_('SOLO_SETUP_LBL_USER_EMAIL_HELP'); ?>
            </p>
		</div>

		<div class="akeeba-form-group">
			<label for="user_name">
				<?php echo \Awf\Text\Text::_('SOLO_SETUP_LBL_USER_NAME'); ?>
			</label>
            <input type="text" name="user_name" id="user_name" value="<?php echo $this->params['user.name']; ?>">
            <p class="akeeba-help-text">
				<?php echo \Awf\Text\Text::_('SOLO_SETUP_LBL_USER_NAME_HELP'); ?>
            </p>
		</div>

	</div>
</div>

<div class="akeeba-form-group--pull-right">
    <div class="akeeba-form-group--actions">
        <button type="submit" id="setupFormSubmit" class="akeeba-btn--primary">
            <?php echo \Awf\Text\Text::_('SOLO_BTN_SUBMIT'); ?>
        </button>
    </div>
</div>

</form>

<script type="text/javascript" language="javascript">
	// Callback routine to close the browser dialog
	var akeeba_browser_callback = null;

	akeeba.loadScripts.push(function ()
	{
		// Initialise the translations
		akeeba.Setup.translations['UI-BROWSE'] = '<?php echo Escape::escapeJS(Text::_('COM_AKEEBA_CONFIG_UI_BROWSE')); ?>';
		akeeba.Setup.translations['UI-REFRESH'] = '<?php echo Escape::escapeJS(Text::_('COM_AKEEBA_CONFIG_UI_REFRESH')); ?>';
		akeeba.Setup.translations['UI-FTPBROWSER-TITLE'] = '<?php echo Escape::escapeJS(Text::_('COM_AKEEBA_CONFIG_UI_FTPBROWSER_TITLE')); ?>';
		akeeba.Setup.translations['UI-ROOT'] = '<?php echo Escape::escapeJS(Text::_('SOLO_COMMON_LBL_ROOT')); ?>';
		akeeba.Setup.translations['UI-TESTFTP-OK'] = '<?php echo Escape::escapeJS(Text::_('COM_AKEEBA_CONFIG_DIRECTFTP_TEST_OK')); ?>';
		akeeba.Setup.translations['UI-TESTFTP-FAIL'] = '<?php echo Escape::escapeJS(Text::_('COM_AKEEBA_CONFIG_DIRECTFTP_TEST_FAIL')); ?>';
		akeeba.Setup.translations['UI-TESTSFTP-OK'] = '<?php echo Escape::escapeJS(Text::_('COM_AKEEBA_CONFIG_DIRECTSFTP_TEST_OK')); ?>';
		akeeba.Setup.translations['UI-TESTSFTP-FAIL'] = '<?php echo Escape::escapeJS(Text::_('COM_AKEEBA_CONFIG_DIRECTSFTP_TEST_FAIL')); ?>';

		// Push some custom URLs
		akeeba.Setup.URLs['ftpBrowser'] = '<?php echo Escape::escapeJS($router->route('index.php?view=ftpbrowser')); ?>';
		akeeba.Setup.URLs['sftpBrowser'] = '<?php echo Escape::escapeJS($router->route('index.php?view=sftpbrowser')); ?>';
		akeeba.Setup.URLs['testFtp'] = '<?php echo Escape::escapeJS($router->route('index.php?view=configuration&task=testftp')); ?>';
		akeeba.Setup.URLs['testSftp'] = '<?php echo Escape::escapeJS($router->route('index.php?view=configuration&task=testsftp')); ?>';
	});

</script>
