<?php
/**
 * @package    solo
 * @copyright  Copyright (c)2014-2019 Nicholas K. Dionysopoulos / Akeeba Ltd
 * @license    GNU GPL version 3 or later
 */

use Awf\Text\Text;

defined('_AKEEBA') or die();

/** @var \Solo\View\Setup\Html $this */

?>

<?php /* AdBlock warning */ ?>
<?php echo $this->loadAnyTemplate('Main/warning_adblock'); ?>

<div class="akeeba-panel--info">
    <header class="akeeba-block-header">
        <h1>
			<?php echo \Awf\Text\Text::_('SOLO_SETUP_LBL_WELCOME_HEAD'); ?>
        </h1>
    </header>
    <p>
		<?php echo \Awf\Text\Text::_('SOLO_SETUP_LBL_WELCOME'); ?>
    </p>
</div>

<!--[if IE]>
<div style="margin: 20px; padding: 20px; background-color: yellow; border: 5px solid red; font-size: 14pt;">
    <?php echo \Awf\Text\Text::sprintf('SOLO_SETUP_LBL_ANCIENTIENOTICE', 'http://windows.microsoft.com/en-us/internet-explorer/download-ie', 'http://www.google.com/chrome'); ?> ?>
</div>
<![endif]-->

<?php if(!$this->reqMet): ?>: ?>
    <div class="akeeba-block--failure">
		<?php echo \Awf\Text\Text::_('SOLO_SETUP_LBL_REQUIREDREDTEXT'); ?>
    </div>
<?php endif; ?>

<div class="akeeba-panel--<?php echo $this->reqMet ? 'green' : 'red'; ?>" id="settingsRequired">
    <header class="akeeba-block-header">
        <h3>
            <span class="akion-<?php echo $this->reqMet ? 'checkmark' : 'alert'; ?>-circled"></span>
			<?php echo \Awf\Text\Text::_('SOLO_SETUP_HEADER_REQUIRED'); ?>
        </h3>
    </header>
    <div>
        <p><?php echo \Awf\Text\Text::_('SOLO_SETUP_LBL_REQUIRED'); ?></p>
        <table class="akeeba-table--striped">
            <thead>
            <tr>
                <th><?php echo \Awf\Text\Text::_('SOLO_SETUP_LBL_SETTING'); ?></th>
                <th><?php echo \Awf\Text\Text::_('SOLO_SETUP_LBL_CURRENT_SETTING'); ?></th>
            </tr>
            </thead>
            <tbody>
			<?php foreach($this->reqSettings as $option): ?>
                <tr>
                    <td>
						<?php echo $option['label']; ?>

						<?php if(array_key_exists('notice', $option)): ?>
                            <div class="help-block">
								<?php echo $option['notice']; ?>

                            </div>
						<?php endif; ?>
                    </td>
                    <td>
                        <span class="akeeba-label--<?php echo $option['current'] ? 'green' : ($option['warning'] ? 'orange' : 'red'); ?>">
                            <?php echo $option['current'] ? Text::_('SOLO_YES') : Text::_('SOLO_NO'); ?>

                        </span>
                    </td>
                </tr>
			<?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<div class="akeeba-panel--<?php echo $this->recMet ? 'green' : 'orange'; ?>" id="settingsRecommended">
    <header class="akeeba-block-header">
        <h3>
            <span class="akion-<?php echo $this->recMet ? 'checkmark' : 'alert'; ?>-circled"></span>
			<?php echo \Awf\Text\Text::_('SOLO_SETUP_HEADER_RECOMMENDED'); ?>
        </h3>
    </header>
    <div>
        <p><?php echo \Awf\Text\Text::_('SOLO_SETUP_LBL_RECOMMENDED'); ?></p>
        <table class="akeeba-table--striped" width="100%">
            <thead>
            <tr>
                <th><?php echo \Awf\Text\Text::_('SOLO_SETUP_LBL_SETTING'); ?></th>
                <th><?php echo \Awf\Text\Text::_('SOLO_SETUP_LBL_RECOMMENDED_VALUE'); ?></th>
                <th><?php echo \Awf\Text\Text::_('SOLO_SETUP_LBL_CURRENT_SETTING'); ?></th>
            </tr>
            </thead>
            <tbody>
			<?php foreach ($this->recommendedSettings as $option): ?>
                <tr>
                    <td>
						<?php echo $option['label']; ?>

                    </td>
                    <td>
                        <span class="akeeba-label--grey">
                            <?php echo $option['recommended'] ? Text::_('SOLO_ON') : Text::_('SOLO_OFF'); ?>

                        </span>
                    </td>
                    <td>
                        <span class="akeeba-label--<?php echo ($option['current'] == $option['recommended']) ? 'green' : 'orange'; ?>">
                            <?php echo $option['current'] ? Text::_('SOLO_ON') : Text::_('SOLO_OFF'); ?>

                        </span>
                    </td>
                </tr>
			<?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

