<?php
/**
 * @package    solo
 * @copyright  Copyright (c)2014-2019 Nicholas K. Dionysopoulos / Akeeba Ltd
 * @license    GNU GPL version 3 or later
 */

use Awf\Text\Text;
use Awf\Uri\Uri;
use Awf\Utils\Template;

defined('_AKEEBA') or die();

/** @var \Solo\View\Setup\Html $this */

Template::addJs('media://js/solo/setup.js', $this->getContainer()->application);

$router = $this->getContainer()->router;
?>

<div class="akeeba-panel--info">
    <header class="akeeba-block-header">
        <h1>
			<?php echo \Awf\Text\Text::_('SOLO_SETUP_SUBTITLE_DATABASE'); ?>
        </h1>
    </header>
    <p>
		<?php echo \Awf\Text\Text::_('SOLO_SETUP_LBL_DATABASE_INFO'); ?>
    </p>
</div>

<form action="<?php echo $this->container->router->route('index.php?view=setup&task=installdb'); ?>" method="post" role="form"
      name="dbForm"
      class="akeeba-form--horizontal" >

    <div class="akeeba-form-group">
		<label for="driver" >
			<?php echo \Awf\Text\Text::_('SOLO_SETUP_LBL_DATABASE_DRIVER'); ?>
		</label>
		<?php echo \Solo\Helper\Setup::databaseTypesSelect($this->connectionParameters['driver']); ?>

        <p class="akeeba-help-text">
			<?php echo \Awf\Text\Text::_('SOLO_SETUP_LBL_DATABASE_DRIVER_HELP'); ?>
        </p>
	</div>

	<div class="akeeba-form-group" id="host-wrapper">
		<label for="host" >
			<?php echo \Awf\Text\Text::_('SOLO_SETUP_LBL_DATABASE_HOST'); ?>
		</label>
        <input type="text" id="host" name="host" placeholder="<?php echo \Awf\Text\Text::_('SOLO_SETUP_LBL_DATABASE_HOST'); ?>" value="<?php echo $this->connectionParameters['host']; ?>">
        <p class="akeeba-help-text">
			<?php echo \Awf\Text\Text::_('SOLO_SETUP_LBL_DATABASE_HOST_HELP'); ?>
        </p>
	</div>

	<div class="akeeba-form-group" id="user-wrapper">
		<label for="user" >
			<?php echo \Awf\Text\Text::_('SOLO_SETUP_LBL_DATABASE_USER'); ?>
		</label>
        <input type="text" id="user" name="user" placeholder="<?php echo \Awf\Text\Text::_('SOLO_SETUP_LBL_DATABASE_USER'); ?>" value="<?php echo $this->connectionParameters['user']; ?>">
        <p class="akeeba-help-text">
			<?php echo \Awf\Text\Text::_('SOLO_SETUP_LBL_DATABASE_USER_HELP'); ?>
        </p>
	</div>

	<div class="akeeba-form-group" id="pass-wrapper">
		<label for="pass" >
			<?php echo \Awf\Text\Text::_('SOLO_SETUP_LBL_DATABASE_PASS'); ?>
		</label>
        <input type="password" id="pass" name="pass" placeholder="<?php echo \Awf\Text\Text::_('SOLO_SETUP_LBL_DATABASE_PASS'); ?>" value="<?php echo $this->connectionParameters['pass']; ?>">
        <p class="akeeba-help-text">
			<?php echo \Awf\Text\Text::_('SOLO_SETUP_LBL_DATABASE_PASS_HELP'); ?>
        </p>
	</div>

	<div class="akeeba-form-group" id="name-wrapper">
		<label for="name" >
			<?php echo \Awf\Text\Text::_('SOLO_SETUP_LBL_DATABASE_NAME'); ?>
		</label>
        <input type="text" id="name" name="name" placeholder="<?php echo \Awf\Text\Text::_('SOLO_SETUP_LBL_DATABASE_NAME'); ?>" value="<?php echo $this->connectionParameters['name']; ?>">
        <p class="akeeba-help-text">
			<?php echo \Awf\Text\Text::_('SOLO_SETUP_LBL_DATABASE_NAME_HELP'); ?>
        </p>
	</div>

	<div class="akeeba-form-group" id="prefix-wrapper">
		<label for="prefix" >
			<?php echo \Awf\Text\Text::_('SOLO_SETUP_LBL_DATABASE_PREFIX'); ?>
		</label>
        <input type="text" id="prefix" name="prefix" placeholder="<?php echo \Awf\Text\Text::_('SOLO_SETUP_LBL_DATABASE_PREFIX'); ?>" value="<?php echo $this->connectionParameters['prefix']; ?>">
        <p class="akeeba-help-text">
			<?php echo \Awf\Text\Text::_('SOLO_SETUP_LBL_DATABASE_PREFIX_HELP'); ?>
        </p>
	</div>

    <div class="akeeba-form-group--pull-right">
        <div class="akeeba-form-group--actions">
            <button type="submit" id="dbFormSubmit" class="akeeba-btn--primary">
		        <?php echo \Awf\Text\Text::_('SOLO_BTN_SUBMIT'); ?>
            </button>
        </div>
	</div>
</form>
