<?php
/**
 * @package    solo
 * @copyright  Copyright (c)2014-2019 Nicholas K. Dionysopoulos / Akeeba Ltd
 * @license    GNU GPL version 3 or later
 */

use Awf\Text\Text;

defined('_AKEEBA') or die();

/** @var \Solo\View\Remotefiles\Html $this */

$router = $this->getContainer()->router;

// Is the engine incapable of any action?
$noCapabilities = !$this->capabilities['delete'] && !$this->capabilities['downloadToFile']
	&& !$this->capabilities['downloadToBrowser'];

// Are all remote files no longer present?
$downloadToFileNotAvailable = !$this->actions['downloadToFile'] && $this->capabilities['downloadToFile'];
$deleteNotAvailable         = !$this->actions['delete'] && $this->capabilities['delete'];
$allRemoteFilesGone         = $downloadToFileNotAvailable && $deleteNotAvailable;

?>
<script type="text/javascript">
    function akeebaBackupRemoteFilesShowWait()
    {
        document.getElementById("akeebaBackupRemoteFilesWorkInProgress").style.display = "block";
        document.getElementById("akeebaBackupRemoteFilesMainInterface").style.display  = "none";
    }
</script>

<div class="akeeba-panel--info" id="akeebaBackupRemoteFilesWorkInProgress" style="text-align: center; display: none">
	<header class="akeeba-block-header">
		<h3><?php echo \Awf\Text\Text::_('COM_AKEEBA_REMOTEFILES_INPROGRESS_HEADER'); ?></h3>
	</header>
	<img src="<?php echo \Awf\Uri\Uri::base(false, $this->getContainer()); ?>media/image/spinner.gif"
		 alt="<?php echo \Awf\Text\Text::_('COM_AKEEBA_REMOTEFILES_INPROGRESS_LBL_PLEASEWAIT'); ?>" />
	<p>
		<?php echo \Awf\Text\Text::_('COM_AKEEBA_REMOTEFILES_INPROGRESS_LBL_UNDERWAY'); ?>
	</p>
	<p>
		<?php echo \Awf\Text\Text::_('COM_AKEEBA_REMOTEFILES_INPROGRESS_LBL_WAITINGINFO'); ?>
	</p>
</div>

<div id="akeebaBackupRemoteFilesMainInterface">

	<div class="akeeba-panel--primary">
		<header class="akeeba-block-header">
			<h3><?php echo \Awf\Text\Text::_('COM_AKEEBA_REMOTEFILES'); ?></h3>
		</header>

		<?php /* ===== No capabilities ===== */ ?>
		<?php if($noCapabilities): ?>
			<div class="akeeba-block--failure">
				<h3>
					<?php echo \Awf\Text\Text::_('COM_AKEEBA_REMOTEFILES_ERR_NOTSUPPORTED_HEADER'); ?>
				</h3>
				<p>
					<?php echo \Awf\Text\Text::_('COM_AKEEBA_REMOTEFILES_ERR_NOTSUPPORTED'); ?>
				</p>
			</div>
		<?php /* ===== Remote files gone, no operations available ===== */ ?>
		<?php elseif($deleteNotAvailable): ?>
			<div class="akeeba-block--failure">
				<h3>
					<?php echo \Awf\Text\Text::_('COM_AKEEBA_REMOTEFILES_ERR_NOTSUPPORTED_HEADER'); ?>
				</h3>
				<p>
					<?php echo \Awf\Text\Text::_('COM_AKEEBA_REMOTEFILES_ERR_NOTSUPPORTED_ALREADYONSERVER'); ?>
				</p>
			</div>
		<?php else: ?>
			<?php if($this->actions['downloadToFile']): ?>
				<a class="akeeba-btn--teal"
				   href="<?php echo $router->route(sprintf("index.php?view=Remotefiles&task=downloadToServer&tmpl=component&id=%d&part=-1", $this->id)); ?>"
				   onclick="akeebaBackupRemoteFilesShowWait();"
				>
					<span class="akion-android-download"></span>
					<span><?php echo \Awf\Text\Text::_('COM_AKEEBA_REMOTEFILES_FETCH'); ?></span>
				</a>
			<?php else: ?>
				<button class="akeeba-btn--teal" disabled onclick="return false;"
						title="<?php echo \Awf\Text\Text::_($this->capabilities['downloadToFile'] ? 'COM_AKEEBA_REMOTEFILES_ERR_DOWNLOADEDTOFILE_ALREADY' : 'COM_AKEEBA_REMOTEFILES_ERR_UNSUPPORTED'); ?>">
					<span class="akion-android-download"></span>
					<span><?php echo \Awf\Text\Text::_('COM_AKEEBA_REMOTEFILES_FETCH'); ?></span>
				</button>
			<?php endif; ?>

			<?php if($this->actions['delete']): ?>
				<a class="akeeba-btn--red"
				   href="<?php echo $router->route(sprintf("index.php?view=Remotefiles&task=delete&tmpl=component&id=%d&part=-1", $this->id)); ?>"
				   onclick="akeebaBackupRemoteFilesShowWait();"
				>
					<span class="akion-trash-a"></span>
					<span><?php echo \Awf\Text\Text::_('COM_AKEEBA_REMOTEFILES_DELETE'); ?></span>
				</a>
			<?php else: ?>
				<button class="akeeba-btn--teal" disabled onclick="return false;"
						title="<?php echo \Awf\Text\Text::_($this->capabilities['delete'] ? 'COM_AKEEBA_REMOTEFILES_ERR_DELETE_ALREADY' : 'COM_AKEEBA_REMOTEFILES_ERR_UNSUPPORTED'); ?>">
					<span class="akion-trash-a"></span>
					<span><?php echo \Awf\Text\Text::_('COM_AKEEBA_REMOTEFILES_DELETE'); ?></span>
				</button>
			<?php endif; ?>
		<?php endif; ?>
	</div>

	<?php if($this->actions['downloadToBrowser'] != 0): ?>
		<div class="akeeba-panel--info">
			<header class="akeeba-block-header">
				<h3><?php echo \Awf\Text\Text::_('COM_AKEEBA_REMOTEFILES_LBL_DOWNLOADLOCALLY'); ?></h3>
			</header>

			<?php for($part = 0; $part < $this->actions['downloadToBrowser']; $part++): ?>
				<a href="<?php echo $router->route(sprintf("index.php?view=Remotefiles&task=downloadFromRemote&id=%d&part=%d", $this->id, $part)); ?>"
				   class="akeeba-btn--small--grey">
					<span class="akion-ios-download"></span>
					<?php echo \Awf\Text\Text::sprintf('COM_AKEEBA_REMOTEFILES_PART', $part); ?>
				</a>
			<?php endfor; ?>
		</div>
	<?php endif; ?>

</div>
