<?php
/**
 * @package    solo
 * @copyright  Copyright (c)2014-2019 Nicholas K. Dionysopoulos / Akeeba Ltd
 * @license    GNU GPL version 3 or later
 */

use Awf\Text\Text;

defined('_AKEEBA') or die();

// Used for type hinting
/** @var  \Solo\View\Login\Html  $this */

?>
<form class="akeeba-form--stretch" role="form" action="<?php echo $this->container->router->route('index.php?view=login&task=login'); ?>"
      method="POST" id="loginForm">

    <div class="akeeba-panel--info">
        <header class="akeeba-block-header">
            <h2>
		        <?php echo \Awf\Text\Text::_('SOLO_LOGIN_PLEASELOGIN'); ?>
            </h2>
        </header>

        <div class="akeeba-form-group">
            <input type="text" id="username" name="username" class="form-control" placeholder="<?php echo \Awf\Text\Text::_('SOLO_LOGIN_LBL_USERNAME'); ?>" required autofocus value="<?php echo $this->escape($this->username); ?>">
        </div>
        <div class="akeeba-form-group">
            <input type="password" id="password" name="password" class="form-control" placeholder="<?php echo \Awf\Text\Text::_('SOLO_LOGIN_LBL_PASSWORD'); ?>" required value="<?php echo $this->escape($this->password); ?>">
        </div>

	    <?php if(!defined('AKEEBADEBUG')): ?>
        <div class="akeeba-form-group">
            <input type="text" name="secret" class="form-control" placeholder="<?php echo \Awf\Text\Text::_('SOLO_LOGIN_LBL_SECRETCODE'); ?>" value="<?php echo $this->escape($this->secret); ?>">
        </div>
	    <?php endif; ?>

        <div class="akeeba-form-group--actions">
            <button class="akeeba-btn--primary--block" style="width: 100%" type="submit" id="btnLoginSubmit">
                <span class="akion-log-in"></span>
			    <?php echo \Awf\Text\Text::_('SOLO_LOGIN_LBL_LOGIN'); ?>
            </button>
        </div>

        <div class="akeeba-hidden-fields-container">
            <input type="hidden" name="token" value="<?php echo $this->container->session->getCsrfToken()->getValue(); ?>">
        </div>
    </div>

</form>

<?php if($this->autologin): ?>
<script type="text/javascript">
akeeba.System.documentReady({
    document.getElementById('loginForm').submit();
})
</script>
<?php endif; ?>
