<?php
/**
 * @package    solo
 * @copyright  Copyright (c)2014-2019 Nicholas K. Dionysopoulos / Akeeba Ltd
 * @license    GNU GPL version 3 or later
 */

defined('_AKEEBA') or die;

/** @var  Solo\View\Alice\Html $this */

$js = <<< JS

;// This comment is intentionally put here to prevent badly written plugins from causing a Javascript error
// due to missing trailing semicolon and/or newline in their code.
function postMyForm()
{
	document.forms.adminForm.submit();
}

akeeba.System.documentReady(function(){
	window.setTimeout(postMyForm, 250);
});

JS;
?>
<?php $this->container->application->getDocument()->addScriptDeclaration($js); ?>


<div class="akeeba-panel--info">
	<header class="akeeba-block-header">
		<h3>
			<?php echo \Awf\Text\Text::_('COM_AKEEBA_ALICE_ANALYZE_LABEL_PROGRESS'); ?>
		</h3>
	</header>
	<h4>
		<?php echo $this->currentSection; ?>

	</h4>
	<p>
		<?php echo $this->currentCheck; ?>

	</p>
	<div class="akeeba-progress">
		<div class="akeeba-progress-fill" style="width:<?php echo $this->percentage; ?>%"></div>
		<div class="akeeba-progress-status">
			<?php echo $this->percentage; ?>%
		</div>
	</div>
	<p>
		<img src="<?php echo \Awf\Utils\Template::parsePath('media://com_akeeba/icons/spinner.gif'); ?>"
			 alt="<?php echo \Awf\Text\Text::_('COM_AKEEBA_ALICE_ANALYZE_LABEL_PROGRESS'); ?>" />
	</p>
</div>

<form name="adminForm" id="adminForm" action="<?php echo $this->container->router->route('index.php'); ?>" method="post">
	<input name="view" value="Alice" type="hidden" />
	<input name="task" value="step" type="hidden" />
    <input type="hidden" name="token" value="<?php echo $this->container->session->getCsrfToken()->getValue(); ?>" />
</form>