<?php
/**
 * @package    solo
 * @copyright  Copyright (c)2014-2019 Nicholas K. Dionysopoulos / Akeeba Ltd
 * @license    GNU GPL version 3 or later
 */

use Awf\Text\Text;

defined('_AKEEBA') or die;

/** @var  Solo\View\Alice\Html $this */

?>
<div class="akeeba-panel--information">
    <header class="akeeba-block-header">
        <h3><?php echo \Awf\Text\Text::_('COM_AKEEBA_ALICE_ANALYSIS_REPORT_HEAD'); ?></h3>
    </header>
    <p>
        <?php echo \Awf\Text\Text::sprintf('COM_AKEEBA_ALICE_ANALYSIS_REPORT_LBL_SUMMARY', $this->doneChecks); ?>
    </p>
</div>

<?php if($this->aliceStatus == 'success'): ?>
    <p class="akeeba-block--success large">
        <?php echo \Awf\Text\Text::_('COM_AKEEBA_ALICE_ANALYSIS_REPORT_LBL_SUMMARY_SUCCESS'); ?>
    </p>
<?php elseif($this->aliceStatus == 'warnings'): ?>
    <p class="akeeba-block--warning">
        <?php echo \Awf\Text\Text::_('COM_AKEEBA_ALICE_ANALYSIS_REPORT_LBL_SUMMARY_WARNINGS'); ?>
    </p>
<?php else: ?>
    <p class="akeeba-block--failure">
        <?php echo \Awf\Text\Text::_('COM_AKEEBA_ALICE_ANALYSIS_REPORT_LBL_SUMMARY_ERRORS'); ?>
    </p>
<?php endif; ?>

<?php if($this->aliceStatus != 'success'): ?>
    <div class="akeeba-panel--<?php echo ($this->aliceStatus == 'error') ? 'danger' : 'warning'; ?>">
        <header class="akeeba-block-header">
            <?php if($this->aliceStatus == 'error'): ?>
                <?php echo \Awf\Text\Text::_('COM_AKEEBA_ALICE_ANALYSIS_REPORT_LBL_ERROR'); ?>
            <?php else: ?>
                <?php echo \Awf\Text\Text::_('COM_AKEEBA_ALICE_ANALYSIS_REPORT_LBL_WARNINGS'); ?>
            <?php endif; ?>
        </header>

        <?php if($this->aliceStatus == 'error'): ?>
            <h5><?php echo $this->aliceError['message']; ?></h5>
            <p>
                <em><?php echo \Awf\Text\Text::_('COM_AKEEBA_ALICE_ANALYSIS_REPORT_LBL_SOLUTION'); ?></em>
                <?php echo $this->aliceError['solution']; ?>

            </p>
        <?php else: ?>
            <table class="akeeba-table--striped" width="100%">
            <tbody>
            <?php foreach($this->aliceWarnings as $warning): ?>
                <tr>
                    <td>
                        <h5><?php echo $warning['message']; ?></h5>
                        <p>
                            <em><?php echo \Awf\Text\Text::_('COM_AKEEBA_ALICE_ANALYSIS_REPORT_LBL_SOLUTION'); ?></em>
                            <?php echo $warning['solution']; ?>

                        </p>
                    </td>
                </tr>
            <?php endforeach; ?>
            </tbody>
            </table>
        <?php endif; ?>
    </div>

    <p>
        <?php echo \Awf\Text\Text::_('COM_AKEEBA_ALICE_ANALYSIS_REPORT_LBL_NEXTSTEPS'); ?>
    </p>
<?php endif; ?>