<?php
/**
 * @package    solo
 * @copyright  Copyright (c)2014-2019 Nicholas K. Dionysopoulos / Akeeba Ltd
 * @license    GNU GPL version 3 or later
 */

use Awf\Html;

defined('_AKEEBA') or die;

/** @var  Solo\View\Alice\Html $this */
?>
<?php if(empty($this->logs)): ?>
	<div class="akeeba-block--failure">
		<p><?php echo \Awf\Text\Text::_('COM_AKEEBA_LOG_NONE_FOUND'); ?></p>
	</div>
	<?php return; ?>
<?php endif; ?>

<form name="adminForm" id="adminForm" action="<?php echo $this->container->router->route('index.php?view=Alice'); ?>"
	  method="post" class="akeeba-form--inline">
	<?php if($this->autorun): ?>
		<div class="akeeba-block--warning">
			<p>
				<?php echo \Awf\Text\Text::_('ALICE_AUTORUN_NOTICE'); ?>
			</p>
		</div>
	<?php endif; ?>

	<div class="akeeba-form-group">
		<label for="tag">
			<?php echo \Awf\Text\Text::_('COM_AKEEBA_LOG_CHOOSE_FILE_TITLE'); ?>
		</label>
		<?php echo \Awf\Html\Html::_('select.genericList', $this->logs, 'log', [], 'value', 'text', $this->log); ?>
	</div>

	<div class="akeeba-form-group--actions">
		<button class="akeeba-btn--primary" id="analyze-log" type="submit">
			<span class="akion-ios-analytics"></span>
			<?php echo \Awf\Text\Text::_('COM_AKEEBA_ALICE_ANALYZE'); ?>
		</button>
	</div>

	<div class="akeeba-hidden-fields-container">
        <input name="view" value="Alice" type="hidden" />
        <input name="task" value="start" type="hidden" />
        <input type="hidden" name="token" value="<?php echo $this->container->session->getCsrfToken()->getValue(); ?>" />
	</div>
</form>