<?php
/*
 * 	The template for displaying product search form
 *
 * 	This template can be overridden by copying it to yourtheme/woocommerce/product-searchform.php.
 *
 * 	HOWEVER, on occasion WooCommerce will need to update template files and you
 * 	(the theme developer) will need to copy the new files to your theme to
 * 	maintain compatibility. We try to do this as little as possible, but it does
 * 	happen. When this occurs the version of the template file will be bumped and
 * 	the readme will list any important changes.
 *
 * 	@see     https://docs.woocommerce.com/document/template-structure/
 * 	@author  WooThemes
 * 	@package WooCommerce/Templates
 * 	@version 3.3.0
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

?>
<div class="bne-search">
    <form role="search" method="get" action="<?php echo esc_url( home_url( '/' ) ); ?>">
		<div class="input-group">
			<input type="text" class="form-control search-input" placeholder="<?php echo esc_attr_x( 'Search Products&hellip;', 'woocommerce', 'bne' ); ?>" value="<?php echo get_search_query(); ?>" name="s" title="<?php echo esc_attr_x( 'Search for:', 'label', 'bne' ); ?>" />
			<input type="hidden" name="post_type" value="product" />
			<span class="input-group-append">
				<button class="btn btn-default" type="submit">
					<i class="bne fas fa-search"></i>
				</button>
			</span>
		</div>
	</form>
</div>