<?php
/**
 * Checkout Form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/form-checkout.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.5.0
 */

/* BNE Creative Notes:
 * - Placed billing and shipping into Bootstrap columns
 * - Placed order in Bootstrap column
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// BNE - Check for page column sizes
$col_fields = $col_order = 'col-sm-12';
$col_inner_fields = 'col-md-6';
if( 'no-sidebar' == bne_get_page_option( 'sidebar_layout' ) ) {
	$col_fields = 'col-sm-6 col-md-7';
	$col_order = 'col-sm-6 col-md-5';
	$col_inner_fields = 'col-lg-6';
}

wc_print_notices();

do_action( 'woocommerce_before_checkout_form', $checkout );

// If checkout registration is disabled and not logged in, the user cannot checkout
if ( ! $checkout->is_registration_enabled() && $checkout->is_registration_required() && ! is_user_logged_in() ) {
	echo esc_html( apply_filters( 'woocommerce_checkout_must_be_logged_in_message', __( 'You must be logged in to checkout.', 'woocommerce' ) ) );
	return;
}


?>
<form name="checkout" method="post" class="checkout woocommerce-checkout" action="<?php echo esc_url( wc_get_checkout_url() ); ?>" enctype="multipart/form-data">

	<div class="row">
		<div class="<?php echo $col_fields; ?>">
			
			<?php if ( $checkout->get_checkout_fields() ) : ?>
				<?php do_action( 'woocommerce_checkout_before_customer_details' ); ?>
				
				<div id="customer_details">
					<div class="row">
						<div class="<?php echo $col_inner_fields; ?> clearfix">
							<?php do_action( 'woocommerce_checkout_billing' ); ?>
						</div><!-- .col (end) -->
						<div class="<?php echo $col_inner_fields; ?> clearfix">
							<?php do_action( 'woocommerce_checkout_shipping' ); ?>
						</div>
					</div>
				</div>
		
				<?php do_action( 'woocommerce_checkout_after_customer_details' ); ?>
			<?php endif; ?>
			
		</div><!-- .col (end) -->
		<div class="<?php echo $col_order; ?>">

			<h3 id="order_review_heading"><?php esc_html_e( 'Your order', 'woocommerce' ); ?></h3>

			<?php do_action( 'woocommerce_checkout_before_order_review' ); ?>

			<div id="order_review" class="woocommerce-checkout-review-order">
				<?php do_action( 'woocommerce_checkout_order_review' ); ?>
			</div>
		
			<?php do_action( 'woocommerce_checkout_after_order_review' ); ?>

		</div><!-- .col (end) -->
	</div><!-- .row (end) -->

</form>

<?php do_action( 'woocommerce_after_checkout_form', $checkout ); ?>
