<?php
/*
 * 	The template used for displaying page content in the template_sitemap.php
 *
 * 	@package 	BNE WordPress Framework
 *	@updated	v2.0
 *
*/
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

	<?php if( 'hide' != get_post_meta( get_the_id(), 'bne_title', true ) ) { ?>
		<header class="entry-header page-heading">
			<h1 class="entry-title"><?php the_title(); ?></h1>
		</header><!-- .entry-header -->
	<?php } ?>

	<div class="entry-content">

		<?php rewind_posts(); ?>
        
        <?php while( have_posts() ) : the_post(); ?>
			<?php the_content(); ?>
		<?php endwhile; // end of the loop. ?>

		<div class="row">
			<div class="col-sm-6">
		        <h3><?php esc_html_e( 'Pages:', 'bne' ); ?></h3>
		        <ul><?php wp_list_pages( 'depth=0&sort_column=name&title_li=' ); ?></ul>
			</div>
			<div class="col-sm-6">
		        <h3><?php esc_html_e( 'Categories:', 'bne'); ?></h3>
		        <ul><?php wp_list_categories('title_li=&hierarchical=0&show_count=1' ) ?></ul>
		
		        <h3><?php esc_html_e( 'Posts per category', 'bne' ); ?></h3>
		        <?php $cats = get_categories(); ?>
		        <?php foreach ($cats as $cat) : ?>
		            <?php query_posts('cat='.$cat->cat_ID.'suppress_filters => false'); ?>
		                <h4><?php echo $cat->cat_name; ?></h4>
		                <ul>
		                    <?php while (have_posts()) : the_post(); ?>
		                    <li><a href="<?php the_permalink() ?>"><?php the_title(); ?></a> - <?php echo esc_html__( 'Comments', 'bne' ); ?> (<?php echo $post->comment_count ?>)</li>
		                    <?php endwhile; wp_reset_query(); ?>
		                </ul>
		        <?php endforeach; ?>
			</div>
		</div>

		<?php wp_link_pages(); ?>

	</div><!-- .entry-content -->

</article><!-- #post-## -->