<?php
/*
 * 	The template part for displaying a message that posts cannot be found.
 *
 * 	@package BNE WordPress Framework
 *
*/
?>

<section class="no-results not-found">

	<header class="entry-header page-heading">
		<h1 class="entry-title"><?php _e( 'Nothing Found', 'bne' ); ?></h1>
	</header><!-- .page-heading (end) -->

	<div class="entry-content">
		<?php if( is_home() && current_user_can( 'publish_posts' ) ) : ?>

			<p><?php printf( __( 'Ready to publish your first post? <a href="%1$s">Get started here</a>.', 'bne' ), esc_url( admin_url( 'post-new.php' ) ) ); ?></p>

		<?php elseif( is_search() ) : ?>

			<p><?php esc_html_e( 'Sorry, but nothing matched your search terms. Please try again with different keywords.', 'bne' ); ?></p>
			<?php get_search_form(); ?>

		<?php else : ?>

			<p><?php esc_html_e( 'It seems we can&rsquo;t find what you&rsquo;re looking for. Perhaps searching can help.', 'bne' ); ?></p>
			<?php get_search_form(); ?>

		<?php endif; ?>
	</div><!-- .entry-content (end) -->

</section><!-- .no-results (end) -->