<?php
/*
 * 	The template used for displaying single content
 *	in archive.php and post-list templates.
 *
 * 	@package 	BNE WordPress Framework
 *	@updated	v2.1.6
 *
*/
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

	<header class="entry-header">
		<h2 class="entry-title">
			<a href="<?php echo the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a>
		</h2>
	</header><!-- .entry-header -->

	<?php echo bne_post_meta(); ?>

	<div class="entry-content">

		<?php
			$image_style = get_theme_mod( 'post_archive_thumbnail_style', 'flat' );
			echo bne_post_thumbnail( '', '', 'is-style-'.$image_style ); 
			
			the_excerpt();

			echo '<p><a href="'.get_the_permalink().'" title="'.the_title_attribute( array( 'echo' => false ) ).'" class="btn btn-default btn-readmore">'.get_theme_mod('post_read_more_label', 'Read More' ).'</a></p>';
			?>

	</div><!-- .entry-content -->

	<div class="clear"></div>

</article><!-- #post-## -->