<?php
/*
 * 	The template used for displaying single content
 *	in a post-grid template.
 *
 * 	@package 	BNE WordPress Framework
 *	@updated	v2.1.6
 *
*/

?>

<article id="post-<?php the_ID(); ?>" <?php post_class( get_theme_mod( 'post_archive_grid_style', 'flat' ) ); ?>>
	<?php 
		$image_style = get_theme_mod( 'post_archive_thumbnail_style', 'default' );
		echo bne_post_thumbnail( '', '', 'card-img-top is-style-'.$image_style ); 
	?>

	<div class="card-body">
		<header class="entry-header card-title">
			<h3 class="entry-title">
				<a href="<?php echo the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a>
			</h3>
		</header><!-- .entry-header -->
		
		<?php echo bne_post_meta( null, $return = array( 'date', 'author', 'comments' ) ); ?>
	
		<div class="entry-content card-text">
	
			<?php the_excerpt(); ?>
	
			<?php echo '<p><a href="'.get_the_permalink().'" title="'.the_title_attribute( array( 'echo' => false ) ).'" class="btn btn-default btn-readmore">'.get_theme_mod('post_read_more_label', 'Read More' ).'</a></p>'; ?>
	
		</div><!-- /.entry-content -->

	</div> <!-- /.card-body -->
</article><!-- /#post-## -->