<?php
/*
 * 	The default template for displaying a single attachment.
 *
 * 	@package BNE WordPress Framework
 *
*/
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

	<header class="entry-header page-heading">
		<h1 class="entry-title">
			<a href="<?php echo the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a>
		</h1>
	</header><!-- .entry-header -->

	<div class="entry-content">

		<?php if( wp_attachment_is_image( get_the_ID() ) ) : ?>
			<p class="attachment">
				<a href="<?php echo wp_get_attachment_url( get_the_ID() ); ?>" title="<?php the_title(); ?>" rel="attachment">
					<?php echo wp_get_attachment_image( get_the_id(), 'full' ); ?>
				</a>
			</p>
		<?php endif; ?>

		<?php the_content(); ?>

	</div><!-- .entry-content -->

	<div class="clear"></div>

</article><!-- #post-## -->