<?php
/*
 * 	The template used for displaying page content in the template_archive.php
 *
 * 	@package 	BNE WordPress Framework
 *	@updated	v2.0
 *
*/
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

	<?php if( 'hide' != get_post_meta( get_the_id(), 'bne_title', true ) ) { ?>
		<header class="entry-header page-heading">
			<h1 class="entry-title"><?php the_title(); ?></h1>
		</header><!-- .entry-header -->
	<?php } ?>

	<div class="entry-content">
		
		<?php rewind_posts(); ?>
        <?php while( have_posts() ) : the_post(); ?>
			<?php the_content(); ?>
		<?php endwhile; // end of the loop. ?>
		
        <h2><?php esc_html_e( 'The Last 30 Posts', 'bne' ); ?></h2>
        <ul>
            <?php query_posts('showposts=30&suppress_filters => false'); ?>
            <?php if( have_posts() ) : while ( have_posts() ) : the_post(); ?>
                <?php $wp_query->is_home = false; ?>
                <li><a href="<?php the_permalink() ?>"><?php the_title(); ?></a> - <?php the_time(get_option('date_format')); ?> - <?php echo $post->comment_count ?> <?php echo esc_html__( 'Comments', 'bne' ); ?></li>
            <?php endwhile; endif; wp_reset_query(); ?>
        </ul>

        <h2><?php esc_html_e( 'Categories:', 'bne' ); ?></h2>
        <ul><?php wp_list_categories( 'title_li=&hierarchical=0&show_count=1' ) ?></ul>

        <h2><?php esc_html_e( 'Monthly Archives:', 'bne' ); ?></h2>
        <ul><?php wp_get_archives( 'type=monthly&show_post_count=1' ) ?></ul>
	</div><!-- .entry-content (end) -->

</article><!-- #post-## -->