<?php
/*
 * 	The template file for single post.
 *
 * 	WARNING: This template file is a core part of the
 * 	BNE WordPress Framework. It is advised
 * 	that any edits to the way this file displays its
 * 	content be done with via hooks, filters, and
 * 	template parts.
 *
 *	@author		Kerry Kline
 * 	@copyright	Copyright (c) Kerry Kline
 * 	@link		http://www.bnecreative.com
 * 	@package 	BNE WordPress Framework
 *	@updated	v2.1
 *
*/

get_header(); ?>

	<div id="sidebar_layout" class="single-template clearfix">
		<div class="row">

			<!-- CONTENT (start) -->

			<div id="content" class="<?php echo bne_get_column_class( 'content' ); ?> clearfix" role="main" >

				<?php while( have_posts() ) : the_post(); ?>

					<?php get_template_part( 'template-parts/content', 'single' ); ?>

					<?php 
						$single_nav = get_theme_mod( 'post_single_nav', 'hide' );
						if( 'show' == $single_nav ) {
							bne_pagination( 'nav-below' );
						} 
					?>
					
					<?php 
						$author_box = get_theme_mod( 'post_author_box', 'hide' );
						if( 'show' == $author_box ) {
							bne_post_author_box();
						}
					?>

					<?php bne_single_footer(); ?>

					<?php if( comments_open() || '0' != get_comments_number() ) { ?>
						<?php comments_template(); ?>
					<?php } ?>
					
				<?php endwhile; // end of the loop. ?>

			</div> <!-- #content (end) -->

			<!-- CONTENT (end) -->

			<!-- SIDEBARS (start) -->

			<?php bne_sidebars('left'); ?>

			<?php bne_sidebars('right'); ?>

			<!-- SIDEBARS (end) -->

		</div> <!-- .row (end) -->
	</div> <!-- .sidebar_layout.single-template (end) -->

<?php get_footer(); ?>