<?php
/*
 * 	The template file for search field.
 *
 * 	WARNING: This template file is a core part of the
 * 	BNE WordPress Framework. It is advised
 * 	that any edits to the way this file displays its
 * 	content be done with via hooks, filters, and
 * 	template parts.
 *
 * 	@author		Kerry Kline
 * 	@copyright	Copyright (c) Kerry Kline
 * 	@link		http://www.bnecreative.com
 * 	@package 	BNE WordPress Framework
 *	@updated	v2.0
 *
*/
?>

<div class="bne-search" role="search">
    <form method="get" action="<?php echo home_url( '/' ); ?>">
		<div class="input-group">
			<input type="text" class="form-control search-input" name="s" placeholder="<?php echo esc_attr_x( 'Search &hellip;', 'placeholder', 'bne' ); ?>" value="<?php echo esc_attr( get_search_query() ); ?>" title="<?php _ex( 'Search for:', 'label', 'bne' ); ?>" aria-label="<?php _ex( 'Search for:', 'label', 'bne' ); ?>">
			<span class="input-group-append">
				<button class="btn btn-default" type="submit" aria-label="<?php _e( 'Search', 'bne' ); ?>">
					<i class="bne-fa fa fa-search"></i>
				</button>
			</span>
		</div>
	</form>
</div>

