<?php
/*
 * 	The template file for displaying the header.
 *
 * 	WARNING: This template file is a core part of the
 * 	BNE WordPress Framework. It is advised
 * 	that any edits to the way this file displays its
 * 	content be done with via hooks, filters, and
 * 	template parts.
 *
 * 	@author		Kerry Kline
 * 	@copyright	Copyright (c) Kerry Kline
 * 	@link		http://www.bnecreative.com
 * 	@package 	BNE WordPress Framework
 *	@updated	v2.0
 *
*/
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>" />
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link rel="profile" href="http://gmpg.org/xfn/11" />
<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
	
	<?php wp_body_open(); ?>
	
	<a class="skip-link sr-only" href="#main-content-wrapper"><?php esc_html_e( 'Skip to content', 'bne' ); ?></a>
	
	<?php bne_before(); ?>

	<div id="wrapper">
		<div id="container">

			<?php bne_header_before(); ?>
	
			<?php if( 'hide' != bne_get_page_option( 'header_display' ) ) { ?>
			
				<!-- HEADER (start) -->
				
				<div id="header-wrapper">
					<header id="branding" itemscope="itemscope" itemtype="http://schema.org/WPHeader">
						<div class="content-area-width">
	
							<?php bne_header_content_before(); ?>
							<?php bne_header_content(); ?>
							<?php bne_header_menu(); ?>
							<?php bne_header_content_after(); ?>
	
						</div><!-- .content-area-width (end) -->
					</header><!-- #branding (end) -->
				</div><!-- #header-wrapper (end) -->
				
				<!-- HEADER (end) -->
			
			<?php }
				
			bne_header_after();
			
			// Featured Area
			bne_featured_area();

			// Before Main
			bne_main_before();

			// Main Start
			bne_main_start();

			// Breadcrumbs
			bne_breadcrumbs();