<?php


/*
 * 	Register the required plugins for this theme.
 *
 *	The variable passed to tgmpa_register_plugins() should be an array of plugin
 * 	arrays.
 *
 * 	This function is hooked into tgmpa_init, which is fired within the
 * 	TGM_Plugin_Activation class constructor.
*/
function bne_theme_register_required_plugins() {

    /**
     * Array of plugin arrays. Required keys are name and slug.
     * If the source is NOT from the .org repo, then source is also required.
     */
    $plugins = apply_filters( 'bne_theme_tgm_include_plugins', array(
        array(
            'name'			=> 	'BNE Slider',
            'slug'			=> 	'bne-slider',
            'source'		=> 	'http://bne-shop.s3.amazonaws.com/tgm-plugins/bne-slider.zip',
            'required'		=> 	false,
        ),
/*
        array(
            'name'			=> 	'BNE Shortcodes',
            'slug'			=> 	'bne-shortcodes',
            'source'			=> 	'http://bne-shop.s3.amazonaws.com/tgm-plugins/bne-shortcodes.zip',
            'required'		=> 	false,
        ),
*/
        array(
            'name'			=> 	'BNE Scripts',
            'slug'			=> 	'bne-scripts',
            'source'		=> 	'http://bne-shop.s3.amazonaws.com/tgm-plugins/bne-scripts.zip',
            'required'		=> 	false,
        ),
        array(
            'name'			=> 	'BNE Widgets',
            'slug'			=> 	'bne-widgets',
            'source'		=> 	'http://bne-shop.s3.amazonaws.com/tgm-plugins/bne-widgets.zip',
            'required'		=> 	false,
        ),
        array(
            'name'			=> 	'BNE Testimonials Pro',
            'slug'			=> 	'bne-testimonials-pro',
            'source'		=> 	'http://bne-shop.s3.amazonaws.com/tgm-plugins/bne-testimonials-pro.zip',
            'required'		=> 	false,
            'external_url'	=> 	'https://www.bnecreative.com/products/testimonials-wordpress-pro/',
        ),
/*
        array(
            'name'			=> 	'Advanced WordPress Backgrounds',
            'slug'			=> 	'advanced-backgrounds',
            'required'		=> 	false,
        ),
        array(
            'name'			=> 	'Ghost Kit – Blocks Collection',
            'slug'			=> 	'ghostkit',
            'required'		=> 	false,
        ),
*/
   ) );



	/*
	 * Array of configuration settings. Amend each line as needed.
	 *
	 * TGMPA will start providing localized text strings soon. If you already have translations of our standard
	 * strings available, please help us make TGMPA even better by giving us access to these translations or by
	 * sending in a pull-request with .po file(s) with the translations.
	 *
	 * Only uncomment the strings in the config array if you want to customize the strings.
	 */
	$config = array(
		'id'           => 'bne',                 	// Unique ID for hashing notices for multiple instances of TGMPA.
		'default_path' => '',                      // Default absolute path to bundled plugins.
		'menu'         => 'tgmpa-install-plugins', // Menu slug.
		'parent_slug'  => 'plugins.php',            // Parent menu slug.
		'capability'   => 'edit_theme_options',    // Capability needed to view plugin install page, should be a capability associated with the parent menu used.
		'has_notices'  => true,                    // Show admin notices or not.
		'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
		'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
		'is_automatic' => false,                   // Automatically activate plugins after installation or not.
		'message'      => '',                      // Message to output right before the plugins table.

		'strings'      => array(
			'page_title'                      => esc_html__( 'Install Theme Plugins', 'bne' ),
			'menu_title'                      => esc_html__( 'Theme Plugins', 'bne' ),
			/* translators: %s: plugin name. */
			'installing'                      => esc_html__( 'Installing Plugin: %s', 'bne' ),
			/* translators: %s: plugin name. */
			'updating'                        => esc_html__( 'Updating Plugin: %s', 'bne' ),
			'oops'                            => esc_html__( 'Something went wrong with the plugin API.', 'bne' ),
			'notice_can_install_required'     => _n_noop(
				/* translators: 1: plugin name(s). */
				'This theme requires the following plugin: %1$s.',
				'This theme requires the following plugins: %1$s.',
				'bne'
			),
			'notice_can_install_recommended'  => _n_noop(
				/* translators: 1: plugin name(s). */
				'This theme recommends the following plugin: %1$s.',
				'This theme recommends the following plugins: %1$s.',
				'bne'
			),
			'notice_ask_to_update'            => _n_noop(
				/* translators: 1: plugin name(s). */
				'The following plugin needs to be updated to its latest version to ensure maximum compatibility with this theme: %1$s.',
				'The following plugins need to be updated to their latest version to ensure maximum compatibility with this theme: %1$s.',
				'bne'
			),
			'notice_ask_to_update_maybe'      => _n_noop(
				/* translators: 1: plugin name(s). */
				'There is an update available for: %1$s.',
				'There are updates available for the following plugins: %1$s.',
				'bne'
			),
			'notice_can_activate_required'    => _n_noop(
				/* translators: 1: plugin name(s). */
				'The following required plugin is currently inactive: %1$s.',
				'The following required plugins are currently inactive: %1$s.',
				'bne'
			),
			'notice_can_activate_recommended' => _n_noop(
				/* translators: 1: plugin name(s). */
				'The following recommended plugin is currently inactive: %1$s.',
				'The following recommended plugins are currently inactive: %1$s.',
				'bne'
			),
			'install_link'                    => _n_noop(
				'Begin installing plugin',
				'Begin installing plugins',
				'bne'
			),
			'update_link' 					  => _n_noop(
				'Begin updating plugin',
				'Begin updating plugins',
				'bne'
			),
			'activate_link'                   => _n_noop(
				'Begin activating plugin',
				'Begin activating plugins',
				'bne'
			),
			'return'                          => esc_html__( 'Return to Required Plugins Installer', 'bne' ),
			'plugin_activated'                => esc_html__( 'Plugin activated successfully.', 'bne' ),
			'activated_successfully'          => esc_html__( 'The following plugin was activated successfully:', 'bne' ),
			/* translators: 1: plugin name. */
			'plugin_already_active'           => esc_html__( 'No action taken. Plugin %1$s was already active.', 'bne' ),
			/* translators: 1: plugin name. */
			'plugin_needs_higher_version'     => esc_html__( 'Plugin not activated. A higher version of %s is needed for this theme. Please update the plugin.', 'bne' ),
			/* translators: 1: dashboard link. */
			'complete'                        => esc_html__( 'All plugins installed and activated successfully. %1$s', 'bne' ),
			'dismiss'                         => esc_html__( 'Dismiss this notice', 'bne' ),
			'notice_cannot_install_activate'  => esc_html__( 'There are one or more required or recommended plugins to install, update or activate.', 'bne' ),
			'contact_admin'                   => esc_html__( 'Please contact the administrator of this site for help.', 'bne' ),

			'nag_type'                        => '', // Determines admin notice type - can only be one of the typical WP notice classes, such as 'updated', 'update-nag', 'notice-warning', 'notice-info' or 'error'. Some of which may not work as expected in older WP versions.
		),

	);

	tgmpa( $plugins, $config );

}
add_action( 'tgmpa_register', 'bne_theme_register_required_plugins' );