<?php
/*
 * 	WooCommerce v2.3+ Integration for BNE WordPress Framework
 *
 * 	@author		Kerry Kline
 * 	@copyright	Copyright (c) Kerry Kline
 * 	@link		http://www.bnecreative.com
 * 	@package 	BNE WordPress Framework
 *
 *
*/

// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;


/*
 *	Setup Actions/Filters
 *
 *	Removes default WooCommerce hooks to provides
 *	support for the BNE Framework structure, breadcrumbs,
 *	and options.
 *
 * 	@since 		v1.1.0
 *	@updated	v2.0
 *
*/
function bne_woocommerce_init() {

	// If no WooCommerce, get out of here.
	if( ! class_exists( 'woocommerce' ) )
		return;

	// Declare Theme Support
	add_theme_support( 'woocommerce' );

	// Remove default WooCommerce wrappers
	remove_all_actions( 'woocommerce_before_main_content' );
	remove_all_actions( 'woocommerce_after_main_content' );
	remove_all_actions( 'woocommerce_sidebar' );

	// Hook in wrappers based on BNE framework structure.
	add_action( 'woocommerce_before_main_content', 'bne_woocommerce_before_main_content' );
	add_action( 'woocommerce_after_main_content', 'bne_woocommerce_after_main_content' );

	// Breadcrumbs (Shop, Archive, Single Product)
	add_filter( 'bne_breadcrumb_trail_addon', 'bne_woocommerce_breadcrumb_trail_addon');

	// Pagination (Archive)
	remove_action( 'woocommerce_after_shop_loop', 'woocommerce_pagination' );
	add_action( 'woocommerce_after_shop_loop', 'bne_pagination' );

	// Set Sidebar Layouts and Page Options
	add_filter( 'bne_get_page_option', 'bne_woocommerce_page_options');

	// Product Image Lightbox
	$wc_version = get_option( 'woocommerce_version', null );
	if( version_compare( $wc_version, '2.7', '<' ) ) {
		add_filter( 'woocommerce_single_product_image_html', 'bne_woocommerce_single_product_image_html', 99, 1 ); // single image
		add_filter( 'woocommerce_single_product_image_thumbnail_html', 'bne_woocommerce_single_product_image_html', 99, 1 ); // thumbnails
		add_action( 'wp_enqueue_scripts', function() {
			wp_dequeue_style( 'woocommerce_prettyPhoto_css' );
			wp_dequeue_script( 'prettyPhoto' );
			wp_dequeue_script( 'prettyPhoto-init' );
		}, 99 );
	} else {
		add_theme_support( 'wc-product-gallery-zoom' );
		//add_theme_support( 'wc-product-gallery-lightbox' );
		add_theme_support( 'wc-product-gallery-slider' );
	}
	
	// Shop Page Title
	add_filter( 'woocommerce_show_page_title', function() {
		if( 'hide' != get_post_meta( get_option( 'woocommerce_shop_page_id' ), 'bne_title', true ) ) {
			return true;
		}	
	});
	
	// Product Share Buttons
	if( 'show' == get_theme_mod( 'woocommerce_share_buttons' ) ) {
		add_action( 'woocommerce_share', function() {
			echo '<div class="bne-woo-share">';
				echo bne_share_buttons();
			echo '</div>';
		});
	}
	
	// For Sale markup
	add_filter('woocommerce_sale_flash', function() {
		return '<span class="bne-onsale">' . esc_html__( 'Sale!', 'bne' ) . '</span>';
	}, 10, 2 );

}
add_action( 'after_setup_theme', 'bne_woocommerce_init' );




/*
 * 	Replace PrettyPhoto with BNE Theme's Fancybox
 *	@woocommerce_single_product_image_html - main Product Featurd Image
 *	@woocommerce_single_product_image_thumbnail_html - product thumbnails
 *
 * 	@since v1.2.0
 *
*/
function bne_woocommerce_single_product_image_html( $html ) {

	// Check if lightbox is enabled from WooCommerce
	if( 'yes' == get_option( 'woocommerce_enable_lightbox' ) ) {
		// Yes... replace prettyPhoto with our Magnicifc
		$html = str_replace( 'class="', 'class="bne-lightbox ', $html );
	}

   return $html;
}




/*
 * 	Checkout Field Labels
 *
 * 	@since 		v1.5.4
 *	@updated	v2.0
 *
*/
function bne_woocommerce_checkout_fields( $fields ) {
	// Billing Labels
	foreach( $fields['billing'] as $type => $item ) {
		if( isset( $item['label'] ) ) {
			$label = $item['label'];
			$fields['billing'][$type]['class'][] = 'sr-label';
			$fields['billing'][$type]['placeholder'] = $label;
		}
	}
	
	// Shipping Labels
	foreach( $fields['shipping'] as $type => $item ) {
		if( isset( $item['label'] ) ) {
			$label = $item['label'];
			$fields['shipping'][$type]['class'][] = 'sr-label';
			$fields['shipping'][$type]['placeholder'] = $label;
		}
		
		$fields['shipping']['shipping_phone']['placeholder'] = 'Phone';
		$fields['shipping']['shipping_email']['placeholder'] = 'Email Address';
		
	}
	
  	$fields['shipping']['shipping_phone']['class'] = array('form-row-first');
  	$fields['shipping']['shipping_email']['class'] = array('form-row-last');
   
    return $fields;
}
add_filter( 'woocommerce_checkout_fields' , 'bne_woocommerce_checkout_fields' );

// Add Bootstrap field classes
add_filter('woocommerce_form_field_args', function ($args, $key, $value) {
    $args['input_class'][] = 'form-control';
    $args['class'][] = 'form-group';
    return $args;
}, 10, 3);



/*
 * 	Before main content
 *
 * 	@since 		v1.1.0
 *	@updated	v1.4.2
 *
*/
if ( !function_exists( 'bne_woocommerce_before_main_content' ) ) :
	function bne_woocommerce_before_main_content() {
		?>
		<div id="sidebar_layout" class="woocommerce-page-template clearfix">
			<div class="row">

				<div id="content" class="<?php echo bne_get_column_class('content'); ?> clearfix" role="main">
					<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
		<?php
	}
endif;



/*
 * 	After main content
 *
 * 	@since 		v1.1.0
 *	@updated	v1.4.2
 *
*/
if ( !function_exists( 'bne_woocommerce_after_main_content' ) ) :
	function bne_woocommerce_after_main_content() {
		?>
					</article>
				</div><!-- #content (end) -->

				<!-- SIDEBARS (start) -->
	
				<?php bne_sidebars('left'); ?>
	
				<?php bne_sidebars('right'); ?>
	
				<!-- SIDEBARS (end) -->

			</div><!-- .row (end) -->
		</div><!-- .woocommerce-page-template (end) -->
		<?php
	}
endif;



/*
 * 	Before Product Image
 *	@note - opens a wrapper around the product image.
 *
*/
function bne_woocommerce_before_product_image() {
	echo '<div class="product-image-wrapper">';
}
add_action( 'woocommerce_before_shop_loop_item_title', 'bne_woocommerce_before_product_image', 1 );



/*
 * 	After Product Image
 *	@note - closes a wrapper around the product image.
 *
*/
function bne_woocommerce_after_product_image() {
	echo '</div><!-- .product-image-wrapper (end) -->';
}
add_action( 'woocommerce_before_shop_loop_item_title', 'bne_woocommerce_after_product_image', 11 );



/*
 * 	BreadCrumb Support
 *
 * 	@since 		v1.1.0
 *	@updated	v2.0
 *
*/
function bne_woocommerce_breadcrumb_trail_addon() {

	global $post, $woocommerce;

	// Get Shop Page
	$shop_page = wc_get_page_id( 'shop' );

	if( is_woocommerce() ) {

		// Default Shop Page
		if( is_shop() ) {
			echo '<li class="breadcrumb-item">'.get_the_title( $shop_page ).'</li>';
		}

		// Product Archive
		if( is_product_category() || is_product_tag() ) {
			if( $shop_page > 0 ) {
				echo '<li class="breadcrumb-item"><a href="'.get_permalink( $shop_page ).'" title="'.get_the_title( $shop_page ).'">'.get_the_title( $shop_page ).'</a></li>';
			}
			//echo '<li>'.single_cat_title( '', false ).'</li>';
		}

		// Single Product
		if( is_product() ) {

			// Main Shop Link
			if( $shop_page > 0 ) {
				echo '<li class="breadcrumb-item"><a href="'.get_permalink( $shop_page ).'" title="'.get_the_title( $shop_page ).'">'.get_the_title( $shop_page ).'</a></li>';
			}

			// Product Categories
			if ( $terms = wc_get_product_terms( $post->ID, 'product_cat', array( 'orderby' => 'parent', 'order' => 'DESC' ) ) ) {
				$main_term = $terms[0];
				$ancestors = get_ancestors( $main_term->term_id, 'product_cat' );
				$ancestors = array_reverse( $ancestors );

				foreach ( $ancestors as $ancestor ) {
					$ancestor = get_term( $ancestor, 'product_cat' );

					if ( ! is_wp_error( $ancestor ) && $ancestor ) {
						echo '<li class="breadcrumb-item"><a href="'.get_term_link( $ancestor ).'" title="'.$ancestor->name.'">'.$ancestor->name.'</a></li>';
					}
				}

				echo '<li class="breadcrumb-item"><a href="'.get_term_link( $main_term ).'" title="'.$main_term->name.'">'.$main_term->name.'</a></li>';

			} // Terms (end)

		} // is_product (end)

	} // is_woocommerce (end)

}
 

/*
 * 	WooCommerce Page Options and Sidebar Layouts
 *
 * 	@since 		v1.1.0
 *	@updated	v2.0
 *
*/
function bne_woocommerce_page_options( $options ) {
	// Only for WooCommerce Pages
	if( is_woocommerce() ) {
		// Main Shop
		if( is_shop() ) {
			$options['breadcrumbs'] = get_post_meta( get_option( 'woocommerce_shop_page_id' ), 'bne_breadcrumbs', true );
			$options['sidebar_layout'] = get_post_meta( get_option( 'woocommerce_shop_page_id' ), 'bne_sidebar_layout', true ) ?: 'default-sidebar';
		}

		// Product Archives
		if( is_product_category() || is_product_tag() ) {
			$options['sidebar_layout'] = get_theme_mod( 'woocommerce_sidebar_layout_archive' );
		}

		// Single Products
		if( is_product() ) {
			$options['sidebar_layout'] = get_theme_mod( 'woocommerce_sidebar_layout_single' );

		}

		// Default Fallback from Theme Options
		if ( !$options['sidebar_layout'] || 'default-sidebar' == $options['sidebar_layout'] ) {
			$options['sidebar_layout'] = get_theme_mod( 'sidebar_layout_pages', 'right-sidebar' );
		}
		
	}

	// Return Options
	return $options;

}