<?php
/*
 * 	Framework Widget Areas
 *
 * 	@author		Kerry Kline
 * 	@copyright	Copyright (c) Kerry Kline
 * 	@link		http://www.bnecreative.com
 * 	@package 	BNE WordPress Framework
 *
*/

// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;



/*
 *	Register Widget Areas
 *
 *	@since 		v1.0
 *	@updated 	v2.0
 *
*/
function bne_register_widget_areas() {
	
	// Register Sidebar Widgets
	$default_sidebars = array(
		'left'	=>	esc_html__( 'Left Sidebar', 'bne' ),
		'right'	=>	esc_html__( 'Right Sidebar', 'bne' )
	);
	foreach( $default_sidebars as $side => $name ) {
		register_sidebar( array(
			'name'          => 	$name,
			'id'            => 	$side.'-sidebar',
			'description' 	=> 	sprintf( esc_html__( 'This is the default placeholder for the %s Location.', 'bne' ), $name ),
			'before_widget' => 	'<aside id="%1$s" class="widget %2$s">',
			'after_widget'  => 	'</aside>',
			'before_title'  => 	'<h3 class="widget-title">',
			'after_title'   => 	'</h3>',
		) );
	}
	
	// Register Footer Widgets
	$footer_columns = substr( get_theme_mod( 'footer_columns', 3 ), 0, 1 );
	for( $i = 1; $i <= $footer_columns; $i++ ) {
		register_sidebar( array(
			'name'          => 	esc_html__( 'Footer Column', 'bne' ).' #'.$i,
			'id'            => 	'footer-column'.$i.'-widget-area',
			'description' 	=> 	'',
			'before_widget' => 	'<div id="%1$s" class="widget %2$s">',
			'after_widget'  => 	'</div>',
			'before_title'  => 	'<h3 class="widget-title">',
			'after_title'   =>	'</h3>',
		) );
	}

	// Register Header Widget
	register_sidebar( array(
		'name'          => 	esc_html__( 'Header Content', 'bne' ),
		'id'            => 	'header-sidebar',
		'description' 	=> 	esc_html__( 'This is the default placeholder for the header content area.', 'bne' ),
		'before_widget' => 	'<div id="%1$s" class="widget %2$s">',
		'after_widget'  => 	'</div>',
		'before_title'  => 	'<h3 class="widget-title">',
		'after_title'   =>	'</h3>',
	) );

}
add_action( 'widgets_init', 'bne_register_widget_areas' );