<?php
/*
 * 	Frontend CSS Output from Customizer
 *
 * 	@author		Kerry Kline
 * 	@copyright	Copyright (c) Kerry Kline
 * 	@link		http://www.bnecreative.com
 * 	@package 	BNE WordPress Framework
 *	@updated	v2.2.13
 *
*/


function bne_custom_css_styles() {
	$typography_defaults = array(
		'font-family'	=>	'-apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Oxygen-Sans, Ubuntu, Cantarell, "Helvetica Neue", sans-serif',
		'font-size'		=>	'16px'
	);
	
	// Layout
	$box_wide_layout = get_theme_mod( 'layout', 'wide_layout' );
	$content_area_width = get_theme_mod( 'content_width', '1200px' );
	$sidebar_gutter = apply_filters( 'bne_sidebar_layout_gutter', '60' ) / 2;

	// Typography
	$body_font = get_theme_mod( 'body_font', $typography_defaults );	
	$body_font_fluid_ratio = get_theme_mod( 'body_font_fluid_ratio', 0 );
	$header_font = get_theme_mod( 'heading_font', $typography_defaults );
	$link_color = get_theme_mod( 'link_color', '#2a9ed4' );
	$link_color_hover = get_theme_mod( 'link_color_hover', '#1a5a78' );
	$footer_color = get_theme_mod( 'footer_color', '#666666' );
	$footer_header_color = get_theme_mod( 'footer_heading_color', '#333333' );
	$footer_link_color = get_theme_mod( 'footer_link_color', '#2a9ed4' );
	$footer_link_color_hover = get_theme_mod( 'footer_link_color_hover', '#1a5a78' );
	$page_heading = get_theme_mod( 'page_heading_color', '#333' );

	// Menu Styles
	$menu_bg_color = get_theme_mod( 'menu_bg_color', '#f4f4f4' );
	$menu_bg_color_hover = get_theme_mod( 'menu_bg_color_hover', '#ffffff' );
	$menu_link_color = get_theme_mod( 'menu_link_color', '#666666' );
	$menu_link_color_hover = get_theme_mod( 'menu_link_color_hover', '#666666' );
	$menu_sub_bg_color = get_theme_mod( 'menu_sub_bg_color', '#ffffff' );
	$menu_sub_bg_color_hover = get_theme_mod( 'menu_sub_bg_color_hover', '#f4f4f4' );
	$menu_sub_link_color = get_theme_mod( 'menu_sub_link_color', '#666666' );
	$menu_sub_link_color_hover = get_theme_mod( 'menu_sub_link_color_hover', '#666666' );
	$menu_font = get_theme_mod( 'menu_font' );
	$menu_font_sub = get_theme_mod( 'menu_font_sub', false );

	// Backgrounds
	$header_bg = get_theme_mod( 'header_bg' );
	$body_bg = get_theme_mod( 'body_bg' );
	$main_bg = get_theme_mod( 'main_bg' );
	$footer_widgets_bg = get_theme_mod( 'footer_widgets_bg' );
	$footer_bg = get_theme_mod( 'footer_bg' );
	
	// Buttons
	$button_color = get_theme_mod( 'button_color', '#0099ff' );	
	
	?>

<!-- Theme Options CSS -->
<style type="text/css">
	:root {
		--theme-content-width: <?php echo $content_area_width; ?>;
		--theme-default-btn-color: <?php echo $button_color;?>;
		--theme-sidebar-gutter: <?php echo $sidebar_gutter; ?>px;
		--theme-body-font-family: <?php echo $body_font['font-family']; ?>;
		--theme-heading-font-family: <?php echo $header_font['font-family']; ?>;
		--theme-base-font-size: <?php echo preg_replace( '/\D/', '', $body_font['font-size'] ); ?>px;
		--theme-fluid-typography-ratio: <?php echo $body_font_fluid_ratio; ?>;
		--theme-fluid-font-size: calc(var(--theme-base-font-size) + var(--theme-fluid-typography-ratio) * 1vw);
		--theme-dark-base: #111;
		--theme-dark-base-secondary: #333;
		--theme-menu-bg-color: <?php echo $menu_bg_color; ?>;
		--theme-menu-bg-hover-color: <?php echo $menu_bg_color_hover; ?>;
		--theme-menu-nav-color: <?php echo $menu_link_color; ?>;
		--theme-menu-nav-hover-color: <?php echo $menu_link_color_hover; ?>;
	}
	
	/* Responsive content size css (note: placed in styles.php as @media does not accept --var())*/
	@media (min-width: <?php echo $content_area_width; ?> ) {
		/* WP Block: Media & Text (full width splits) */
		.wp-block-media-text.alignfull .wp-block-media-text__content {
			margin: 0 calc( ( 100vw - <?php echo $content_area_width; ?> ) / 2 ) 0 auto;
		}
		
		.wp-block-media-text.alignfull.has-media-on-the-right .wp-block-media-text__content {
			margin: 0 auto 0 calc( ( 100vw - <?php echo $content_area_width; ?> ) / 2 );
			padding-left: 0;
		}

		/* BNE Block: Container Halves */
		.bne-container.has-left-bg .bne-container-content,
		.bne-container.has-right-bg .bne-container-content {
			max-width: calc( ( <?php echo $content_area_width; ?> / 2 ) + 30px );
		}	
		
	}

	/* General Typography Styles */
	<?php if( $body_font ) { ?>
	html,
	body {
		<?php foreach( $body_font as $k => $v ) {
		if( $k == 'variant' || $k == 'font-backup' ) { continue; }
		if( $k == 'font-size' ) { $v = 'var(--theme-fluid-font-size)'; }
		echo $k.':'.$v.';';
		}
		?>
	}
	<?php } ?>
	a { color: <?php echo $link_color;?>; }
	a:hover { color: <?php echo $link_color_hover;?>; }
	.tagcloud a:hover, .bne-tags a:hover { background: <?php echo $link_color_hover; ?>; color: white; }
	<?php if( $header_font ) { ?>
	h1, h2, h3, h4, h5, h6, .header-font {
		<?php foreach( $header_font as $k => $v ) {
		if( $k == 'variant' || $k == 'font-backup' || $k == 'font-size' ) { continue; }
		echo $k.':'.$v.';';
		}
		?>
	}
	#page-heading-wrapper { color: <?php echo $page_heading;?>; }
	<?php } ?>
	
	#footer_content,
	#footer-wrapper { color: <?php echo $footer_color;?>; }
	#footer_content h1, #footer_content h2, #footer_content h3, #footer_content h4, #footer_content h5, #footer_content h6,
	#footer-wrapper h1, #footer-wrapper h2, #footer-wrapper h3, #footer-wrapper h4, #footer-wrapper h5, #footer-wrapper h6 { color: <?php echo $footer_header_color;?>; }
	#footer_content a:not(.btn),
	#footer-wrapper a:not(.btn) { color: <?php echo $footer_link_color;?>; }
	#footer_content a:hover:not(.btn),
	#footer-wrapper a:hover:not(.btn) { color: <?php echo $footer_link_color_hover;?>; }	

	/* Main Menu Styles */
	#access { background-color: <?php echo $menu_bg_color; ?>; }
	#primary-menu > li > a { color: <?php echo $menu_link_color; ?>; }
	/* Top Hover */
	#primary-menu > li > a:hover,
	#primary-menu > li > a:focus,
	#primary-menu > li.active > a,
	#primary-menu > li.sfHover > a,
	.bne-sticky-menu #primary-menu > li > a:hover,
	.bne-sticky-menu #primary-menu > li.active > a,
	.bne-sticky-menu #primary-menu > li.sfHover > a {
		background-color: <?php echo $menu_bg_color_hover; ?>;
		color: <?php echo $menu_link_color_hover; ?>;
	}
	/* Sub Menu */
	#primary-menu ul { background-color: <?php echo $menu_sub_bg_color; ?>; }
	#primary-menu li li a { color: <?php echo $menu_sub_link_color; ?>; }
	/* Sub Menu Hover */
	#primary-menu li li a:hover,
	#primary-menu li li a:focus,
	#primary-menu li li.active > a {
		background-color: <?php echo $menu_sub_bg_color_hover; ?>;
		color: <?php echo $menu_sub_link_color_hover; ?>;
	}
	<?php 
		if( $menu_font ) {
			if( $menu_font_sub == true ) {
				echo '#primary-menu li a {';
			} else {
				echo '#primary-menu > li > a {';
			}
			foreach( $menu_font as $k => $v ) {
				if( $k == 'variant' || $k == 'font-backup' ) { continue; }
				echo $k.':'.$v.';';
			}
			echo '}';
		}
	?>
	<?php if( $body_bg ) { ?>
	/* Body/Page Background */
	body { <?php echo bne_generate_css_properties( $body_bg ); ?> }
	<?php } ?>
	<?php if( $header_bg ) { ?>
	/* Header Background */
	#header-wrapper { <?php echo bne_generate_css_properties( $header_bg ); ?> }
	<?php } ?>
	<?php if( $main_bg ) { ?>
	/* Container Background */
	#main-content-wrapper { <?php echo bne_generate_css_properties( $main_bg ); ?> }
	<?php } ?>
	<?php if( $footer_widgets_bg ) { ?>
	/* Footer Widgets Background */
	#footer-widgets-wrapper { <?php echo bne_generate_css_properties( $footer_widgets_bg ); ?> }
	<?php } ?>
	<?php if( $footer_bg ) { ?>
	/* Footer Background */
	#footer-wrapper { <?php echo bne_generate_css_properties( $footer_bg ); ?> }
	<?php } ?>
	
</style>
<!-- Theme Options CSS (End) -->
	<?php

}
add_action( 'wp_head', 'bne_custom_css_styles' );