<?php
/*
 * 	3rd Party Plugin Support
 *
 * 	@author		Kerry Kline
 * 	@copyright	Copyright (c) Kerry Kline
 * 	@link		http://www.bnecreative.com
 * 	@package 	BNE WordPress Framework
 *
*/

// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;


/**
 * 	Gravity Forms Bootstrap Styles
 *
 * 	Applies bootstrap classes to various common field types.
 * 	Requires Bootstrap to be in use by the theme.
 *
 * 	Using this function allows use of Gravity Forms default CSS
 * 	in conjuction with Bootstrap (benefit for fields types such as Address).
 *
 * 	@see  gform_field_content
 * 	@link http://www.gravityhelp.com/documentation/page/Gform_field_content
 *
 * 	@return string Modified field content
*/
function bne_gravity_forms_bootstrap_styles($content, $field, $value, $lead_id, $form_id){
	
	// Currently only applies to most common field types, but could be expanded.	
	
	if($field['type'] != 'hidden' && $field['type'] != 'list' && $field['type'] != 'checkbox' && $field['type'] != 'html' && $field['type'] != 'address') {
		$content = str_replace('class=\'medium', 'class=\'form-control medium', $content);
		$content = str_replace('class=\'large', 'class=\'form-control large', $content);
	}
	
	if($field['type'] == 'name' || $field['type'] == 'address') {
		$content = str_replace('<input ', '<input class=\'form-control\' ', $content);
	}
	
	if($field['type'] == 'textarea') {
		$content = str_replace('class=\'textarea', 'class=\'form-control textarea', $content);
	}
	
	if($field['type'] == 'checkbox') {
		$content = str_replace('li class=\'', 'li class=\'checkbox ', $content);
		$content = str_replace('<input ', '<input style=\'margin-left:1px;\' ', $content);
	}
	
	if($field['type'] == 'radio') {
		$content = str_replace('li class=\'', 'li class=\'radio ', $content);
		$content = str_replace('<input ', '<input style=\'margin-left:1px;\' ', $content);
	}
	
	if( $field['type'] == 'address' || $field['type'] == 'time' ) {
		$content = str_replace('<select ', '<select class=\'form-control\' ', $content);
	}
	
	return $content;
	
}
add_filter( 'gform_field_content', 'bne_gravity_forms_bootstrap_styles', 10, 5);


/*
 * 	Gravity Forms Confirmation
 *
*/
function bne_gravity_forms_confirmation( $confirmation, $form, $entry, $ajax ) {
	if( !is_array($confirmation) ) {
		$confirmation = '<div class="alert alert-success">'.$confirmation.'</div>'; 
	}
	
	return $confirmation;
}
add_filter( 'gform_confirmation', 'bne_gravity_forms_confirmation', 10, 4 );



/*
 * 	Ghostkit: Remove FA on frontend.
 *
*/
add_action( 'after_setup_theme', function() {
	if( !is_admin() ) {
		add_filter( 'gkt_enqueue_plugin_font_awesome', '__return_false' );
	}
});