<?php
/*
 * 	Theme specific functions for media features.
 *
 * 	@author		Kerry Kline
 * 	@copyright	Copyright (c) Kerry Kline
 * 	@link		http://www.bnecreative.com
 * 	@package 	BNE WordPress Framework
 *
*/

// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;


/*
 *	The post thumbnail (must be within the loop)
 *	Add a custom wrapper around post thumbnails and determine
 *	location, size and classes used.
 *
 *	@since 		v1.0
 *	@updated 	v2.1
 *
*/
if( !function_exists( 'bne_post_thumbnail' ) ) :

	function bne_post_thumbnail( $size = '', $class = '', $image_class = '', $link = 'true', $backup_image = '' ) {

		global $post;

		$attachment_id = get_post_thumbnail_id( $post->ID );
		$image = '';
		$title = '';
		$output = '';

		// Size
		if( !$size ) {
			// Archive
			if( !is_single() ) { 
				$size = get_theme_mod( 'post_archive_thumbnail_size', 'post-thumbnail' );
			// Single
			} else {
				$size = get_post_meta( $post->ID, 'bne_post_single_thumbnail_size', true );
			}
		}
		
		// Alignment Class
		if( !$class ) {
			if( $size != 'post-thumbnail' && $size != 'large') {
				$class = 'alignleft'; 
			}
		}

		// Get Featured Image and Attributes
		$image = get_the_post_thumbnail(
			$post->ID,
			$size,
			array(
				'class' 	=> 	'thumbnail '.$image_class.' crop-'.$size,
				'alt' 		=> 	get_the_title(),
			)
		);
		
		// No image? Check if we should use a backup image?
		if( !$image && !empty( $backup_image ) ) {
			$image .= '<img src="'.esc_url( $backup_image ).'" class="thumbnail '.$image_class.' crop-'.$size.'" alt="'.get_the_title().'" />';
			$image = '</a>';
		}
		
		// wrap image with a link to post
		if( $image && 'true' == $link ) {
			$image = '<a href="'.get_permalink( $post->ID ).'" title="'.esc_html( get_the_title() ).'">'.$image.'</a>';
		}

		if( $size != 'hide' ) {
			
			// Video Featured Image
			$video_url = esc_url( get_post_meta( $post->ID, 'bne_post_oembed', true ) );

			// OEMBED Media
			if( $video_url ) {	
				$output  = '<div class="bne-video-wrapper '.$size.' '.$class.'">';
				$output .= '<div class="video-inner '.$image_class.'">';
				$output .= wp_oembed_get( $video_url );
				$output .= '</div>';
				$output .= '</div>';
				
			// Featured Image	
			} elseif( $image ) {
				$output  = '<div class="featured-image-wrapper '.$class.'">';
				$output .= '<div class="featured-image">';
				$output .= '<div class="featured-image-inner">';
				$output .= apply_filters( 'bne_featured_image_inner', $image, $size );
				$output .= '</div><!-- .featured-image-inner (end) -->';
				$output .= '</div><!-- .featured-image (end) -->';
				$output .= '</div><!-- .featured-image-wrapper (end) -->';
			}
			
		}

		return $output;

	}
endif;



/*
 * 	Prints the attached image with a link to the next attached image.
 *
 *	@since v1.0
 *
 */
if( !function_exists( 'bne_the_attached_image' ) ) :
	function bne_the_attached_image() {
		$post                = get_post();
		$attachment_size     = apply_filters( 'bne_attachment_size', array( 1200, 1200 ) );
		$next_attachment_url = wp_get_attachment_url();

		/*
		 * Grab the IDs of all the image attachments in a gallery so we can get the
		 * URL of the next adjacent image in a gallery, or the first image (if
		 * we're looking at the last image in a gallery), or, in a gallery of one,
		 * just the link to that image file.
		*/
		$attachment_ids = get_posts( array(
			'post_parent'    => $post->post_parent,
			'fields'         => 'ids',
			'numberposts'    => -1,
			'post_status'    => 'inherit',
			'post_type'      => 'attachment',
			'post_mime_type' => 'image',
			'order'          => 'ASC',
			'orderby'        => 'menu_order ID'
		) );

		// If there is more than 1 attachment in a gallery...
		if ( count( $attachment_ids ) > 1 ) {
			foreach ( $attachment_ids as $attachment_id ) {
				if ( $attachment_id == $post->ID ) {
					$next_id = current( $attachment_ids );
					break;
				}
			}

			// get the URL of the next image attachment...
			if ( $next_id ) {
				$next_attachment_url = get_attachment_link( $next_id );

			// or get the URL of the first image attachment.
			} else {
				$next_attachment_url = get_attachment_link( array_shift( $attachment_ids ) );
			}
		}

		printf( '<a href="%1$s" title="%2$s" rel="attachment">%3$s</a>',
			esc_url( $next_attachment_url ),
			the_title_attribute( array( 'echo' => false ) ),
			wp_get_attachment_image( $post->ID, $attachment_size )
		);
	}
endif;




/*
 * 	OEMBED Video HTML Wrapper
 *
 * 	@since 		v1.0
 *	@updated 	v1.5.6
 *
*/
function bne_oembed( $html, $url ) {
	
	$class = 'general';

	// Twitter
	if( strpos( $url, 'twitter.com' ) ) {
		return $html;
	}

	// WP Post Embed
	if( strpos( $html, 'wp-embedded-content') !== false ) {
		return $html;
	}
	
	// Make sure we haven't applied this filter already elsewhere
	if( strpos( $html, 'bne-video-wrapper') !== false ) {
		return $html;
	}
	
	// Apply YouTube wmode fix
	if( strpos( $url, 'youtube' ) !== false || strpos( $url, 'youtu.be' ) !== false ) {
		$class = 'youtube';
		if( strpos( $html, 'wmode=opaque') === false ) {
			$html = str_replace('feature=oembed', 'feature=oembed&wmode=opaque&rel=0', $html);
		}
	}
	
	// Vimeo
	if( strpos( $url, 'vimeo' ) !== false ) {
		$class = 'vimeo';
	}

	// Return embed wrap
	return sprintf('<div class="bne-video-wrapper embed-'.$class.'"><div class="video-inner">%s</div></div>', $html );

}
add_filter( 'embed_oembed_html', 'bne_oembed', 10, 2 );