<?php
/*
 * 	Available Action Hooks
 *
 *	These hooks allow further customizing the main framework
 *	structure, output, and markup, specifically for child themes.
 *
 * 	@author		Kerry Kline
 * 	@copyright	Copyright (c) Kerry Kline
 * 	@link		http://www.bnecreative.com
 * 	@package 	BNE WordPress Framework
 *
*/




/*
 * 	WP Core action for adding content after the opening <body> tag.
 *	Added for backwards compatibility to support WP < 5.2.0.
 *
 *	@since	v2.1.2
 *
*/
if( !function_exists( 'wp_body_open' ) ) {
    function wp_body_open() {
        do_action( 'wp_body_open' );
    }
}



/*
 * 	Before Site Action Hook
 *	found in header.php
 *
 *	@since v1.0
 *
*/
function bne_before() {
	do_action( 'bne_before' );
}



/*
 * 	Before Header Action Hook
 *	found in header.php
 *
 *	@since v1.0
 *
*/
function bne_header_before() {
	do_action( 'bne_header_before' );
}



/*
 * 	Before Header Content Action Hook
 *	found in header.php
 *
 *	@since v1.0
 *
*/
function bne_header_content_before() {
	do_action( 'bne_header_content_before' );
}



/*
 * 	Primary Menu Action Hook
 *	found in header.php
 *
 *	Allows moving/removing bne_header_menu_default into a new location
 *
 *	@since v1.0
 *
*/
function bne_header_menu(){
	do_action( 'bne_header_menu' );
}



/*
 * 	Primary Menu Addon
 *	found in bne_header_menu_default()
 *
 *	Allows Adding additional markup after the menu "ul"
 *
 *	@since v1.0.3
 *
*/
function bne_header_menu_addon(){
	do_action( 'bne_header_menu_addon' );
}



/*
 * 	After Header Content Action Hook
 *	found in header.php
 *
 *	@since v1.0
 *
*/
function bne_header_content_after() {
	do_action( 'bne_header_content_after' );
}



/*
 * 	After Header Action Hook
 *	found in header.php
 *
 *	@since v1.0
 *
*/
function bne_header_after() {
	do_action( 'bne_header_after' );
}



/*
 * 	Featured Area Content Action Hook
 *
 *	@since v2.0
 *
 *	@depreciated v2.2.7
 *
*/
function bne_featured_content() {
	do_action( 'bne_featured_content' );
}



/*
 * 	Featured Area Action Hook
 *
 *	@since v2.2.7
 *
*/
function bne_featured_area() {
	do_action( 'bne_featured_area' );
}
add_action( 'bne_featured_area', 'bne_featured_area_default' );



/*
 * 	Before Main Action Hook
 *	found in header.php
 *
 *	@since v1.1.5
 *
*/
function bne_main_before() {
	do_action( 'bne_main_before' );
}



/*
 * 	Breadcrumbs
 *	found in header.php
 *
 *	Allows moving/removing bne_breadcrumbs_default into a new location
 *
 *	@since v1.0
 *
*/
function bne_breadcrumbs(){
	do_action( 'bne_breadcrumbs' );
}
add_action( 'bne_breadcrumbs', 'bne_breadcrumbs_default' );



/*
 * 	Before Site Action Hook
 *	found in header.php
 *
 *	@since v2.2.7
 *
*/
function bne_page_heading() {
	do_action( 'bne_page_heading' );
}
add_action( 'bne_page_heading', 'bne_page_heading_default' );



/*
 * 	Before Sidebar Action Hook
 *	found in sidebar-{side}.php
 *
 *	@since v1.0
 *	@udpated v2.1.9
 *
*/
function bne_sidebar_before( $side ) {
	do_action( 'bne_sidebar_before', $side );
}



/*
 * 	After Sidebar Action Hook
 *	found in sidebar-{side}.php
 *
 *	@since v1.0
 *
*/
function bne_sidebar_after() {
	do_action( 'bne_sidebar_after' );
}



/*
 * 	After Page Action Hook
 *	found in page.php
 *
 *	@since v1.0
 *
*/
function bne_page_footer() {
	do_action( 'bne_page_footer' );
}



/*
 * 	After Single Action Hook
 *	found in single.php
 *
 *	@since v1.0
 *
*/
function bne_single_footer() {
	do_action( 'bne_single_footer' );
}



/*
 * 	Before Footer Action Hook
 *	found in footer.php
 *
 *	@since v1.0
 *
*/
function bne_footer_before() {
	do_action( 'bne_footer_before' );
}



/*
 * 	Before Footer Content Action Hook
 *	found in footer.php
 *
 *	@since v1.0
 *
*/
function bne_footer_content_before() {
	do_action( 'bne_footer_content_before' );
}



/*
 * 	Footer Content Action Hook
 *	found in footer.php
 *
 *	@since v1.0
 *
*/
function bne_footer_content(){
	do_action('bne_footer_content');
}
add_action( 'bne_footer_content', 'bne_footer_content_default' );



/*
 * 	After Footer Content Action Hook
 *	found in footer.php
 *
 *	@since v1.0
 *
*/
function bne_footer_content_after() {
	do_action( 'bne_footer_content_after' );
}



/*
 * 	After Footer Action Hook
 *	found in footer.php
 *
 *	@since v1.0
 *
*/
function bne_footer_after() {
	do_action( 'bne_footer_after' );
}



/*
 * 	After Site Action Hook
 *	found in footer.php
 *
 *	@since v1.0
 *
*/
function bne_after() {
	do_action( 'bne_after' );
}