<?php
/*
 * 	WP Customizer Settings - WooCommerce
 *
 * 	@author		Kerry Kline
 * 	@copyright	Copyright (c) Kerry Kline
 * 	@link		http://www.bnecreative.com
 * 	@package 	BNE WordPress Framework
 *	@package	Kirki Toolkit
 *
*/

// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;


// Archive Section
Kirki::add_section( $kirki_prefix.'_section_woocommerce', array(
    'title'			=> 	esc_html__( 'WooCommerce', 'bne' ),
    'description'	=> 	'',
    'panel'			=> 	$kirki_prefix.'_options',
) );

// Archive Sidebar Layout
Kirki::add_field( $kirki_prefix, array(
	'section'		=>	$kirki_prefix.'_section_woocommerce',
	'type'			=>	'radio-image',
	'settings'		=>	'woocommerce_sidebar_layout_archive',
	'label'			=>	esc_html__( 'Product Archive Sidebar', 'bne' ),
	'description'	=>	esc_html__( 'Select a sidebar layout for product archive pages. For example, this would include viewing a category or tag of products. The main shop page, account, checkout, and cart pages can be configured from their specific WordPress pages.', 'bne' ),
	'default'		=>	'default-sidebar',
	'choices'		=>	array(
		'default-sidebar'	=> 	$kirki_imagepath . 'layouts/' . 'sidebar_default.png',
		'right-sidebar'		=>	$kirki_imagepath . 'layouts/' . 'sidebar_right.png',
		'left-sidebar'		=>	$kirki_imagepath . 'layouts/' . 'sidebar_left.png',
		'double-sidebar' 	=>	$kirki_imagepath . 'layouts/' . 'sidebar_double.png',
		'no-sidebar' 		=>	$kirki_imagepath . 'layouts/' . 'sidebar_none.png',
	),
) );

// Single Sidebar Layout
Kirki::add_field( $kirki_prefix, array(
	'section'		=>	$kirki_prefix.'_section_woocommerce',
	'type'			=>	'radio-image',
	'settings'		=>	'woocommerce_sidebar_layout_single',
	'label'			=>	esc_html__( 'Single Product Sidebar', 'bne' ),
	'description'	=>	esc_html__( 'Select a sidebar layout for single product pages.', 'bne' ),
	'default'		=>	'default-sidebar',
	'choices'		=>	array(
		'default-sidebar'	=> 	$kirki_imagepath . 'layouts/' . 'sidebar_default.png',
		'right-sidebar'		=>	$kirki_imagepath . 'layouts/' . 'sidebar_right.png',
		'left-sidebar'		=>	$kirki_imagepath . 'layouts/' . 'sidebar_left.png',
		'double-sidebar' 	=>	$kirki_imagepath . 'layouts/' . 'sidebar_double.png',
		'no-sidebar' 		=>	$kirki_imagepath . 'layouts/' . 'sidebar_none.png',
	),
) );


// Share buttons
Kirki::add_field( $kirki_prefix, array(
	'section'		=>	$kirki_prefix.'_section_woocommerce',
	'settings'		=>	'woocommerce_share_buttons',
	'type'			=>	'select',
	'label'			=>	esc_html__( 'Share Buttons', 'bne' ),
	'description'	=>	esc_html__( 'Choose whether you want to show the theme share buttons on the product pages.', 'bne' ),
	'default'		=>	'hide',
	'choices'		=>	array(
		'show' 		=>		esc_html__( 'Show share buttons', 'bne' ),
		'hide' 		=>		esc_html__( 'Hide share buttons', 'bne' ),
	),
) );
