<?php
/*
 * 	WP Customizer Settings - Typography
 *
 * 	@author		Kerry Kline
 * 	@copyright	Copyright (c) Kerry Kline
 * 	@link		http://www.bnecreative.com
 * 	@package 	BNE WordPress Framework
 *	@package	Kirki Toolkit
 *	@updated	v2.2.7
 *
*/

// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;


// Typography section
Kirki::add_section( $kirki_prefix.'_section_typography', array(
	'title'			=>	esc_html__( 'Typography', 'bne' ),
	'description'	=>	'',
	'panel'			=>	$kirki_prefix.'_options',
) );

// Body Font
Kirki::add_field( $kirki_prefix, array(
	'type'			=>	'typography',
	'settings'		=>	'body_font',
	'label'			=>	esc_html__( 'Primary Font', 'bne' ),
	'description'	=>	'',
	'section'		=>	$kirki_prefix.'_section_typography',
	'default'		=>	array(
		'font-family'	=>	'-apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Oxygen-Sans, Ubuntu, Cantarell, "Helvetica Neue", sans-serif',
		'variant'		=>	'400',
		'font-size'		=>	'16px',
		'line-height'	=>	'1.5',
		'color'			=>	'#555555',
	),
	'choices' => array(
		'fonts' => array(
			'google',
			'standard',
		),
	),
) );

/*
// Fluid Typography
// Toggle for a true/false then use css to fully calculate it
// https://levelup.gitconnected.com/css-responsive-fluid-typography-a23a9aab19a
/* Emplementation example in style.php
	$font_fluid_base = preg_replace( '/\D/', '', $body_font['font-size'] );
	$font_fluid_base_px = $font_fluid_base.'px';
	$font_fluid_base_max = ($font_fluid_base + 4);
	$font_fluid_base_max_px = ($font_fluid_base + 4).'px';
	$min_viewport_width = 768;
	$max_viewport_width = 1600;
	html,body{ font-size: calc(<?php echo $font_fluid_base_px; ?> + (<?php echo $font_fluid_base_max; ?> - <?php echo $font_fluid_base; ?>) * ((100vw - <?php echo $min_viewport_width; ?>px) / (<?php echo $max_viewport_width; ?> - <?php echo $min_viewport_width; ?>))); }
	@media screen and (max-width: <?php echo $min_viewport_width; ?>px) { html,body { font-size: <?php echo $font_fluid_base_px; ?>; } }
	@media screen and (min-width: <?php echo $max_viewport_width; ?>px) { html,body { font-size: <?php echo $font_fluid_base_max_px; ?>; } }
*/
/*
Kirki::add_field( $kirki_prefix, array(
	'type'			=>	'toggle',
	'settings'		=>	'body_font_fluid',
	'label'			=>	esc_html__( 'Fluid Typography (Experimental)', 'bne' ),
	'description'	=>	esc_html__( 'This adds a font size calculation based on the body font size above and will max to a +4px base on larger screens. The unit above needs to be a px unit. The idea here is that the body font size above should be the minimum for mobile and on desktop will be +4px larger as a base.', 'bne' ),
	'section'		=>	$kirki_prefix.'_section_typography',
	'default'		=>	false,
) );
*/

// Fluid Typography
// Ratio calculation using vars in style.php
// https://aristath.github.io/blog/fluid-typography-css-vars
/* Emplementation
	--base-font-size: <?php echo preg_replace( '/\D/', '', $body_font['font-size'] ); ?>px;
	--fluid-typography-ratio: <?php echo $body_font_fluid_ratio; ?>;
	--fluid-font-size: calc(var(--base-font-size) + var(--fluid-typography-ratio) * 1vw);
*/	
Kirki::add_field( $kirki_prefix, array(
	'type'			=>	'slider',
	'settings'		=>	'body_font_fluid_ratio',
	'label'			=>	esc_html__( 'Fluid Typography (Experimental)', 'bne' ),
	'description'	=>	esc_html__( 'This adds a font size calculation based on the body font size above. The idea here, is that the base font size should increase as the screen width increases, calculated by the ratio here. Setting this to 0 will disable fluid typography. For example, if you want mobile font size to be approximately 16px, the font-size above should be 14px and the ratio here at 0.3. Make sure you review the main screen sizes to pick the best ratio for your website.', 'bne' ),
	'section'		=>	$kirki_prefix.'_section_typography',
	'default'		=>	0,
	'choices'     	=> 	array(
		'min'		=>	0,
		'max'  			=> 	1,
		'step' 			=> 	.1
	)
) );


// Heading Font
Kirki::add_field( $kirki_prefix, array(
	'type'			=>	'typography',
	'settings'		=>	'heading_font',
	'label'			=>	esc_html__( 'Heading Font', 'bne' ),
	'description'	=>	'',
	'section'		=>	$kirki_prefix.'_section_typography',
	'default'		=>	array(
		'font-family'	=>	'-apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Oxygen-Sans, Ubuntu, Cantarell, "Helvetica Neue", sans-serif',
		'variant'		=>	'400',
		'letter-spacing'=>	'0',
		'color'			=>	'#111111',
		'text-transform'=>	'none'
	),
	'choices' => array(
		'fonts' => array(
			'google',
			'standard',
		),
	),
) );

// Page Heading
if( 'featured' == get_theme_mod('page_heading', 'default' ) ) {
	Kirki::add_field( $kirki_prefix, array(
		'type'			=>	'color',
		'settings'		=>	'page_heading_color',
		'label'			=>	esc_attr__( 'Page Heading Color', 'bne' ),
		'description'	=>	'',
		'section'		=>	$kirki_prefix.'_section_typography',
	) );
}

// Link Color
Kirki::add_field( $kirki_prefix, array(
	'type'			=>	'color',
	'settings'		=>	'link_color',
	'label'			=>	esc_html__( 'Link Color', 'bne' ),
	'description'	=>	'',
	'section'		=>	$kirki_prefix.'_section_typography',
	'default'		=>	'#2a9ed4',
) );

// Link Color hover
Kirki::add_field( $kirki_prefix, array(
	'type'			=>	'color',
	'settings'		=>	'link_color_hover',
	'label'			=>	esc_html__( 'Link Color (hover)', 'bne' ),
	'description'	=>	'',
	'section'		=>	$kirki_prefix.'_section_typography',
	'default'		=>	'#1a5a78',
) );

// Footer Font Color
Kirki::add_field( $kirki_prefix, array(
	'type'			=>	'color',
	'settings'		=>	'footer_color',
	'label'			=>	esc_html__( 'Footer Font Color', 'bne' ),
	'description'	=>	'',
	'section'		=>	$kirki_prefix.'_section_typography',
	'default'		=>	'#666666',
) );

// Footer Heading Color
Kirki::add_field( $kirki_prefix, array(
	'type'			=>	'color',
	'settings'		=>	'footer_heading_color',
	'label'			=>	esc_html__( 'Footer Heading Color', 'bne' ),
	'description'	=>	'',
	'section'		=>	$kirki_prefix.'_section_typography',
	'default'		=>	'#333333',
) );

// Footer Link Color
Kirki::add_field( $kirki_prefix, array(
	'type'			=>	'color',
	'settings'		=>	'footer_link_color',
	'label'			=>	esc_html__( 'Footer Link Color', 'bne' ),
	'description'	=>	'',
	'section'		=>	$kirki_prefix.'_section_typography',
	'default'		=>	'#2a9ed4',
) );

// Footer Link Color hover
Kirki::add_field( $kirki_prefix, array(
	'type'			=>	'color',
	'settings'		=>	'footer_link_color_hover',
	'label'			=>	esc_html__( 'Footer Link Color (hover)', 'bne' ),
	'description'	=>	'',
	'section'		=>	$kirki_prefix.'_section_typography',
	'default'		=>	'#1a5a78',
) );

