<?php
/*
 * 	WP Customizer Settings - Social Icons
 *
 * 	@author		Kerry Kline
 * 	@copyright	Copyright (c) Kerry Kline
 * 	@link		http://www.bnecreative.com
 * 	@package 	BNE WordPress Framework
 *	@package	Kirki Toolkit
 *
*/

// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;


// Social section
Kirki::add_section( $kirki_prefix.'_section_social', array(
	'title'			=>	esc_html__( 'Social Profiles', 'bne' ),
	'description'	=>	esc_html__( 'Define a set of social profile links to be used within the header contact bar.', 'bne' ),
	'panel'			=>	$kirki_prefix.'_options',
) );

// Link target
Kirki::add_field( $kirki_prefix, array(
	'type'			=>	'toggle',
	'settings'		=>	'social_profiles_target',
	'label'			=>	esc_attr__( 'Link Behavior', 'bne' ),
	'description'	=>	esc_attr__( 'Open social links in a new window', 'bne' ),
	'section'		=>	$kirki_prefix.'_section_social',
	'default'		=>	false,
) );

// Social Links repeater
Kirki::add_field( $kirki_prefix, array(
	'type'			=>	'repeater',
	'label'			=>	esc_html__( 'Social Profiles', 'bne' ),
	'description'	=>	esc_html__( 'Each profile requires a link to display. Drag each one to change their order. For email use mailto:domain.com as the link.', 'bne' ),
	'section'		=>	$kirki_prefix.'_section_social',
	'priority'		=>	10,
	'row_label'		=>	array(
		'type'			=>	'field',
		'value'			=>	esc_html__( 'Profile', 'bne' ),
		'field'			=>	'source'
	),
	'button_label'	=>	esc_html__( 'Add new profile', 'bne' ),
	'settings'		=>	'social_profiles',
	'default'		=>	'',
	'fields'		=>	array(
		'source'		=>	array(
			'type'			=>	'select',
			'label'			=>	esc_html__( 'Profile', 'bne' ),
			'description'	=>	'',
			'default'		=>	'',
			'choices'		=>	bne_get_social_media_sources( 'labels' )
		),
		'url'			=>	array(
			'type'			=> 'text',
			'label'			=>	esc_html__( 'URL', 'bne' ),
			'description'	=>	'',
			'default'		=>	'',
		),
	)
) );