<?php
/*
 * 	WP Customizer Settings - Post
 *
 * 	@author		Kerry Kline
 * 	@copyright	Copyright (c) Kerry Kline
 * 	@link		http://www.bnecreative.com
 * 	@package 	BNE WordPress Framework
 *	@package	Kirki Toolkit
 *
*/

// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;


// Post section
Kirki::add_section( $kirki_prefix.'_section_post', array(
	'title'			=>	esc_html__( 'Post', 'bne' ),
	'description'	=>	'',
	'panel'			=>	$kirki_prefix.'_options',
) );

// Sidebar layout
Kirki::add_field( $kirki_prefix, array(
	'section'		=>	$kirki_prefix.'_section_post',
	'type'			=>	'radio-image',
	'settings'		=>	'sidebar_layout_posts',
	'label'			=>	esc_html__( 'Default Sidebar Layout (Post)', 'bne' ),
	'description'	=>	esc_html__( 'Choose the default sidebar layout for blog post. Each post can override this setting.', 'bne' ),
	'default'		=>	'right-sidebar',
	'choices'		=>	array(
		'right-sidebar'		=> 	$kirki_imagepath . 'layouts/' . 'sidebar_right.png',
		'left-sidebar'		=> 	$kirki_imagepath . 'layouts/' . 'sidebar_left.png',
		'double-sidebar'	=> 	$kirki_imagepath . 'layouts/' . 'sidebar_double.png',
		'no-sidebar'		=> 	$kirki_imagepath . 'layouts/' . 'sidebar_none.png',
	),
) );

// Post Image Style
Kirki::add_field( $kirki_prefix, array(
	'section'		=> 	$kirki_prefix.'_section_post',
	'settings'		=> 	'post_single_thumbnail_style',
	'type'			=> 	'select',
	'label'			=> 	esc_html__( 'Post Image Style', 'bne' ),
	'description'	=> 	esc_html__( 'Adjust the the post image style.', 'bne' ),
	'default'		=> 	'default',
	'choices'		=> 	array(
		'flat'			=>	esc_html__( 'Flat (no frame)', 'bne' ),
		'pretty'		=>	esc_html__( 'Pretty', 'bne' ),
		'modern'		=>	esc_html__( 'Modern', 'bne' ),
	),
) );


// Post Nav
Kirki::add_field( $kirki_prefix, array(
	'section'		=>	$kirki_prefix.'_section_post',
	'settings'		=>	'post_single_nav',
	'type'			=>	'select',
	'label'			=>	esc_html__( 'Post Nav', 'bne' ),
	'description'	=>	esc_html__( 'Choose whether you want to show a navigation button after each post to navigate to the next/previous post.', 'bne' ),
	'default'		=>	'hide',
	'choices'		=>	array(
		'hide'			=>	esc_html__( 'Hide bottom nav', 'bne' ),
		'show'			=>	esc_html__( 'Show bottom nav', 'bne' ),
	),
) );

// Share buttons
Kirki::add_field( $kirki_prefix, array(
	'section'		=>	$kirki_prefix.'_section_post',
	'settings'		=>	'post_share_buttons',
	'type'			=>	'select',
	'label'			=>	esc_html__( 'Share Buttons', 'bne' ),
	'description'	=>	esc_html__( 'Choose whether you want to show the theme share buttons at the end of the post.', 'bne' ),
	'default'		=>	'show',
	'choices'		=>	array(
		'show' 		=>		esc_html__( 'Show share buttons', 'bne' ),
		'hide' 		=>		esc_html__( 'Hide share buttons', 'bne' ),
	),
) );

// Author box
Kirki::add_field( $kirki_prefix, array(
	'section'		=>	$kirki_prefix.'_section_post',
	'settings'		=>	'post_author_box',
	'type'			=>	'select',
	'label'			=>	esc_html__( 'Post Author Box', 'bne' ),
	'description'	=>	esc_html__( 'Display the post author\'s biography at the end of their blog post.', 'bne' ),
	'default'		=>	'hide',
	'choices'		=>	array(
		'show'			=>	esc_html__( 'Show share buttons', 'bne' ),
		'hide'			=>	esc_html__( 'Hide share buttons', 'bne' ),
	),
) );