<?php
/*
 * 	WP Customizer Settings - Menu
 *
 * 	@author		Kerry Kline
 * 	@copyright	Copyright (c) Kerry Kline
 * 	@link		http://www.bnecreative.com
 * 	@package 	BNE WordPress Framework
 *	@package	Kirki Toolkit
 *
 *	@updated	July 11, 2020
*/

// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;


// Menu section
Kirki::add_section( $kirki_prefix.'_section_menu', array(
    'title'			=>	esc_html__( 'Primary Menu', 'bne' ),
    'description'	=>	'',
    'panel'			=>	$kirki_prefix.'_options',
) );

// Menu location
Kirki::add_field( $kirki_prefix, array(
	'section'		=>	$kirki_prefix.'_section_menu',
	'type'			=>	'radio-image',
	'settings'		=>	'menu_location',
	'label'			=>	esc_html__( 'Primary Menu Location', 'bne' ),
	'description'	=>	esc_html__( 'Sets the location of the primary menu within the header area.', 'bne' ),
	'default'		=>	'default',
	'choices'		=>	array(
		'default'		=>	$kirki_imagepath . 'layouts/' . 'menu_default.png',
		'below_header'	=> 	$kirki_imagepath . 'layouts/' . 'menu_below.png',
		'above_header'	=> 	$kirki_imagepath . 'layouts/' . 'menu_above.png',
		'header_addon'	=> 	$kirki_imagepath . 'layouts/' . 'menu_opposite.png',
	),
	'transport'		=>	'postMessage',
) );

// Responsive menu
Kirki::add_field( $kirki_prefix, array(
	'section'		=>	$kirki_prefix.'_section_menu',
	'type'			=>	'select',
	'settings'		=>	'responsive_menu',
	'label'			=>	esc_html__( 'Responsive Menu', 'bne' ),
	'description'	=>	esc_html__( 'Choose the responsive menu style to use for mobile and small tablet devices.', 'bne' ),
	'default'		=>	'graphical_responsive_menu',
	'choices'		=>	array(
		'graphical_responsive_menu'	=>	esc_html__( 'Graphical Menu (default)', 'bne' ),
		'side_responsive_menu'		=>	esc_html__( 'Off Canvas Menu', 'bne' ),
		'disable_responsive_menu'	=>	esc_html__( 'Disable Mobile Nav', 'bne' ),
	),
) );

// Mobile nav label
Kirki::add_field( $kirki_prefix, array(
	'section'		=>	$kirki_prefix.'_section_menu',
	'type'			=>	'text',
	'settings'		=>	'mobile_nav_label',
	'label'			=>	esc_html__( 'Mobile Nav Button Label', 'bne' ),
	'description'	=>	esc_html__( 'Adjust the label used for the mobile navigation button. Dynamic variables can be used here such as {icon_bars}.', 'bne' ),
	'default'		=>	'{icon_bars}',
) );

// Center Nav
Kirki::add_field( $kirki_prefix, array(
	'type'			=>	'toggle',
	'settings'		=>	'menu_center',
	'label'			=>	esc_html__( 'Center Menu Links', 'bne' ),
	'description'	=>	esc_html__( 'Center align the top level links of the main menu.', 'bne' ),
	'section'		=>	$kirki_prefix.'_section_menu',
	'default'		=>	false,
	'transport'  	=>	'postMessage'
) );

// Menu extras
Kirki::add_field( $kirki_prefix, array(
	'section'		=>	$kirki_prefix.'_section_menu',
	'type'			=>	'multicheck',
	'settings'		=>	'menu_extras',
	'label'			=>	esc_html__( 'Menu Extras', 'bne' ),
	'description'	=>	esc_html__( 'Enable a number of additional features for the primary menu.', 'bne' ),
	'choices'		=>	array(
		'search'		=>	esc_html__( 'Search Overlay', 'bne' ),
		'cart'			=>	esc_html__( 'WooCommerce Shopping Cart', 'bne' ),
	),
) );

// Font
Kirki::add_field( $kirki_prefix, array(
	'type'			=>	'typography',
	'settings'		=>	'menu_font',
	'label'			=>	esc_html__( 'Menu Font', 'bne' ),
	'description'	=>	'',
	'section'		=>	$kirki_prefix.'_section_menu',
	'default'		=>	array(
		'font-family'	=>	'-apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Oxygen-Sans, Ubuntu, Cantarell, "Helvetica Neue", sans-serif',
		'variant'		=>	'400',
		'font-size'		=>	'16px',
		'text-transform'=>	'none'
	),
	'choices' => array(
		'fonts' => array(
			'google',
			'standard',
		),
	),
) );


// Sub Menu Font
Kirki::add_field( $kirki_prefix, array(
	'type'			=>	'toggle',
	'settings'		=>	'menu_font_sub',
	'label'			=>	esc_html__( 'Submenu Font', 'bne' ),
	'description'	=>	esc_html__( 'Apply the top level menu font to the submenu items.', 'bne' ),
	'section'		=>	$kirki_prefix.'_section_menu',
	'default'		=>	false,
) );


// Background color
Kirki::add_field( $kirki_prefix, array(
	'type'        	=> 	'color',
	'settings'    	=> 	'menu_bg_color',
	'label'       	=> 	esc_attr__( 'Menu Background Color', 'bne' ),
	'description' 	=> 	'',
	'section'     	=> $kirki_prefix.'_section_menu',
	'default'     	=>	'#f4f4f4',
	'choices'		=> 	array(
		'alpha' 		=>	true,
	),
) );

// Top level bg hover color
Kirki::add_field( $kirki_prefix, array(
	'type'			=>	'color',
	'settings'		=>	'menu_bg_color_hover',
	'label'			=>	esc_html__( 'Top Level Background Color (hover)', 'bne' ),
	'description'	=>	'',
	'section'		=>	$kirki_prefix.'_section_menu',
	'default'		=>	'#ffffff',
	'choices'		=>	array(
		'alpha'			=>	true,
	),
) );

// Top level link color
Kirki::add_field( $kirki_prefix, array(
	'type'			=>	'color',
	'settings'		=>	'menu_link_color',
	'label'			=>	esc_html__( 'Top Level Text Color', 'bne' ),
	'description'	=>	'',
	'section'		=>	$kirki_prefix.'_section_menu',
	'default'		=>	'#666666',
) );

// Top level link color (hover)
Kirki::add_field( $kirki_prefix, array(
	'type'			=>	'color',
	'settings'		=>	'menu_link_color_hover',
	'label'			=>	esc_html__( 'Top Level Text Color (hover)', 'bne' ),
	'description'	=>	'',
	'section'		=>	$kirki_prefix.'_section_menu',
	'default'		=>	'#666666',
) );

// Sub Menu background color
Kirki::add_field( $kirki_prefix, array(
	'type'			=>	'color',
	'settings'		=>	'menu_sub_bg_color',
	'label'			=>	esc_html__( 'Dropdown Background Color', 'bne' ),
	'description'	=>	'',
	'section'		=>	$kirki_prefix.'_section_menu',
	'default'		=>	'#ffffff',
	'choices'		=>	array(
		'alpha'			=>	true,
	),
) );

// Sub Menu background color hover
Kirki::add_field( $kirki_prefix, array(
	'type'			=>	'color',
	'settings'		=>	'menu_sub_bg_color_hover',
	'label'			=>	esc_html__( 'Dropdown Background Color (hover)', 'bne' ),
	'description'	=>	'',
	'section'		=>	$kirki_prefix.'_section_menu',
	'default'		=>	'#f4f4f4',
	'choices'		=>	array(
		'alpha'			=>	true,
	),
) );

// Sub Menu link color
Kirki::add_field( $kirki_prefix, array(
	'type'			=>	'color',
	'settings'		=>	'menu_sub_link_color',
	'label'			=>	esc_html__( 'Dropdown Text Color', 'bne' ),
	'description'	=>	'',
	'section'		=>	$kirki_prefix.'_section_menu',
	'default'		=>	'#666666',
) );

// Sub Menu link color (hover)
Kirki::add_field( $kirki_prefix, array(
	'type'			=>	'color',
	'settings'		=>	'menu_sub_link_color_hover',
	'label'			=>	esc_html__( 'Dropdown Text Color (hover)', 'bne' ),
	'description'	=>	'',
	'section'		=>	$kirki_prefix.'_section_menu',
	'default'		=>	'#666666',
) );