<?php
/*
 * 	WP Customizer Settings - Header
 *
 * 	@author		Kerry Kline
 * 	@copyright	Copyright (c) Kerry Kline
 * 	@link		http://www.bnecreative.com
 * 	@package 	BNE WordPress Framework
 *	@package	Kirki Toolkit
 *
 *	@updated	August 1, 2020
*/

// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;


// Header Section
Kirki::add_section( $kirki_prefix.'_section_header', array(
	'title'			=>	esc_html__( 'Header', 'bne' ),
	'description'	=>	'',
	'panel'			=>	$kirki_prefix.'_options',
) );


if( 'header_sidebar_layout' != get_theme_mod('layout', 'wide_layout' ) ) {

	// Header Layout
	Kirki::add_field( $kirki_prefix, array(
		'section'		=>	$kirki_prefix.'_section_header',
		'type'			=>	'radio-image',
		'settings'		=>	'header_columns',
		'label'			=>	esc_html__( 'Header Columns', 'bne' ),
		'description'	=>	__( 'Choose the column layout to use for the main header area. This will determine the max size of the left side (logo) and the right side (Header Content). <br><br> If the full size (single column) layout is selected, the header content and logo will be centered.', 'bne' ),
		'default'		=>	'half_half',
		'choices'		=>	array(
			'full_header'			=>	$kirki_imagepath . 'layouts/' . 'header_column_full.png',
			'half_half'				=>	$kirki_imagepath . 'layouts/' . 'header_column_half_half.png',
			'third_two_thirds'		=>	$kirki_imagepath . 'layouts/' . 'header_column_third_twothirds.png',
			'fourth_three_fourth'	=>	$kirki_imagepath . 'layouts/' . 'header_column_fourth_threefourth.png'
		),
	) );

	// Sticky header
	Kirki::add_field( $kirki_prefix, array(
		'section'		=>	$kirki_prefix.'_section_header',
		'type'			=>	'select',
		'settings'		=>	'sticky_header',
		'label'			=>	esc_html__( 'Sticky Header', 'bne' ),
		'description'	=>	esc_html__( 'After scrolling, keep the primary menu and logo, at the top of the browser window (sticky) for desktop screens.', 'bne' ),
		'default'		=>	'false',
		'choices'		=>	array(
			'false'			=>	esc_html__( 'Stay in Place (default)', 'bne' ),
			'true'			=>	esc_html__( 'Sticky - Fixed Position', 'bne' ),
		),
	) );

}



// Header social bar
Kirki::add_field( $kirki_prefix, array(
	'section'		=>	$kirki_prefix.'_section_header',
	'type'			=>	'toggle',
	'settings'		=>	'header_contact_bar',
	'label'			=>	esc_html__( 'Display Social Icons?', 'bne' ),
	'description'	=>	esc_html__( 'Show or Hide the social media icons within the header.', 'bne' ),
	'default'		=>	true,
) );

// Social bar colors
Kirki::add_field( $kirki_prefix, array(
	'section'		=>	$kirki_prefix.'_section_header',
	'type'			=>	'select',
	'settings'		=>	'header_contact_bar_color',
	'label'			=>	esc_html__( 'Social Icon Color', 'bne' ),
	'description'	=>	esc_html__( 'Choose a color style for the social media icons.', 'bne' ),
	'default'		=>	'color',
	'choices'		=>	array(
		'color'		=>	esc_html__( 'Color', 'bne' ),
		'light'		=>	esc_html__( 'Light', 'bne' ),
		'grey'		=>	esc_html__( 'Grey', 'bne' ),
		'dark'		=>	esc_html__( 'Dark', 'bne' ),
	),
) );

// Social bar shape
Kirki::add_field( $kirki_prefix, array(
	'section'		=>	$kirki_prefix.'_section_header',
	'type'			=>	'select',
	'settings'		=>	'header_contact_bar_shape',
	'label'			=>	esc_html__( 'Social Icon Shape', 'bne' ),
	'description'	=>	esc_html__( 'Choose a shape style for the social media icons.', 'bne' ),
	'default'		=>	'rounded',
	'choices'		=>	array(
		'rounded'		=>	esc_html__( 'Rounded', 'bne' ),
		'square'		=>	esc_html__( 'Square', 'bne' ),
		'circle'		=>	esc_html__( 'Circle', 'bne' ),
		'transparent'	=>	esc_html__( 'Transparent (No Background)', 'bne' ),
	),
) );

// Social bar size
Kirki::add_field( $kirki_prefix, array(
	'section'		=>	$kirki_prefix.'_section_header',
	'type'			=>	'text',
	'settings'		=>	'header_contact_bar_size',
	'label'			=>	esc_html__( 'Social Icon Size', 'bne' ),
	'description'	=>	esc_html__( 'Choose a size (px) for the header icons.', 'bne' ),
	'default'		=>	'25px',
) );

// Mobile logo
Kirki::add_field( $kirki_prefix, array(
	'section'		=>	$kirki_prefix.'_section_header',
	'type'			=>	'image',
	'settings'		=>	'logo_mobile',
	'label'			=>	esc_html__( 'Mobile Header Logo', 'bne' ),
	'description'	=>	__( 'Optional. When on smaller screens, use the mobile logo instead of the default site logo.', 'bne' ),
) );

// Sticky logo
Kirki::add_field( $kirki_prefix, array(
	'section'		=>	$kirki_prefix.'_section_header',
	'type'			=>	'image',
	'settings'		=>	'logo_sticky',
	'label'			=>	esc_html__( 'Sticky Header Logo', 'bne' ),
	'description'	=>	__( 'Optional. When using the <b>sticky header</b> option (sticky menu), you may want to use a different styled logo.', 'bne' ),
	'default'		=>	'',
	'choices'		=>	'',
) );

// Overlay logo
Kirki::add_field( $kirki_prefix, array(
	'section'		=>	$kirki_prefix.'_section_header',
	'type'			=>	'image',
	'settings'		=>	'logo_overlay',
	'label'			=>	esc_html__( 'Overlay Header Logo', 'bne' ),
	'description'	=>	__( 'Optional. When using the <b>header overlay</b> option (transparent header), you may want to use a different styled logo. Note: On mobile, the default site logo will be used.', 'bne' ),
) );
