<?php
/*
 * 	WP Customizer Settings - General
 *
 * 	@author		Kerry Kline
 * 	@copyright	Copyright (c) Kerry Kline
 * 	@link		http://www.bnecreative.com
 * 	@package 	BNE WordPress Framework
 *	@package	Kirki Toolkit
 *
 *	@updated	September 5, 2020
*/

// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

// General Section
Kirki::add_section( $kirki_prefix.'_section_general', array(
	'title'			=>	esc_html__( 'General', 'bne' ),
	'description'	=>	'',
	'panel'			=>	$kirki_prefix.'_options',
) );

// Layout
Kirki::add_field( $kirki_prefix, array(
	'section'		=>	$kirki_prefix.'_section_general',
	'settings'		=>	'layout',
	'type'			=>	'select',
	'label'			=>	esc_html__( 'Layout', 'bne' ),
	'description'	=>	esc_html__( 'Choose to display your website either in a Box, Wide (Stretched), or a fixed sidebar layout.', 'bne' ),
	'default'		=>	'wide_layout',
	'choices'		=>	array(
		'wide_layout'			=>	esc_html__( 'Wide Layout', 'bne'),
		'boxed_layout'			=>	esc_html__( 'Boxed Layout', 'bne'),
		'header_sidebar_layout'	=>	esc_html__( 'Header Sidebar Layout', 'bne'),
	),
) );

// Content Width
Kirki::add_field( $kirki_prefix, array(
	'section'		=> 	$kirki_prefix.'_section_general',
	'settings'		=> 	'content_width',
	'type'			=> 	'select',
	'label'			=> 	esc_html__( 'Content Width', 'bne' ),
	'description'	=>	esc_html__( 'Choose a max size for your content area\'s width. This will also determine the max size available for post thumbnails. Selecting 100% will still provide a minimal gutter around the browser edge for the content.', 'bne' ),
	'default'		=> 	'1200px',
	'choices'		=> 	array(
		'940px'			=>	esc_html__( '940px', 'bne'),
		'1000px'		=>	esc_html__( '1000px', 'bne'),
		'1100px'		=>	esc_html__( '1100px', 'bne'),
		'1200px'		=>	esc_html__( '1200px', 'bne'),
		'1440px'		=>	esc_html__( '1440px', 'bne'),
		'100%'			=>	esc_html__( '100% (no limit)', 'bne'),
	),
	'transport'		=>	'postMessage'

) );

// Breadcrumbs
Kirki::add_field( $kirki_prefix, array(
	'section'		=>	$kirki_prefix.'_section_general',
	'settings'		=>	'breadcrumbs',
	'type'			=>	'select',
	'label'			=>	esc_html__( 'Breadcrumbs', 'textdomain' ),
	'description'	=>	esc_html__( 'Select whether you\'d like breadcrumbs to show throughout the site or not.', 'bne' ),
	'default'		=>	'hide',
	'choices'		=>	array(
		'show'			=>	esc_html__( 'Yes, show breadcrumbs', 'bne' ),
		'hide'			=>	esc_html__( 'No, hide breadcrumbs', 'bne' ),
	),
) );

// Page Heading Wrapper
Kirki::add_field( $kirki_prefix, array(
	'section'		=>	$kirki_prefix.'_section_general',
	'settings'		=>	'page_heading',
	'type'			=>	'select',
	'label'			=>	esc_html__( 'Page Headings', 'textdomain' ),
	'description'	=>	esc_html__( 'Select whether you\'d like the single page and post titles to be featured above their content with a custom background style or kept within the article.', 'bne' ),
	'default'		=>	'default',
	'choices'		=>	array(
		'default'		=>	esc_html__( 'Default location', 'bne' ),
		'featured'		=>	esc_html__( 'Move above content', 'bne' ),
	),
	'tooltip'		=>	'Publish and Refresh the page to see this change.'
) );


// Dark Theme
// Kirki::add_field( $kirki_prefix, array(
// 	'section'		=>	$kirki_prefix.'_section_general',
// 	'type'			=>	'toggle',
// 	'settings'		=>	'dark_theme',
// 	'label'			=>	esc_html__( 'Enable Dark Theme Base Styles', 'bne' ),
// 	'description'	=>	esc_html__( 'Replaces various lighter default theme colors in favor of a darker color palette. This will also adjust the block editor to attempt to utilize darker styles. Typography and background styles are done in their respective areas in the Customizer.', 'bne' ),
// 	'default'		=>	false,
// ) );



// Default Theme Button Color
Kirki::add_field( $kirki_prefix, array(
	'section'		=>	$kirki_prefix.'_section_general',
	'type'			=>	'color',
	'settings'		=>	'button_color',
	'label'			=>	esc_html__( 'Default Button Color', 'bne' ),
	'description'	=>	esc_html( 'Sets the color used for default theme and system buttons.', 'bne'),
	'default'		=>	'#007bff',
) );

// Default Theme Primary Color
Kirki::add_field( $kirki_prefix, array(
	'section'		=>	$kirki_prefix.'_section_general',
	'type'			=>	'color',
	'settings'		=>	'theme_primary_color',
	'label'			=>	esc_html__( 'Default Primary Color', 'bne' ),
	'description'	=>	esc_html( 'Sets the theme primary color for the block editor palette and primary theme styles.', 'bne'),
	'default'		=>	'#0099ff',
) );

// Default Theme Secondary Color
Kirki::add_field( $kirki_prefix, array(
	'section'		=>	$kirki_prefix.'_section_general',
	'type'			=>	'color',
	'settings'		=>	'theme_secondary_color',
	'label'			=>	esc_html__( 'Default Secondary Color', 'bne' ),
	'description'	=>	esc_html( 'Sets the theme secondary color for the block editor palette and secondary theme styles.', 'bne'),
	'default'		=>	'#7892BC',
) );

// Default Theme Tertiary Color
Kirki::add_field( $kirki_prefix, array(
	'section'		=>	$kirki_prefix.'_section_general',
	'type'			=>	'color',
	'settings'		=>	'theme_tertiary_color',
	'label'			=>	esc_html__( 'Default Tertiary Color', 'bne' ),
	'description'	=>	esc_html( 'Sets the theme tertiary color for the block editor palette and tertiary theme styles.', 'bne'),
	'default'		=>	'#EEE8A9',
) );