<?php
/*
 * 	WP Customizer Settings - Footer
 *
 * 	@author		Kerry Kline
 * 	@copyright	Copyright (c) Kerry Kline
 * 	@link		http://www.bnecreative.com
 * 	@package 	BNE WordPress Framework
 *	@package	Kirki Toolkit
 *
 *	@updated	July 11, 2020
*/

// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;


// Footer Section
Kirki::add_section( $kirki_prefix.'_section_footer', array(
	'title'			=>	esc_html__( 'Footer', 'bne' ),
	'description'	=>	'',
	'panel'			=>	$kirki_prefix.'_options',
) );

// Footer Layout
Kirki::add_field( $kirki_prefix, array(
	'section'		=>	$kirki_prefix.'_section_footer',
	'type'			=>	'radio-image',
	'settings'		=>	'footer_sub_content_layout',
	'label'			=>	esc_html__( 'Footer layout', 'bne' ),
	'default'		=>	'default',
	'choices'		=>	array(
		'default'		=>	$kirki_imagepath . 'layouts/' . 'footer_default.png',
		'stacked'		=>	$kirki_imagepath . 'layouts/' . 'footer_stacked.png',
	),
) );

// Footer Widget Columns
Kirki::add_field( $kirki_prefix, array(
	'section'		=>	$kirki_prefix.'_section_footer',
	'type'			=>	'select',
	'settings'		=>	'footer_columns',
	'label'			=>	esc_html__( 'Footer Widget Columns', 'bne' ),
	'default'		=>	'0',
	'choices'		=>	array(
		'0' 			=>	esc_html__( 'Hide Columns','bne' ),
		'1' 			=>	esc_html__( '1 Column: 100%','bne' ),
		'2' 			=>	esc_html__( '2 Columns: 50% | 50%','bne' ),
		'2_4-8' 		=>	esc_html__( '2 Columns: 25% | 75%','bne' ),
		'2_3-9'			=>	esc_html__( '2 Columns: 33% | 66%','bne' ),
		'2_9-3' 		=>	esc_html__( '2 Columns: 66% | 33%','bne' ),
		'2_8-4' 		=>	esc_html__( '2 Columns: 75% | 25%','bne' ),
		'3' 			=>	esc_html__( '3 Columns: 33% | 33% | 33%','bne' ),
		'3_3-3-6' 		=>	esc_html__( '3 Columns: 25% | 25% | 50%','bne' ),
		'3_3-6-3' 		=>	esc_html__( '3 Columns: 25% | 50% | 25%','bne' ),
		'3_6-3-3' 		=>	esc_html__( '3 Columns: 50% | 25% | 25%','bne' ),
		'4' 			=>	esc_html__( '4 Columns: 25% | 25% | 25% | 25%','bne' ),
		'5'				=>	esc_html__( '5 Columns: 20% | 20% | 20% | 20% | 20%','bne' ),
	),
) );

// Footer copy
Kirki::add_field( $kirki_prefix, array(
	'section'		=>	$kirki_prefix.'_section_footer',
	'type'			=>	'textarea',
	'settings'		=>	'footer_copytext',
	'label'			=>	esc_html__( 'Footer Copyright Text', 'bne' ),
	'description'	=>	sprintf(
							esc_html__('Enter the copyright text you\'d like to show in the footer of your site. %s %s %s', 'bne'),
							'<p>{year} - '.esc_html__( 'Show current year.','bne' ).'<br>',
							'{icon_copyright} - '.esc_html__( 'Show the copyright icon','bne' ).'<br>',
							'{site_title} - '.esc_html__( 'Show your site title.','bne' ).'</p>'
						),
	'default'		=>	'{icon_copyright} {year} {site_title}',
	'transport'		=>	'postMessage'
) );