<?php
/*
 * 	WP Customizer Settings - Backgrounds
 *
 * 	@author		Kerry Kline
 * 	@copyright	Copyright (c) Kerry Kline
 * 	@link		http://www.bnecreative.com
 * 	@package 	BNE WordPress Framework
 *	@package	Kirki Toolkit
 *
 *	@updated	November 3, 2020
*/

// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;


// Backgorund Section
Kirki::add_section( $kirki_prefix.'_section_backgrounds', array(
    'title'			=>	esc_html__( 'Backgrounds', 'bne' ),
    'description'	=>	'',
    'panel'			=>	$kirki_prefix.'_options',
) );


// Body
Kirki::add_field( $kirki_prefix, array(
	'type'			=>	'background',
	'settings'		=>	'body_bg',
	'label'			=>	esc_attr__( 'Page (body) Background', 'bne' ),
	'description'	=>	'',
	'section'		=>	$kirki_prefix.'_section_backgrounds',
	'default'		=>	array(
		'background-color'		=>	'rgba(0,0,0,0)',
		'background-image'		=>	'',
		'background-repeat'		=>	'no-repeat',
		'background-position'	=>	'center center',
		'background-size'		=>	'cover',
		'background-attachment'	=>	'scroll',
	),
) );


// Header
Kirki::add_field( $kirki_prefix, array(
	'type'			=>	'background',
	'settings'		=>	'header_bg',
	'label'			=>	esc_attr__( 'Header Background', 'bne' ),
	'description'	=>	'',
	'section'		=>	$kirki_prefix.'_section_backgrounds',
	'default'		=>	array(
		'background-color'		=>	'rgba(0,0,0,0)',
		'background-image'		=>	'',
		'background-repeat'		=>	'no-repeat',
		'background-position'	=>	'center center',
		'background-size'		=>	'cover',
		'background-attachment'	=>	'scroll',
	),
) );


// Main
Kirki::add_field( $kirki_prefix, array(
	'type'			=>	'background',
	'settings'		=>	'main_bg',
	'label'			=>	esc_attr__( 'Container (main) Background', 'bne' ),
	'description'	=>	'',
	'section'		=>	$kirki_prefix.'_section_backgrounds',
	'default'		=>	array(
		'background-color'		=>	'rgba(0,0,0,0)',
		'background-image'		=>	'',
		'background-repeat'		=>	'no-repeat',
		'background-position'	=>	'center center',
		'background-size'		=>	'cover',
		'background-attachment'	=>	'scroll',
	),
) );

// Footer Widgets
/*
Kirki::add_field( $kirki_prefix, array(
	'type'			=>	'background',
	'settings'		=>	'footer_widgets_bg',
	'label'			=>	esc_attr__( 'Footer Widgets Background', 'bne' ),
	'description'	=>	'',
	'section'		=>	$kirki_prefix.'_section_backgrounds',
	'default'		=>	array(
		'background-color'		=>	'rgba(0,0,0,0)',
		'background-image'		=>	'',
		'background-repeat'		=>	'no-repeat',
		'background-position'	=>	'center center',
		'background-size'		=>	'cover',
		'background-attachment'	=>	'scroll',
	),
) );
*/

// Footer
Kirki::add_field( $kirki_prefix, array(
	'type'			=>	'background',
	'settings'		=>	'footer_bg',
	'label'			=>	esc_attr__( 'Footer Background', 'bne' ),
	'description'	=>	'',
	'section'		=>	$kirki_prefix.'_section_backgrounds',
	'default'		=>	array(
		'background-color'		=>	'rgba(0,0,0,0)',
		'background-image'		=>	'',
		'background-repeat'		=>	'no-repeat',
		'background-position'	=>	'center center',
		'background-size'		=>	'cover',
		'background-attachment'	=>	'scroll',
	),
) );

// Page Heading
if( 'featured' == get_theme_mod('page_heading', 'default' ) ) {
	Kirki::add_field( $kirki_prefix, array(
		'type'			=>	'background',
		'settings'		=>	'page_heading_bg',
		'label'			=>	esc_attr__( 'Page Heading Background', 'bne' ),
		'description'	=>	'',
		'section'		=>	$kirki_prefix.'_section_backgrounds',
		'default'		=>	array(
			'background-color'		=>	'#f7f5f5',
			'background-image'		=>	'',
			'background-repeat'		=>	'no-repeat',
			'background-position'	=>	'center center',
			'background-size'		=>	'cover',
			'background-attachment'	=>	'scroll',
		),
	) );
}
