<?php
/*
 * 	WP Customizer Settings - Archive
 *
 * 	@author		Kerry Kline
 * 	@copyright	Copyright (c) Kerry Kline
 * 	@link		http://www.bnecreative.com
 * 	@package 	BNE WordPress Framework
 *	@package	Kirki Toolkit
 *
*/

// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;


// Archive Section
Kirki::add_section( $kirki_prefix.'_section_archive', array(
    'title'			=> 	esc_html__( 'Archive Pages', 'bne' ),
    'description'	=> 	'',
    'panel'			=> 	$kirki_prefix.'_options',
) );

// Sidebar Layout
Kirki::add_field( $kirki_prefix, array(
	'section'		=>	$kirki_prefix.'_section_archive',
	'type'			=>	'radio-image',
	'settings'		=>	'sidebar_layout_archive',
	'label'			=>	esc_html__( 'Default Sidebar Layout', 'bne' ),
	'description'	=>	esc_html__( 'Choose the default sidebar layout for archive pages.', 'bne' ),
	'default'		=>	'right-sidebar',
	'choices'		=>	array(
		'right-sidebar'		=>	$kirki_imagepath . 'layouts/' . 'sidebar_right.png',
		'left-sidebar'		=>	$kirki_imagepath . 'layouts/' . 'sidebar_left.png',
		'double-sidebar' 	=>	$kirki_imagepath . 'layouts/' . 'sidebar_double.png',
		'no-sidebar' 		=>	$kirki_imagepath . 'layouts/' . 'sidebar_none.png',
	),
) );

// Archive Title
Kirki::add_field( $kirki_prefix, array(
	'section'		=>	$kirki_prefix.'_section_archive',
	'type'			=>	'toggle',
	'settings'		=>	'post_archive_title',
	'label'			=>	esc_html__( 'Page Title', 'bne' ),
	'description'	=>	esc_html__( 'If the main post page or a custom taxonomy archive, this will display the title within an h1 tag.', 'bne' ),
	'default'		=>	true,
) );

// Archive Description
Kirki::add_field( $kirki_prefix, array(
	'section'		=>	$kirki_prefix.'_section_archive',
	'type'			=>	'toggle',
	'settings'		=>	'post_archive_description',
	'label'			=>	esc_html__( 'Page Description', 'bne' ),
	'description'	=>	esc_html__( 'If a custom taxonomy archive, this will display the description before the archive content.', 'bne' ),
	'default'		=>	true,
) );



// Archive Layout
Kirki::add_field( $kirki_prefix, array(
	'section'		=> 	$kirki_prefix.'_section_archive',
	'settings'		=> 	'post_archive_layout',
	'type'			=> 	'select',
	'label'			=> 	esc_html__( 'Layout', 'bne' ),
	'description'	=>	esc_html__( 'Choose to display the default blog post page and taxonomy archives using a list or grid layout.', 'bne' ),
	'default'		=> 	'list',
	'choices'		=> 	array(
		'grid'			=>	esc_html__( 'Grid Layout', 'bne' ),
		'list'			=>	esc_html__( 'List Layout', 'bne' ),
	),
) );

// Grid Columns
Kirki::add_field( $kirki_prefix, array(
	'section'		=> 	$kirki_prefix.'_section_archive',
	'settings'		=> 	'post_archive_grid_columns',
	'type'			=> 	'select',
	'label'			=> 	esc_html__( 'Grid Columns', 'bne' ),
	'description'	=>	esc_html__( 'When using a Post Grid Template, set the number of columns for each row.', 'bne' ),
	'default'		=> 	2,
	'choices'		=> 	array(
		2				=>	esc_html__( '2 Columns', 'bne' ),
		3				=>	esc_html__( '3 Columns', 'bne' ),
		4				=>	esc_html__( '4 Columns', 'bne' ),
		5				=>	esc_html__( '5 Columns', 'bne' ),
	),
) );

// Grid Style
Kirki::add_field( $kirki_prefix, array(
	'section'		=> 	$kirki_prefix.'_section_archive',
	'settings'		=> 	'post_archive_grid_style',
	'type'			=> 	'select',
	'label'			=> 	esc_html__( 'Grid Style', 'bne' ),
	'description'	=>	esc_html__( 'When using a Post Grid Template, show the post as cards or a default style.', 'bne' ),
	'default'		=> 	'default',
	'choices'		=> 	array(
		'default'		=>	esc_html__( 'Default (no style)', 'bne' ),
		'card'			=>	esc_html__( 'Card', 'bne' ),
	),
) );


// Thumbnail Size
Kirki::add_field( $kirki_prefix, array(
	'section'		=>	$kirki_prefix.'_section_archive',
	'settings'		=>	'post_archive_thumbnail_size',
	'type'			=>	'select',
	'label'			=>	esc_html__( 'Featured Image Size', 'bne' ),
	'description'	=>	esc_html__( 'Select the size of the post thumbnail.', 'bne' ),
	'default'		=>	'post-thumbnail',
	'choices'		=>	array(
		'post-thumbnail'	=>	esc_html__( 'Full ', 'bne' ),
		'large'				=>	esc_html__( 'Large', 'bne' ),
		'medium'			=>	esc_html__( 'Medium', 'bne' ),
		'thumbnail'			=>	esc_html__( 'Small', 'bne' ),
		'hide'				=>	esc_html__( 'Hide post images', 'bne' ),
	),
) );

// Thumbnail Style
Kirki::add_field( $kirki_prefix, array(
	'section'		=> 	$kirki_prefix.'_section_archive',
	'settings'		=> 	'post_archive_thumbnail_style',
	'type'			=> 	'select',
	'label'			=> 	esc_html__( 'Featured Image Style', 'bne' ),
	'description'	=>	esc_html__( 'Adjust the the post image style.', 'bne' ),
	'default'		=> 	'flat',
	'choices'		=> 	array(
		'flat'			=>	esc_html__( 'Flat (no frame)', 'bne' ),
		'pretty'		=>	esc_html__( 'Pretty', 'bne' ),
		'modern'		=>	esc_html__( 'Modern', 'bne' ),
	),
) );


// Readmore Label
Kirki::add_field( $kirki_prefix, array(
	'section'		=>	$kirki_prefix.'_section_archive',
	'type'			=>	'text',
	'settings'		=>	'post_read_more_label',
	'label'			=>	esc_html__( 'Read More Button', 'bne' ),
	'description'	=>	__( 'Adjust the text label for the "Read More" button that is displayed below each post on archive and post-list pages.<br><br><em>Note: Button will only show if also using post excerpts above.</em>', 'bne' ),
	'default'		=>	'Read More',
) );
