<?php
/*
 * 	Framework Customizer Support
 *
 * 	@author		Kerry Kline
 * 	@copyright	Copyright (c) Kerry Kline
 * 	@link		http://www.bnecreative.com
 * 	@package 	BNE WordPress Framework
 *
*/

// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

// Add selective refresh to widgets
add_theme_support( 'customize-selective-refresh-widgets' );


/*
 * 	Customizer Styles
 *
 *	@since	v2.0
*/
function bne_customizer_styles() { ?>
	<style>
		.customize-control-kirki-radio-image .image label {
			width: calc( 1/4 * 100% - (1 - 1/3) * 15px );
			margin: 5px;
		}
		
		.control-section-kirki-default .background-wrapper {
			border: 1px solid rgba(0, 0, 0, 0.1);
			padding: 10px;
		}

		.control-section-kirki-default .customize-control {
			margin-bottom: 20px;
		}

		.customize-control-title {
			color: #333;
		}

		.control-section-kirki-default span.description { font-size: 12px; }
		
		.control-section-kirki-default .thumbnail-image img {
			max-width: 97.5%;
			background-image: linear-gradient(45deg,#d0d0d0 25%,transparent 25%,transparent 75%,#d0d0d0 75%,#d0d0d0),linear-gradient(45deg,#d0d0d0 25%,transparent 25%,transparent 75%,#d0d0d0 75%,#d0d0d0);
			background-position: 0 0,10px 10px;
			background-size: 20px 20px;
			border: 1px solid #ccc;
		}
	</style>
	<?php

}
add_action( 'customize_controls_print_styles', 'bne_customizer_styles', 999 );


/*
 * 	Customizer Scripts
 *
 *	@since	v2.2.6
*/
function bne_customizer_scripts() {
	wp_enqueue_script( 'bne_wp_customizer', BNE_FRAMEWORK_ASSETS . '/js/bne-customizer.js', array( 'customize-preview', 'jquery' ), BNE_FRAMEWORK_VERSION, true );
	wp_localize_script( 
		'bne_wp_customizer', 
		'bne_wp_customizer_vars', 
		array(
			'dynamicVars' => array(
				'year' 		=> 	esc_attr( date('Y') ),
				'siteName'	=>	esc_html( get_bloginfo('site_title') )
			)
		) 
	);
  
}
add_action( 'customize_preview_init', 'bne_customizer_scripts' );


// Disable Telemetry module
add_filter( 'kirki_telemetry', '__return_false' );




/*
 *	Automatically load Google Font variations
 *
 *	@since 2.2.8
 *
 * 	@param array $fonts All fonts to be enqueued.
 *
 * 	@return mixed
*/
function bne_kirki_add_google_font_variants( $fonts ) {
	if ( !$fonts ) {
		return $fonts;
	}
	
	foreach( $fonts as $index => $font ) {
		
		// Add italic typeface
		if( !in_array( 'italic', $fonts[$index] ) ) {
			$fonts[$index][] = 'italic';
		}

		// Add regular typeface
		if( !in_array( 'regular', $fonts[$index] ) ) {
			$fonts[$index][] = 'regular';
		}
	
		// Add bold typeface
		if( !in_array( '700', $fonts[$index] ) ) {
			$fonts[$index][] = 700;
		}
		
	}
	
	//bne_printr($fonts);

	return $fonts;
}
add_filter( 'kirki_enqueue_google_fonts', 'bne_kirki_add_google_font_variants' );





/*
 * 	Register Customizer Settings
 *
*/
// Prefix
$kirki_prefix = BNE_THEME_ID;

// Image path
$kirki_imagepath =  BNE_FRAMEWORK_ASSETS . '/images/';

// Assign Kirki config
Kirki::add_config( $kirki_prefix, array(
	'option_type'	=> 	'theme_mod',
	'capability'	=> 	'edit_theme_options',
) );

// Create theme option panel
Kirki::add_panel( $kirki_prefix.'_options', array(
    'priority'		=> 	10,
    'title'			=> 	esc_html__( 'Theme Options', 'bne' ),
    'description'	=> 	esc_html__( 'Customize different areas of the theme.', 'bne' ),
) );


/* ================================ */
// Sections
/* ================================ */

include_once( BNE_FRAMEWORK_DIR . '/includes/customizer/general.php' );

include_once( BNE_FRAMEWORK_DIR . '/includes/customizer/backgrounds.php' );
include_once( BNE_FRAMEWORK_DIR . '/includes/customizer/typography.php' );
include_once( BNE_FRAMEWORK_DIR . '/includes/customizer/menu.php' );
include_once( BNE_FRAMEWORK_DIR . '/includes/customizer/social.php' );

include_once( BNE_FRAMEWORK_DIR . '/includes/customizer/header.php' );
include_once( BNE_FRAMEWORK_DIR . '/includes/customizer/footer.php' );

include_once( BNE_FRAMEWORK_DIR . '/includes/customizer/pages.php' );
include_once( BNE_FRAMEWORK_DIR . '/includes/customizer/post.php' );
include_once( BNE_FRAMEWORK_DIR . '/includes/customizer/archive.php' );

if( class_exists( 'woocommerce' ) ) {
	include_once( BNE_FRAMEWORK_DIR . '/includes/customizer/woocommerce.php' );
}