<?php
/*
 * 	Register and Configure Meta Boxes
 *
 * 	@author		Kerry Kline
 * 	@copyright	Copyright (c) 2018, Kerry Kline
 * 	@link		http://www.bnecreative.com
 *	@package	CMB2 (/includes/lib/cmb2/
 *	@package	BNE WordPress Theme Framework
 *
*/



/*
 * 	Theme CMB Custom Field Types
 *
 *	Using the BNE_CMB_Render_Field Class, we can
 *	streamline custom field type creation at the core level.
 *
 * 	@since 		v1.5.9
 *	@updated	v2.0
 *
*/
function bne_custom_cmb_fields() {
	
	// Make sure our render class is available
	if( !class_exists( 'BNE_CMB_Render_Field' ) ) { return; }
	
	// Grab the ID
	//$post_id = 0;
	//if ( isset( $_GET['post'] ) ) { $post_id = $_GET['post']; }

	// Background Shade
	$field = new BNE_CMB_Render_Field(
		'background_shade',
		array(
			array(
				'column'		=>	'1',
				'field'			=>	array(
					'id'			=>	'shade_color',
					'type'			=>	'colorpicker',
				),
			),
			array(
				'column'		=>	'1',
				'field'			=>	array(
					'id'			=>	'shade_opacity',
					'type'			=>	'select',
				),
				'field_options'	=>	bne_recognized_background_shade_opacity()
			),
		) // End Field(s)
	); // End $field


	// Background Image Styles
	$field = new BNE_CMB_Render_Field(
		'background_image_styles',
		array(
			array(
				'column'		=>	'1/2',
				'field'			=>	array(
					'id'			=>	'repeat',
					'type'			=>	'select',
				),
				'field_options'	=>	bne_recognized_background_repeats()
			),
			array(
				'column'		=>	'1/2',
				'field'			=>	array(
					'id'			=>	'attachment',
					'type'			=>	'select',
				),
				'field_options'	=>	bne_recognized_background_attachments()
			),
			array(
				'column'		=>	'1/2',
				'field'			=>	array(
					'id'			=>	'position',
					'type'			=>	'select',
				),
				'field_options'	=>	bne_recognized_background_positions()
			),
			array(
				'column'		=>	'1/2',
				'field'			=>	array(
					'id'			=>	'size',
					'type'			=>	'select',
				),
				'field_options'	=>	bne_recognized_background_sizes()
			),
		) // End Field(s)
	); // End $field

}
add_action( 'cmb2_admin_init', 'bne_custom_cmb_fields' );



/*
 *	Page/Post Options Meta Box
 *
 *	Defines a set of custom fields to be used on WP Pages and Post.
 *
 *	@since 		v1.3
 *	@updated	v2.2.7
 *
*/
function bne_theme_cmb2_meta_boxes() {
	
	// Set field prefix
	$prefix = 'bne_';
	
	// Class
	$metabox_class = 'bne-cmb-wrapper';

	/*
	 *	Register CMB2 Metabox
	 *	@cpt	Pages
	 *
	*/
	$cmb_page = new_cmb2_box( array(
		'id'            	=>	'bne_theme_meta_box_page',
		'title'        	 	=>  esc_html__( 'Page Options', 'bne' ),
		'object_types'  	=>  array( 'page' ),
		'classes'			=>	$metabox_class,
		'context'			=>	'side',
		'priority'			=>	'low',
	) );

	// Page Title
	$cmb_page->add_field( array(
	    'name'             	=>	esc_html__( 'Page Title', 'bne' ),
		'id'      			=>	$prefix.'title',
	    'type'             	=> 	'select',
	    'show_option_none' 	=> 	false,
	    'options'          	=> 	array(
			'show'				=> esc_html__( 'Show page title', 'bne' ),
			'show_center'		=> esc_html__( 'Show & center page title', 'bne' ),
			'show_right'		=> esc_html__( 'Show & right align page title', 'bne' ),
			'hide' 				=> esc_html__( 'Hide page title', 'bne' ),
	    )
	) );

	// Featured Image within Page Heading Wrapper
	if( 'featured' == get_theme_mod('page_heading', 'default' ) ) {
		
		// Background Image
		$cmb_page->add_field( array(
		    'name'             	=> 	esc_html__( 'Page Title Background', 'bne' ),
			'id'      			=>	$prefix.'page_heading_bg',
		    'type'             	=> 	'select',
		    'description'		=>	'',
		    'show_option_none' 	=> 	false,
		    'options'          	=> 	array(
				'default' 			=> 	esc_html__( 'Use default background', 'bne' ),
				'true' 				=> 	esc_html__( 'Use the featured image', 'bne' ),
		    ),
		) );

		// Heading Color
		$cmb_page->add_field( array(
		    'name'             	=> 	esc_html__( 'Page Title Color', 'bne' ),
			'id'      			=>	$prefix.'page_heading_color',
		    'type'             	=> 	'select',
		    'default'			=>	'default',
		    'options'          	=> 	array(
				'default' 			=> 	esc_html__( 'Use default color', 'bne' ),
				'light' 				=> 	esc_html__( 'Force light text', 'bne' ),
				'dark' 				=> 	esc_html__( 'Force dark text', 'bne' ),
		    )
		) );

	}


	// Breadcrumbs
	$cmb_page->add_field( array(
	    'name'             	=> 	esc_html__( 'Breadcrumbs', 'bne' ),
		'id'      			=>	$prefix.'breadcrumbs',
	    'type'             	=> 	'select',
	    'show_option_none' 	=> 	false,
	    'options'          	=> 	array(
			'default' 			=> 	esc_html__( 'Use default setting', 'bne' ),
			'show' 				=> 	esc_html__( 'Show breadcrumbs', 'bne' ),
			'hide' 				=> 	esc_html__( 'Hide breadcrumbs', 'bne' ),
	    )
	) );

	// Sidebar Layout
	$cmb_page->add_field( array(
	    'name'             	=> 	esc_html__( 'Sidebar Layout', 'bne' ),
		'id'      			=>	$prefix.'sidebar_layout',
	    'type'             	=> 	'select',
	    'show_option_none' 	=> 	false,
	    'options'          	=> 	array(
			'default-sidebar' 	=> 	esc_html__( 'Default Sidebar', 'bne' ),
			'right-sidebar' 	=> 	esc_html__( 'Right Sidebar', 'bne' ),
			'left-sidebar' 		=> 	esc_html__( 'Left Sidebar', 'bne' ),
			'double-sidebar' 	=> 	esc_html__( 'Double Sidebars', 'bne' ),
			'no-sidebar' 		=> 	esc_html__( 'Full Width (no sidebar)', 'bne' ),
	    )
	) );

	// Header
	$cmb_page->add_field( array(
	    'name'             	=> 	esc_html__( 'Header', 'bne' ),
		'id'      			=>	$prefix.'header_display',
	    'type'             	=> 	'select',
	    'show_option_none' 	=> 	false,
	    'options'          	=> 	array(
			'default' 			=> 	esc_html__( 'Standard Header', 'bne' ),
			'transparent' 		=> 	esc_html__( 'Transparent Header', 'bne' ),
			'hide' 				=> 	esc_html__( 'Hide Header', 'bne' ),
	    ),
	) );
	
	// Footer
	$cmb_page->add_field( array(
	    'name'             	=> 	esc_html__( 'Footer', 'bne' ),
		'id'      			=>	$prefix.'footer_display',
	    'type'             	=> 	'select',
	    'show_option_none' 	=> 	false,
	    'options'          	=> 	array(
			'default' 			=> 	esc_html__( 'Standard Footer', 'bne' ),
			'hide' 				=> 	esc_html__( 'Hide Footer', 'bne' ),
	    ),
	) );
	

	/*
	 *	Register CMB2 Metabox
	 *	@cpt	Posts
	 *
	*/
	$cmb_post = new_cmb2_box( array(
		'id'            	=>	'bne_theme_meta_box_post',
		'title'         	=>  esc_html__( 'Post Options', 'bne' ),
		'object_types'  	=>  array( 'post' ),
		'classes'			=>	$metabox_class,
		'context'			=>	'side'
	) );

	// Title
	$cmb_post->add_field( array(
	    'name'             	=>	esc_html__( 'Post Title', 'bne' ),
	    'desc'             	=>	'',
		'id'      			=>	$prefix.'title',
	    'type'             	=> 	'select',
	    'show_option_none' 	=> 	false,
	    'options'          	=> 	array(
			'show'				=> esc_html__( 'Show page title', 'bne' ),
			'show_center'		=> esc_html__( 'Show & center page title', 'bne' ),
			'show_right'		=> esc_html__( 'Show & right align page title', 'bne' ),
			'hide' 				=> esc_html__( 'Hide page title', 'bne' ),
	    ),
	) );

	// Breadcrumbs
	$cmb_post->add_field( array(
	    'name'             	=> 	esc_html__( 'Breadcrumbs', 'bne' ),
	    'desc'             	=>	'',
		'id'      			=>	$prefix.'breadcrumbs',
	    'type'             	=> 	'select',
	    'show_option_none' 	=> 	false,
	    'options'          	=> 	array(
			'default' 			=> 	esc_html__( 'Use default setting', 'bne' ),
			'show' 				=> 	esc_html__( 'Show breadcrumbs', 'bne' ),
			'hide' 				=> 	esc_html__( 'Hide breadcrumbs', 'bne' ),
	    ),
	) );

	// Thumbnail Size
	$cmb_post->add_field( array(
	    'name'             	=> 	esc_html__( 'Post Thumbnail', 'bne' ),
	    'desc'             	=>	'',
		'id'      			=>	$prefix.'post_single_thumbnail_size',
	    'type'             	=> 	'select',
	    'show_option_none' 	=> 	false,
	    'options'          	=> 	array(
			'post-thumbnail' 	=> 	esc_html__( 'Full thumbnail', 'bne' ),
			'large'				=>	esc_html__( 'Large thumbnail', 'bne' ),
			'medium'			=>	esc_html__( 'Medium thumbnail', 'bne' ),
			'thumbnail' 		=> 	esc_html__( 'Small thumbnail', 'bne' ),
			'hide' 				=> 	esc_html__( 'Hide thumbnail', 'bne' ),
	    ),
	) );

	// OEMBED Featured Image Replacement
	$cmb_post->add_field( array(
	    'name'             	=> 	esc_html__( 'Replace featured image with video?', 'bne' ),
	    'desc'             	=> 	sprintf( esc_html__( 'In places where a featured image is supposed to show full size (blog list, grid or single view), it will be replaced with a video. Enter in the URL to the video above. The URL must be compatible with %sWordPress\'s Embed guidelines.%s', 'bne' ), '<a href="http://codex.wordpress.org/Embeds" target="_blank">', '</a>' ),
		'id'      			=>	$prefix.'post_oembed',
	    'type'             	=> 	'oembed',
		'attributes'		=>	array(
			'placeholder'		=>	esc_html__( 'Enter video URL', 'bne' ),
		),
	) );

	// Sidebar Layout
	$cmb_post->add_field( array(
	    'name'             	=> 	esc_html__( 'Sidebar Layout', 'bne' ),
	    'desc'             	=>	'',
		'id'      			=>	$prefix.'sidebar_layout',
	    'type'             	=> 	'select',
	    'show_option_none' 	=> 	false,
	    'options'          	=> 	array(
			'default-sidebar' 	=> 	esc_html__( 'Default Sidebar', 'bne' ),
			'right-sidebar' 	=> 	esc_html__( 'Right Sidebar', 'bne' ),
			'left-sidebar' 		=> 	esc_html__( 'Left Sidebar', 'bne' ),
			'double-sidebar' 	=> 	esc_html__( 'Double Sidebars', 'bne' ),
			'no-sidebar' 		=> 	esc_html__( 'Full Width (no sidebar)', 'bne' ),
	    ),
	) );

	// Header
	$cmb_post->add_field( array(
	    'name'             	=> 	esc_html__( 'Header', 'bne' ),
	    'desc'             	=>	'',
		'id'      			=>	$prefix.'header_display',
	    'type'             	=> 	'select',
	    'show_option_none' 	=> 	false,
	    'options'          	=> 	array(
			'default' 			=> 	esc_html__( 'Standard Header', 'bne' ),
			'transparent' 		=> 	esc_html__( 'Transparent Header', 'bne' ),
			'hide' 				=> 	esc_html__( 'Hide Header', 'bne' ),
	    ),
	) );

	// Footer
	$cmb_post->add_field( array(
	    'name'             	=> 	esc_html__( 'Footer', 'bne' ),
	    'desc'             	=>	'',
		'id'      			=>	$prefix.'footer_display',
	    'type'             	=> 	'select',
	    'show_option_none' 	=> 	false,
	    'options'          	=> 	array(
			'default' 			=> 	esc_html__( 'Standard Footer', 'bne' ),
			'hide' 				=> 	esc_html__( 'Hide Footer', 'bne' ),
	    ),
	) );

}
add_action( 'cmb2_admin_init', 'bne_theme_cmb2_meta_boxes' );