<?php
/*
 * 	Main Framework Functions begin here!
 *
 * 	@author		Kerry Kline
 * 	@copyright	Copyright (c) Kerry Kline
 * 	@link		http://www.bnecreative.com
 * 	@package 	BNE WordPress Framework
*/

// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;



/* ===========================================================
 *	Main Constants and Includes
 * ======================================================== */

// Framework Constants
define( 'BNE_FRAMEWORK_VERSION', '2.2.15' );
define( 'BNE_FRAMEWORK_URI', get_template_directory_uri().'/framework' );
define( 'BNE_FRAMEWORK_ASSETS', get_template_directory_uri().'/framework/assets' );
define( 'BNE_FRAMEWORK_DIR', get_template_directory().'/framework' );
define( 'BNE_FRAMEWORK_DIR_ASSETS', get_template_directory_uri().'/framework' );
define( 'BNE_FRAMEWORK_PLUGINS_ASSETS', get_template_directory_uri().'/framework/lib' );

define( 'BNE_THEME_ID', 'sweetness' );
define( 'BNE_THEME_NAME', 'Sweetness' );
define( 'BNE_THEME_UPDATE_ID', 'sweetness-v2' );



/* ===========================================================
 *	Classes / Libraries / Add-Ons
 * ======================================================== */

// Theme Updater
require( BNE_FRAMEWORK_DIR .'/lib/update-checker/plugin-update-checker.php' );
$Sweetness = Puc_v4_Factory::buildUpdateChecker(
	'https://updates.bnecreative.com/?action=get_metadata&slug='.BNE_THEME_UPDATE_ID,
	get_template_directory(),
	BNE_THEME_UPDATE_ID
);

// Custom Meta Boxes Library (cmb2)
if( file_exists( BNE_FRAMEWORK_DIR . '/lib/cmb2/init.php' ) ) {
	require_once( BNE_FRAMEWORK_DIR . '/lib/cmb2/init.php' );
}

// Kirki Toolkit Library (WP Customizer)
if( file_exists( BNE_FRAMEWORK_DIR . '/lib/kirki/kirki.php' ) ) {
	include_once( BNE_FRAMEWORK_DIR . '/lib/kirki/kirki.php' );
}

// BNE Class - CMB Field Types Generator
include_once( BNE_FRAMEWORK_DIR . '/lib/bne-classes/bne-cmb-fields.php' );

// BNE Class - CPT Class Generator
include_once( BNE_FRAMEWORK_DIR . '/lib/bne-classes/bne-cpt.php' );

// Suggested & Required Plugins
include_once( BNE_FRAMEWORK_DIR . '/lib/tgm-plugins/class-tgm-plugin-activation.php' );
include_once( BNE_FRAMEWORK_DIR . '/lib/tgm-plugins/plugin-list.php' );


/* ===========================================================
 *	Framework Includes
 * ======================================================== */

// Action Hooks
include_once( BNE_FRAMEWORK_DIR . '/includes/hooks.php' );

// Setup and Configurations
include_once( BNE_FRAMEWORK_DIR . '/includes/setup.php' );
include_once( BNE_FRAMEWORK_DIR . '/includes/support.php' );

// Content
include_once( BNE_FRAMEWORK_DIR . '/includes/parts.php' );
include_once( BNE_FRAMEWORK_DIR . '/includes/widgets.php' );
include_once( BNE_FRAMEWORK_DIR . '/includes/shortcodes.php' );
include_once( BNE_FRAMEWORK_DIR . '/includes/blocks.php' );

// CMB Fields
include_once( BNE_FRAMEWORK_DIR . '/includes/cmb-fields.php' );

// WP Customizer
if( class_exists( 'Kirki' ) ) {
	include_once( BNE_FRAMEWORK_DIR . '/includes/customizer.php' );
}

// WP Media
include_once( BNE_FRAMEWORK_DIR . '/includes/media.php' );

// Theme Options CSS
include_once( BNE_FRAMEWORK_DIR . '/includes/styles.php' );




/* ===========================================================
 *	Plugin Support Functions
 * ======================================================== */

// WooCommerce Support
if( class_exists( 'woocommerce' ) ) {
	include_once( BNE_FRAMEWORK_DIR . '/includes/woocommerce.php' );
}


// 3rd Party Plugins
include_once( BNE_FRAMEWORK_DIR . '/includes/plugin-support.php' );


/* ===========================================================
 *	Scripts and Styles
 * ======================================================== */


/*
 * 	Enqueue Admin Scripts and Styles
 *	Provides option css and JS for Theme Options,
 *	and pages/post where CMB2 is used.
 *
 *	@since 		v1.0
 *	@updated 	v2.2.7
 *
*/
function bne_admin_scripts( $hook ) {

	// Admin CSS
	wp_enqueue_style( 'bne-admin-options', BNE_FRAMEWORK_ASSETS . '/css/admin-options.css', null, BNE_FRAMEWORK_VERSION  );

	// Admin JS
	//wp_enqueue_script( 'bne-admin-options', BNE_FRAMEWORK_ASSETS . '/js/admin-options.js', array('jquery'), BNE_FRAMEWORK_VERSION );
	
	// RGBA Iris Color Picker
	//wp_enqueue_script( 'wp-color-picker-alpha', BNE_FRAMEWORK_ASSETS . '/js/wp-color-picker-alpha.js', array( 'wp-color-picker' ), '1.2.3', true );
	
	
	// July 2020 : compatibility with WP5.5 => wpColorPickerL10n are not loaded by WP core anymore, but we need the alpha colorpickers
	// @note https://core.trac.wordpress.org/ticket/50857
	// @note https://themes.trac.wordpress.org/browser/customizr/4.3.0/core/czr-base-fmk/czr-base-fmk.php?marks=201-217#L195
	// @note https://github.com/CMB2/CMB2/pull/1374/commits/7d7545012245d793efc55b51d65560e8c94f5788
    global $wp_version;
    if( version_compare( $wp_version, '5.4.2' , '>=' ) ) {
        wp_localize_script(
          'wp-color-picker',
          'wpColorPickerL10n',
          array(
            'clear'            => __( 'Clear', 'bne' ),
            'clearAriaLabel'   => __( 'Clear color', 'bne' ),
            'defaultString'    => __( 'Default', 'bne' ),
            'defaultAriaLabel' => __( 'Select default color', 'bne' ),
            'pick'             => __( 'Select Color', 'bne' ),
            'defaultLabel'     => __( 'Color value', 'bne' )
          )
        );
    }

}
add_action( 'admin_enqueue_scripts', 'bne_admin_scripts', 99 );




/*
 *	Enqueue Frontend Scripts and Styles
 *	BNE Core, Bootstrap, Font Awesome, Fancybox, Superfish
 *
 *	@since 		v1.0
 *	@updated 	v2.2.8
 *
*/
function bne_frontend_scripts() {
	$min = ( defined('WP_DEBUG') && true === WP_DEBUG ) ? '' : '.min';
	
	// jQuery
	wp_enqueue_script( 'jquery' );

	// Bootstrap
	if ( is_rtl() ) {
		wp_enqueue_style( 'bootstrap', BNE_FRAMEWORK_ASSETS . '/plugins/bootstrap/css/bootstrap-rtl.min.css', '', '4.6' );
	} else {
		wp_enqueue_style( 'bootstrap', BNE_FRAMEWORK_ASSETS . '/plugins/bootstrap/css/bootstrap.min.css', '', '4.6' );
	}
	wp_enqueue_script( 'bootstrap', BNE_FRAMEWORK_ASSETS . '/plugins/bootstrap/js/bootstrap.bundle.min.js', array('jquery'), '4.6', true );
		
	// Font Awesome v5
	bne_enqueue_fontawesome();

	// Magnific Lightbox
	wp_enqueue_style( 'magnific', BNE_FRAMEWORK_ASSETS . '/plugins/magnific/magnific-popup.css', '', '1.1.0'  );
	wp_enqueue_script( 'magnific', BNE_FRAMEWORK_ASSETS . '/plugins/magnific/jquery.magnific-popup.min.js', array('jquery'), '1.1.0', true );

	// Flexslider (Moved to BNE Slider Plugin)
	//wp_register_script( 'flexslider', BNE_FRAMEWORK_ASSETS . '/plugins/flexslider/jquery.flexslider-min.js', array('jquery'), '2.7.2', true );

	// Superfish
	wp_enqueue_script( 'superfish', BNE_FRAMEWORK_ASSETS . '/js/superfish.min.js', array('jquery'), '1.7.10', true );

	// Core BNE Framework
	wp_enqueue_style( 'bne_framework', BNE_FRAMEWORK_ASSETS . '/css/bne-main'.$min.'.css', array('bootstrap'), BNE_FRAMEWORK_VERSION );
	wp_enqueue_script( 'bne_framework', BNE_FRAMEWORK_ASSETS . '/js/bne-scripts'.$min.'.js', array('jquery', 'bootstrap'), BNE_FRAMEWORK_VERSION, true );
	
	// Core BNE Blocks
	wp_enqueue_style( 'bne_framework_blocks', BNE_FRAMEWORK_ASSETS . '/css/bne-blocks-front.css', array('bne_framework'), BNE_FRAMEWORK_VERSION );
	
	// WooCommerce
	if( class_exists( 'woocommerce' ) ) {
		wp_enqueue_style( 'bne_woocommerce', BNE_FRAMEWORK_ASSETS . '/css/bne-woocommerce.css', array('bne_framework'), BNE_FRAMEWORK_VERSION );
	}

	// Enqueue parent theme styles
	wp_enqueue_style( 'bne_theme_parent', get_template_directory_uri() . '/style.css', '', BNE_FRAMEWORK_VERSION );

	// Enqueue child theme styles
	if( is_child_theme() ) {
		wp_enqueue_style( 'bne_theme_child', get_stylesheet_uri(), '', filemtime( get_stylesheet_directory() . '/style.css' ) );
	}

	// Comments reply
	if( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}

	// RTL
	if( is_rtl() ) {
		wp_enqueue_style( 'bne_theme_rtl', get_template_directory_uri() . '/rtl.css', '', BNE_FRAMEWORK_VERSION );
	}

}
add_action( 'wp_enqueue_scripts', 'bne_frontend_scripts' );



/*
 * 	Font Awesome 5 Icon Set
 *
 * 	Sweetness’ implementation of Font Awesome 5. By default, 
 *	we include a build of the Font Awesome 5’s pro version; 
 *	this custom build comes with the solid, regular, light, and brand icon styles.
 *
 *	If you’d like to include a custom build of Font Awesome 5 or for you 
 *	Font Awesome Pro customers, you can use the, bne_fontawesome_setup filter
 *	to do that. 
 *
 *	@since 		v1.6.1
 *	@updated	v2.2.13
 *
*/
function bne_enqueue_fontawesome( $return = false, $type = '' ) {
	$version = '6.0.0';
	$fa = apply_filters( 'bne_fontawesome_setup', array(
		'kit'		=>	'9496e64c1a',
		'css'		=>	( $type == 'css' ? true : false),
		'pseudo'	=>	false,
		'sources'	=>	array(
			'css'		=>	'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css',
			'js'		=>	'',
			'shims'		=>	'',
			'icons'		=>	'',
		),
	) );
	
	// Icon Set (json) Shortcode Generator
	if( 'icons' == $return ) {
		return $fa['sources']['icons'];
	}
		
	// CSS Version
	if( true == $fa['css'] ) {
		wp_enqueue_style( 'fontawesome', esc_url( $fa['sources']['css'] ), '', $version );
	
	// Kit
	} elseif( true == $fa['kit'] ) {
		wp_enqueue_script( 'fontawesome', esc_url( 'https://kit.fontawesome.com/'.$fa['kit'].'.js' ), '', null, true );

	// JS/SVG Version
	} else {
		wp_enqueue_script( 'fontawesome', esc_url( $fa['sources']['js'] ), '', $version, true );
		wp_enqueue_script( 'fontawesome-shims', esc_url( $fa['sources']['shims'] ), '', $version, true );
	}

	// pseudo Support
	if( true == $fa['pseudo'] ) {
		wp_add_inline_script( 'fontawesome', 'FontAwesomeConfig = { searchPseudoElements: true };', 'before' );
	}
	
}



/**
 * 	Filter the HTML script tag of `fontawesome` script to add `defer` attribute.
 *
 * 	@param string $tag    The <script> tag for the enqueued script.
 * 	@param string $handle The script's registered handle.
 *
 * 	@return   	$tag	Filtered HTML script tag.
 *	@since 		v2.2
*/
function bne_add_js_attributes( $tag, $handle ) {
	if( is_admin() ) {
		return $tag;
	}
    if( 'fontawesome' === $handle ) {
		$tag = str_replace( ' src', 'crossorigin="anonymous" src', $tag );
    }

    return $tag;

}
add_filter( 'script_loader_tag', 'bne_add_js_attributes', 10, 2 );