/*
 * 	BNE WordPress Framework JS File
 *
 * 	WARNING: This file is a core part of the
 * 	BNE WordPress Framework. This framework is
 * 	designed around this file NEVER being altered.
 *
 *	Many of the 3rd party scripts (superfish, selectNav, etc)
 *	we utlizize in our templates are minified here
 *	so that there are less file calls from within the <head>.
 *
 * 	@author		Kerry Kline
 * 	@copyright	Copyright (c) Kerry Kline
 * 	@link		http://www.bnecreative.com
 * 	@package	BNE WordPress Framework
 *
 * 	@updated:	Dec 15, 2020
 *
*/


// Listen to tab events to enable outlines (accessibility improvement)
// @url https://jmperezperez.com/outline-focus-ring-a11y/
document.body.addEventListener('keyup', function(e) {
  if (e.which === 9) /* tab */ {
    document.documentElement.classList.add('bne-accessible');
  }
});



jQuery(document).ready(function($){


	// ---------------------------------------------------------
	// 	Bootstrap Integrations
	// ---------------------------------------------------------

    // System buttons
    var system_buttons = $( 'input[type="submit"], input[type="button"], input[type="reset"], .button, button');
	$(system_buttons).each(function() {
		if(!$(this).hasClass("btn")) {
			$(this).addClass('btn btn-default');
		}
	});
	
	// WP Block Buttons
	/*
	$('.wp-block-button__link').each(function() {
		var style = $(this).attr('style');
		var init_text_color = $(this).css('color');
		var init_bg_color = $(this).css('background-color');
		if( init_bg_color === 'rgba(0, 0, 0, 0)' ) { init_bg_color = '#fff'; }
		var init_bg_image = $(this).css('background-image');
		var css_vars = '--text-color:'+init_text_color+';--bg-color:'+init_bg_color+';--bg-image:'+init_bg_image;
		if( style ) {
			style += ';'+css_vars;
		} else {
			style = css_vars;
		}
		$(this).attr( 'style', style);
	});
	*/
	
	// WP Widgets
    $( '.widget_rss ul' ).addClass( 'media-list' );
    $( 'table#wp-calendar' ).addClass( 'table table-striped');


	// ToolTips
	$('[data-toggle="tooltip"]').tooltip();
    
    // Popover
 	$('[data-toggle="popover"]').popover();
 	
 	// Modals
	$('.modal').on('shown.bs.modal', function() {
		
		// Autofocus Search field from menu button
		$(this).find('.search-input').focus();
	
	});



	// ---------------------------------------------------------
	// 	Primary Menu
	// ---------------------------------------------------------

	// Main Menu (superfish)
	$('ul.sf-menu').superfish({ speed: 200 }).addClass('sf-menu-with-fontawesome');


    // Sticky Menu
    if( $('.menu-wrapper').length ) {
	    if( $('body').hasClass('has-sticky-menu') ) {
			$(window).on('scroll', function() {
		        if ( $(window).scrollTop() > $('.menu-wrapper').offset().top + 40 ) {
		            $('#sticky-header').addClass('visible');
		            $('body').addClass('sticky-header-visible');
		        } else {
		            $('#sticky-header').removeClass('visible');
		            $('body').removeClass('sticky-header-visible');
		        }
			});
	    }	    
    }


	// Responsive Nav Button - Toggles Primary Menu
	$('.btn-navbar').on('click', function(e) {

		// Toggle Nav Btn Class
		$('.btn-navbar').toggleClass('menu-toggle-open');

		// Toggle Nav Btn Icon
		if( $('.btn-navbar svg').hasClass('fa-bars') ) {
			$('.btn-navbar > svg.fa-bars').attr('data-icon','times');
		} else if( $('.btn-navbar svg').hasClass('fa-times') ) {
			$('.btn-navbar > svg.fa-times').attr('data-icon','bars');
		}

		// Toggle Nav Class
		$('body').toggleClass('primary-menu-open');

		// Graphic Nav Option
		if( $('body').hasClass('bne-graphical-mobile-nav') ) {
			$('.bne-graphical-mobile-nav #access, .bne-graphical-mobile-nav .header-sidebar-widgets').slideToggle();

		// Side Nav Option
		} else if( $('body').hasClass('bne-side-mobile-nav') ) {
			$('html').toggleClass('lock-scrolling');
		}

		// Prevent a click to top response.
		e.preventDefault();
	});
	
	// Transparent header with Full Width Menu Above/Below
	var headerHeight = $('#header-wrapper').innerHeight();
	var menuHeight = $('.menu-wrapper').innerHeight();
	if( $(window).outerWidth() > 768 ) {
		$('.header-transparent.header-menu-below_header .menu-wrapper').css('top' , headerHeight+'px');
		$('.header-transparent.header-menu-above_header #header-wrapper').css('top' , menuHeight+'px');
	}

	// ---------------------------------------------------------
	// 	No-click
	// ---------------------------------------------------------

	// Within Nav
	$('ul.sf-menu .no-click, .no-click').find('a:first').on('click', function() {
		return false;
	});

	// General Buttons / Links
	$('a.no-click').on('click', function() {
		return false;
	});




	// ---------------------------------------------------------
	// 	Magnific Popup
	// ---------------------------------------------------------

	// Initiate our class with Magnific
	$('a.bne-lightbox, .bne-lightbox a').magnificPopup();

	// WP Gallery
	$('.gallery, .wp-block-gallery').each(function() {
		$(this).addClass('bne-gallery clearfix');
		$(this).find('a').magnificPopup({
			gallery: { 
				enabled: true
			}
 		});
	});


	// Global Defaults
    $.extend(true, $.magnificPopup.defaults, {
	    removalDelay: 160,
	    mainClass: 'bne-mfp',
        tLoading: '<div class="bne-loader"><i class="bne-fa fa fa-spinner fa-spin"></i></div>',
		callbacks: {
			// Adjust the type based on the src asset
			elementParse: function(item) {
				// Image
				if( item.src.match(/\.(jpe?g|png|bmp|gif|tiff?)$/i) ) {
					item.type = 'image';
				// Inline
				} else if( item.src.match(/^#/) ) {
					item.type = 'inline';
				// Video/iframe
				} else {
					item.type = 'iframe';
				}
			}
		},
		image: {
			cursor: null,
			titleSrc: function(item) {
				// Alt from Image
				alt = item.el.find('img').attr('alt');
				if( alt ) {
					return alt;
				// Alt from link
				} else {
					return item.el.attr('alt');
				}
			}
		},
		iframe: {
			markup: '<div class="mfp-iframe-scaler">'+
            	'<div class="mfp-close"></div>'+
				'<iframe class="mfp-iframe" frameborder="0" allowfullscreen style="visibility:hidden;" onload="this.style.visibility=\'visible\';"></iframe>'+
				'</div>', 
		}
		
    });


	

	// ---------------------------------------------------------
	// 	BNE Share Post Buttons
	// ---------------------------------------------------------

	$('.bne-share .btn-share.popup').on('click', function() {
        if(!window.open( $(this).attr('href'), '', 'height=320, width=640, toolbar=no, menubar=no, scrollbars=no, resizable=no, location=no, directories=no, status=no' ) ) {
            document.location.href = $(this).attr("href")
        }
        return false;
    });
    
    
    
	// ---------------------------------------------------------
	// 	Scroll to Top Button
	// ---------------------------------------------------------

	// When clicked, go to top of document
    $('.scrollToTop, .bne-scroll-to-top').on('click', function() {
        $('html, body').animate({scrollTop : 0},800);
        return false;
    });

	// Fade in Scroll To Top button
	$(window).on('scroll', function() {
		if ($(this).scrollTop() > 200) {
			$('.bne-scroll-to-top').fadeIn();
		} else {
			$('.bne-scroll-to-top').fadeOut();
		}
	});


	// ---------------------------------------------------------
	// 	BNE Blocks
	// ---------------------------------------------------------
	
	// Toggle
	// Finds all block toggles that are immediate siblings and wraps them into an accordion.
	// @note https://www.timjensen.us/wrap-sibling-groups-using-jquery/
	$(':not(.wp-block-bne-toggle) + .wp-block-bne-toggle, * > .wp-block-bne-toggle:first-of-type').each(function() {
	   $(this).
	       nextUntil(':not(.wp-block-bne-toggle)').
	       addBack().
	       wrapAll('<div class="wp-block-bne-accordion accordion" id="accordion-'+Math.floor((Math.random() * 1000) + 1)+'"/>');
	 });
 	$('.wp-block-bne-accordion').each(function() {
		accordionID = $(this).attr('id');
		$(this).
			find('.wp-block-bne-toggle .toggle-inner').
			attr('data-parent', '#'+accordionID);
	});

     
     
     
	// ---------------------------------------------------------
	// 	Scroll to individual links within the page smoothly.
	// 	EX: <a href="#faq16" class="scroll">Faq Question 16</a>
	// 	(Add div id="XXX"> for the link above to work)
	// ---------------------------------------------------------

	$('a.scroll, .scroll a').on('click', function() {
		$('html, body').animate({
			scrollTop: $(this.hash).offset().top
		}, 1000);
		return false;
	});

}); // End Dom