/*
 * 	Sweetness Customizer JS
 *
 * 	@author		Kerry Kline
 * 	@copyright	Copyright (c) Kerry Kline
 * 	@link		http://www.bnecreative.com
 *
 *	@since:		v2.2.6
 * 	@updated:	July 11, 2020
 *
*/


// General
wp.customize( 'content_width', function( value ) {
	value.bind( function( newval ) {
		document.documentElement.style.setProperty('--theme-content-width', newval);

	} );
} );


// Main Menu Location
wp.customize( 'menu_location', function( value ) {
	value.bind( function( newval ) {

		// Remove previous class
		jQuery('#access.header-menu').removeClass (function (index, className) {
			return (className.match (/(^|\s)menu-location-\S+/g) || []).join(' ');
		});
		
		// Add new class
		jQuery('.menu-wrapper #access.header-menu').addClass('menu-location-'+newval );

		// Move to new location
		if( newval === 'default' ) {
			jQuery('.menu-wrapper').insertAfter( '#header-wrapper .header-content' );
		}
		else if( newval === 'below_header') {
			jQuery('.menu-wrapper').insertAfter( '#header-wrapper' );
		}
		else if( newval === 'above_header') {
			jQuery('.menu-wrapper').insertBefore( '#header-wrapper' );
		}
		else if( newval === 'header_addon') {
			jQuery('.menu-wrapper').insertAfter( '#header-wrapper .header-addon' );
		}
	
	} );
} );


// Menu Center
wp.customize( 'menu_center', function( value ) {
	value.bind( function( newval ) {
		jQuery('body').toggleClass( 'header-menu-center' );
	} );
} );


// Footer Message
wp.customize( 'footer_copytext', function( value ) {
	value.bind( function( newval ) {
		var newval = newval.replace('{icon_copyright}', '<i class="bne-fa fa fa-copyright"></i>');
		var newval = newval.replace('{year}', bne_wp_customizer_vars.dynamicVars.year );
		var newval = newval.replace('{site_title}', bne_wp_customizer_vars.dynamicVars.siteName );
		jQuery('.copyright-inner').html( newval );
	} );
} );