/*
 * 	BNE Block: Visibility
 *	Adds visibility options to existing blocks under Advanced
 *
 * 	@author		Kerry Kline
 * 	@copyright	Copyright (c) Kerry Kline
 * 	@link		http://www.bnecreative.com
 *
 * 	@updated:	July 5, 2021
 *
*/


( function( blocks, components, i18n, element, editor ) {

	/*
	 *	ClassNames
	 *	Copyright (c) 2018 Jed Watson.
	 *	Licensed under the MIT License (MIT), see
	 *	http://jedwatson.github.io/classnames
	 *
	*/
	var hasOwn={}.hasOwnProperty;
	function classNames(){var classes=[];for(var i=0;i<arguments.length;i++){var arg=arguments[i];if(!arg)continue;var argType=typeof arg;if(argType==='string'||argType==='number'){classes.push(arg)}else if(Array.isArray(arg)){if(arg.length){var inner=classNames.apply(null,arg);if(inner){classes.push(inner)}}}else if(argType==='object'){if(arg.toString!==Object.prototype.toString){classes.push(arg.toString())}else{for(var key in arg){if(hasOwn.call(arg,key)&&arg[key]){classes.push(key)}}}}}return classes.join(' ')}if(typeof module!=='undefined'&&module.exports){classNames.default=classNames;module.exports=classNames}else if(typeof define==='function'&&typeof define.amd==='object'&&define.amd){define('classnames',[],function(){return classNames})}else{window.classNames=classNames}


	
	// Block blacklist
	var blacklistedBlocks = [
		'bne/clear',
		'bne/map',
		'bne/modal',
		'bne/posts',
		'gravityforms/form'
	];


	/*
	 * 	Add custom attribute for mobile visibility.
	 *
	 * 	@param {Object} settings Settings for the block.
	 * 	@return {Object} settings Modified settings.
	 *
	*/
	function addCustomAttributes( settings, name ) {
		
		// Not available for these blocks
		// May throw an error with unknown attributes
		for (i = 0; i < blacklistedBlocks.length; i++) {
			if( name == blacklistedBlocks[i] ) {
				return settings;
			}
		} 
		
	    if( settings.attributes ) {
	
	        settings.attributes.hideOnMobile = {
	            type: 'boolean',
	            default: ''
	        };
	
	        settings.attributes.hideOnTablet = {
	            type: 'boolean',
	            default: ''
	        };
	
	        settings.attributes.hideOnStandard = {
	            type: 'boolean',
	            default: ''
	        };
	
	    }
	    
	    return settings;
	
	}
	wp.hooks.addFilter( 
		'blocks.registerBlockType', 
		'bne/visibility', 
		addCustomAttributes 
	);




	/*
	 * 	Add mobile visibility controls on Advanced Block Panel.
	 *
	 * 	@param {function} BlockEdit Block edit component.
	 * 	@return {function} BlockEdit Modified block edit component.
	 *
	*/
	var el = wp.element.createElement;
	var __ = wp.i18n.__;
	var Fragment = wp.element.Fragment;
	var ToggleControl = wp.components.ToggleControl;
	var Button = wp.components.Button;
	var Tooltip = wp.components.Tooltip;
	var Dashicon = wp.components.Dashicon;
	var InspectorAdvancedControls = wp.compose.createHigherOrderComponent( function( BlockEdit ) {
	    
	    return function( props ) {
			
			// Not available for these blocks
			for (i = 0; i < blacklistedBlocks.length; i++) {
				if ( blacklistedBlocks[i] === props.name ) {
					return el( BlockEdit, props );
				}
			} 

			// Set vars
			const {
				attributes,
				setAttributes,
			} = props;
	
			const {
				className,
				hideOnMobile,
				hideOnTablet,
				hideOnStandard,
			} = attributes;
	
	        return el( Fragment, {},
				
				el( BlockEdit, props ),
				
				// visual aid when a visibility class is enabled on a block
				( attributes.hideOnMobile || attributes.hideOnTablet || attributes.hideOnStandard )  &&
					el( Tooltip, {
							text: __( 'Visibility Control Active', 'bne' ),
						},
						el( Button, {
								className: 'bne-block-helper-icon',
								onClick: function() {
									props.setAttributes( {
										mediaPosition: attributes.mediaPosition == "top" ? 'bottom' : 'top',
										})
									},
							},
							el( Dashicon, { icon: 'visibility' } )
						)
					),
	            
	            // options
	            el(
	                wp.blockEditor.InspectorAdvancedControls,
	                {},
	                el( 'p', {}, __('Visibility Options', 'bne' ) ),
					el( ToggleControl, {
							label: __( 'Hide on Mobile', 'bne' ),
							checked: !!attributes.hideOnMobile,
							onChange: function( newHideOnMobile ) {
								props.setAttributes( { hideOnMobile: newHideOnMobile } );
							}
						} 
					),
					el( ToggleControl, {
							label: __( 'Hide on Tablet', 'bne' ),
							checked: !!attributes.hideOnTablet,
							onChange: function( newHideOnTablet ) {
								props.setAttributes( { hideOnTablet: newHideOnTablet } );
							}
						} 
					),
					el( ToggleControl, {
							label: __( 'Hide on Standard', 'bne' ),
							checked: !!attributes.hideOnStandard,
							onChange: function( newHideOnStandard ) {
								props.setAttributes( { hideOnStandard: newHideOnStandard } );
							}
						} 
					)
	            )
	        );
	    };
	}, 'InspectorAdvancedControls' );
	wp.hooks.addFilter( 
		'editor.BlockEdit', 
		'bne/visibility', 
		InspectorAdvancedControls 
	);



	/*
	 * 	Add custom element class in save element.
	 *
	 * 	@param {Object} extraProps     Block element.
	 * 	@param {Object} blockType      Blocks object.
	 * 	@param {Object} attributes     Blocks attributes.
	 * 	@return {Object} extraProps Modified block element.
	 *
	*/

	// Moved to add_filter(render_block, bne_render_block_visibility)

	/*
	function applyExtraClass( extraProps, blockType, attributes ) {
		console.log(attributes);
		var { hideOnMobile, hideOnTablet, hideOnStandard } = attributes;
		
		if ( typeof attributes.hideOnMobile !== 'undefined' && attributes.hideOnMobile ) {
			extraProps.className = classNames( extraProps.className, 'hide_on_mobile' );
		}
		if ( typeof attributes.hideOnTablet !== 'undefined' && attributes.hideOnTablet ) {
			extraProps.className = classNames( extraProps.className, 'hide_on_tablet' );
		}
		if ( typeof attributes.hideOnStandard !== 'undefined' && attributes.hideOnStandard ) {
			extraProps.className = classNames( extraProps.className, 'hide_on_standard' );
		}
		
		return extraProps;
	}
	wp.hooks.addFilter( 
		'blocks.getSaveContent.extraProps', 
		'bne/visibility', 
		applyExtraClass 
	);
	*/
	

	
} )(
	window.wp.blocks,
	window.wp.components,
	window.wp.i18n,
	window.wp.element,
	window.wp.editor,
);