/*
 * 	BNE Block Toggle
 *
 * 	@author		Kerry Kline
 * 	@copyright	Copyright (c) Kerry Kline
 * 	@link		http://www.bnecreative.com
 *
 * 	@updated:	April 17, 2021
 *
*/


( function( blocks, components, i18n, element, editor ) {
	var registerBlockType = wp.blocks.registerBlockType;
	var el = wp.element.createElement;
	var __ = wp.i18n.__;
	var InspectorControls = wp.blockEditor.InspectorControls;
	var ColorPalette = wp.blockEditor.ColorPalette;
	var InnerBlocks = wp.blockEditor.InnerBlocks;
	var RichText = wp.blockEditor.RichText;
	var PanelBody = wp.components.PanelBody;
	var TextControl = wp.components.TextControl;
	var SelectControl = wp.components.SelectControl;
	var ToggleControl = wp.components.ToggleControl;
	var Button = wp.components.Button;
	var Dashicon = wp.components.Dashicon;
	var Tooltip = wp.components.Tooltip;
	
	//console.log(wp.editor);

	// ========================== //
	// Register Block
	// ========================== //
	registerBlockType( 'bne/toggle', {
		title: __( 'Toggles', 'bne' ),
		description: __( 'Hide content behind a collapsable toggle. Use multiple toggles to create an accordion.', 'bne' ),
		icon: 'list-view',
		category: 'bne-blocks',
		keywords: [ __( 'accordion', 'bne' ), __( 'faq', 'bne' ) ],
		attributes: {
			toggleID: {
				type: 'string',
				default: ''
			},
			toggleHeading: {
				type: 'array',
				source: 'children',
				selector: 'span'
			},
			toggleBorder: {
				type: 'boolean',
				default: 1				
			},
			toggleOpen: {
				type: 'boolean',
				default: 0				
			},
			toggleShadow: {
				type: 'string',
				default: 'shadow-sm'				
			},
			toggleHeadingBackgroundColor: {
				type: 'string'
			},
			toggleHeadingTextColor: {
				type: 'string'
			}
		},
		
		
		// ========================== //
		// Admin Edit
		// ========================== //
		edit: function( props ) {
			var attributes = props.attributes;
			//console.log(attributes);
			
			// Toggle to open/close
			var expandToggle = function expandToggle(e) {
				e.preventDefault();
			 	jQuery('#toggle-id-'+attributes.toggleID).toggle();
			 	jQuery('[data-target="#toggle-id-'+attributes.toggleID+'"').toggleClass('active');
			};

			// Set a unique ID
			if( ! attributes.toggleID ) {
				props.setAttributes( { toggleID: Math.floor((Math.random() * 1000) + 1).toString() } );
			}
			

			// Toggle Classes
			var toggleClasses =
				( attributes.toggleBorder 
					? ' has-border' 
					: '' 
				) +
				' '+attributes.toggleShadow
			;
  		
  			return [

				// Panel Controls
				el( InspectorControls, {},

 					// General Panel
 					el( PanelBody, {
							title: __( 'Toggle Settings', 'bne' ),
							initialOpen: true,
						},
						el( ToggleControl, {
								label: __( 'Display Border', 'bne' ),
								checked: !!attributes.toggleBorder,
								onChange: function( newToggleBorder ) {
									props.setAttributes( { toggleBorder: newToggleBorder } );
								}
							} 
						),
						el( ToggleControl, {
								label: __( 'Open by default', 'bne' ),
								checked: !!attributes.toggleOpen,
								onChange: function( newToggleOpen ) {
									props.setAttributes( { toggleOpen: newToggleOpen } );
								}
							} 
						),
						el( SelectControl, {
								value: attributes.toggleShadow,
								label: __('Shadow', 'bne' ),
								onChange: function( newToggleShadow ) {
									props.setAttributes( { toggleShadow: newToggleShadow } );
								},
								options: [
									{ value: 'shadow-none', label: __( 'No Shadow', 'bne' ) },
									{ value: 'shadow-sm', label: __( 'Small Shadow', 'bne' ) },
									{ value: 'shadow', label: __( 'Medium Shadow', 'bne' ) },
									{ value: 'shadow-lg', label: __( 'Large Shadow', 'bne' ) },
								]
							} 
						),
						el( TextControl, {
								label: __('Heading', 'bne' ),
								value: attributes.toggleHeading,
								onChange: function( newToggleHeading ) {
									props.setAttributes( { toggleHeading: newToggleHeading } );
								},
								placeholder: __('Add a toggle heading...', 'bne' )
							} 
						),
						el('p', {}, __( 'Heading Background Color', 'bne' ) ),
						el( ColorPalette, {
								value: attributes.toggleHeadingBackgroundColor,
								onChange: function( newToggleHeadingBackgroundColor ) {
									props.setAttributes( { toggleHeadingBackgroundColor: newToggleHeadingBackgroundColor } );
								},
							},
						),
						el( 'br' ),
						el( SelectControl, {
								value: attributes.toggleHeadingTextColor,
								label: __('Heading Text Color', 'bne' ),
								onChange: function( newToggleHeadingTextColor ) {
									props.setAttributes( { toggleHeadingTextColor: newToggleHeadingTextColor } );
								},
								options: [
									{ value: 'default', label: __( 'Default text color', 'bne' ) },
									{ value: 'light', label: __( 'Force light text color', 'bne' ) },
									{ value: 'dark', label: __( 'Force dark text color', 'bne' ) },
								]
							} 
						),
						el( TextControl, {
								label: __('Unique Toggle ID', 'bne' ),
								value: attributes.toggleID,
								onChange: function( newToggleID ) {
									props.setAttributes( { toggleID: newToggleID } );
								},
								help: __('Make sure this is unique for each toggle on this page.', 'bne')
							} 
						)
					)
				),




				// Editor
				// ========================== //
				el( 'div', {
						className: props.className + ' card mb-3 '+toggleClasses, 
						style: {} 
					},
					el( 'div', {
							className: 'toggle-header card-header collapsed text-'+attributes.toggleHeadingTextColor,
							'data-toggle': 'collapse',
							'data-target': '#toggle-id-'+attributes.toggleID,
							'aria-expanded': 'false',
							'aria-controls': 'toggle-id-'+attributes.toggleID,
							
							style: {
								backgroundColor: ( attributes.toggleHeadingBackgroundColor ? attributes.toggleHeadingBackgroundColor : 'transparent' )
							},
						},
						el( Tooltip, {
								text: __( 'Open and Edit this toggle', 'bne' ),
							},
							el( Button, {
									focus: true,
									isTertiary: true,
									onClick: expandToggle,
									isSmall: true,
									style: { 
										float: 'right',
										background: 'white',
										boxShadow: '0px 0px 3px rgba(0,0,0,.2)',
										color: '#666',
										height: 'auto'
									}
								},
								el( Dashicon,{ icon: 'edit'}),
							)
						),
						el( 'i', {
							className: 'bne-fa fas fa-caret-right',
							onClick: expandToggle,
						} ),
						el( RichText, {
							tagName: 'span',
							placeholder: __('Add a toggle heading...', 'bne' ),
							multiline: false,
							formattingControls: [ 'bold', 'italic'],
							keepPlaceholderOnFocus: true,
							value: attributes.toggleHeading,
							onChange: function( newToggleHeading ) {
								props.setAttributes( { toggleHeading: newToggleHeading } );
							},
						} )
					),
					
					
					// Content
					el( 'div', {
							className: 'toggle-inner collapse',
							'id': 'toggle-id-'+attributes.toggleID,
							style: { display:'none' }
						},
						el( 'div', {
								className: 'toggle-body card-body',
							},
						
							// Workaround logic for this bug https://github.com/WordPress/gutenberg/issues/9897
							// Happens when applying a style option with a block that has innerblocks
							// When fixed, remove the condition
							( 'undefined' !== typeof props.insertBlocksAfter ) 
								? (	el( InnerBlocks, {
											template: [
												[ 'core/paragraph']
											],
											templateLock: false,
											templateInsertUpdatesSelection: false
										} 
									) 
								) : (
									el( 'div' )
								)
						) // End div.toggle-body
					
					) // End div.toggle-inner
				) // End div.bne-toggle
			
			]; // END return
		}, // END edit
	
		
		// ========================== //
		// Save
		// ========================== //
		save: function (props) {
			var attributes = props.attributes;
			//console.log(attributes);
			
			// Toggle Classes
			var toggleClasses =
				( attributes.toggleBorder 
					? ' has-border' 
					: '' 
				) +
				' '+attributes.toggleShadow
			;
			
			// Save frontend block markup
			return (
				el( 'div', {
						className: 'bne-toggle card mb-3 '+toggleClasses, 
						style: {} 
					},
					// Heading
					el( 'div', {
							className: 'toggle-header card-header'+( ( attributes.toggleOpen == 1 ) ? '' : ' collapsed' )+' text-'+attributes.toggleHeadingTextColor,
							'data-toggle': 'collapse',
							'data-target': '#toggle-id-'+attributes.toggleID,
							'aria-expanded': ( ( attributes.toggleOpen == 1 ) ? 'true' : 'false' ),
							'aria-controls': 'toggle-id-'+attributes.toggleID,
							style: {
								backgroundColor: ( attributes.toggleHeadingBackgroundColor ? attributes.toggleHeadingBackgroundColor : 'transparent' )
							}
						},
						el( 'i', {
							className: 'bne-fa fas fa-caret-right',
						} ),
						el( 'span', {}, attributes.toggleHeading )
					),
					
					// Content
					el( 'div', {
							className: 'toggle-inner collapse'+ ( ( attributes.toggleOpen == 1 ) ? ' show' : '' ),
							'id': 'toggle-id-'+attributes.toggleID,
						},
						el( 'div', {
								className: 'toggle-body card-body',
							},
							el( InnerBlocks.Content, {} ),
						) // End div.toggle-body
					
					) // End div.toggle-inner
				) // End div.bne-toggle
			
			) // End return
		}, // End save



		// ========================== //
		// DEPRECATED BLOCK
		// ========================== //
		deprecated: [{
			// @depreciated @v2.2.3
			// Original block
			// Replaced toggleID to a string and add visible TextControl
			attributes:{toggleID:{type:'number'},toggleHeading:{type:'array',source:'children',selector:'span'},toggleBorder:{type:'boolean',default:1},toggleOpen:{type:'boolean',default:0},toggleShadow:{type:'string',default:'shadow-sm'},toggleHeadingBackgroundColor:{type:'string'},toggleHeadingTextColor:{type:'string'}},save:function(props){var attributes=props.attributes;var toggleClasses=(attributes.toggleBorder?' has-border':'')+' '+attributes.toggleShadow;return(el('div',{className:'bne-toggle card mb-3 '+toggleClasses,style:{}},el('div',{className:'toggle-header card-header'+((attributes.toggleOpen==1)?'':' collapsed')+' text-'+attributes.toggleHeadingTextColor,'data-toggle':'collapse','data-target':'#toggle-id-'+attributes.toggleID,'aria-expanded':((attributes.toggleOpen==1)?'true':'false'),'aria-controls':'toggle-id-'+attributes.toggleID,style:{backgroundColor:(attributes.toggleHeadingBackgroundColor?attributes.toggleHeadingBackgroundColor:'transparent')}},el('i',{className:'bne-fa fas fa-caret-right',}),el('span',{},attributes.toggleHeading)),el('div',{className:'toggle-inner collapse'+((attributes.toggleOpen==1)?' show':''),'id':'toggle-id-'+attributes.toggleID,},el('div',{className:'toggle-body card-body',},el(InnerBlocks.Content,{}),))))}
		}] // END DEPRECATED


	} ); // End registerBlockType


} )(
	window.wp.blocks,
	window.wp.components,
	window.wp.i18n,
	window.wp.element,
	window.wp.editor,
);