/*
 * 	BNE Block Shape Divider
 *
 * 	@author		Kerry Kline
 * 	@copyright	Copyright (c) Kerry Kline
 * 	@link		http://www.bnecreative.com
 *
 * 	@updated:	January 18, 2021
 *
*/


( function( blocks, components, i18n, element, editor ) {
	var registerBlockType = wp.blocks.registerBlockType;
	var el = wp.element.createElement;
	var __ = wp.i18n.__;
	var InspectorControls = wp.blockEditor.InspectorControls;
	var PanelColorSettings = wp.blockEditor.PanelColorSettings;
	var PanelBody = wp.components.PanelBody;
	var RangeControl = wp.components.RangeControl;
	var ToggleControl = wp.components.ToggleControl;

	var SVG = wp.components.SVG;
	var Path = wp.components.Path;
	var G = wp.components.G;
	var Polygon = wp.components.Polygon;

	var blockIcon = 
		el( 'svg', { className: 'components-bne-svg', width: '24', height: '24', focusable: 'false', 'viewBox': '0 0 24 24', xmlns: 'http://www.w3.org/2000/svg' },
			el( 'g', { 'fill-rule': 'evenodd' }, 
				el( 'path', { d: "m16.0833333 7h-14.16666663c-1.05416667 0-1.91666667.9-1.91666667 2v14c0 1.1.8625 2 1.91666667 2h14.16666663c1.0541667 0 1.9166667-.9 1.9166667-2v-14c0-1.1-.8625-2-1.9166667-2zm-.0833333 15h-14v-13h14zm11-21.5 1.5.5z", transform: 'translate(3 -4)' } ),
				el( 'path', { d: "m19 9.28913506v8.71086494h-14v-4.9820783c1.16477843 2.4188468 2.91468872 3.6687848 4.98770599 3.1602578 2.14365841-.3635546 3.10828471-1.45152 5.01375881-4.1781795 1.0519106-1.5163931 2.4888112-2.61155466 3.9985352-2.71086494z" } )
			)
		)	
	;
	
	/* 
	 * SVG Shapes
	 * Returns the approprate shape based on the style selection
	 * which comes from the attributes.className
	*/
	function getShapes(style) {
		if( !style ) {
			return;
		}
		
		if( style.indexOf('is-style-wavey') !== -1 ) {
			return (
				el( SVG, { 
						className: 'bne-divider-wavy', 
						xmlns: "http://www.w3.org/2000/svg", 
						width: '100%', 
						height: '100%', 
						viewBox: '0 0 100 10', 
						preserveAspectRatio: 'none' 
					},
					el( Path, { 
						d: "m42.19.65c2.26-.25 5.15.04 7.55.53 2.36.49 7.09 2.35 10.05 3.57 7.58 3.22 13.37 4.45 19.26 4.97 2.36.21 4.87.35 10.34-.25s10.62-2.56 10.62-2.56v-6.91h-100.01v3.03s7.2 3.26 15.84 3.05c3.92-.07 9.28-.67 13.4-2.24 2.12-.81 5.22-1.82 7.97-2.42 2.72-.63 3.95-.67 4.98-.77z",
						fillRule: 'evenodd',
						transform: 'matrix(1 0 0 -1 0 10)'
					} )
				)
			);
		} else if( style.indexOf('is-style-hills') !== -1 ) {
			return (
				el( SVG, { 
						className: 'bne-divider-hills', 
						xmlns: "http://www.w3.org/2000/svg", 
						width: '100%', 
						height: '100%', 
						viewBox: '0 0 1920 105', 
						preserveAspectRatio: 'none' 
					},
					el( G, { 
							fillRule: 'evenodd', 
							transform: 'matrix(1 0 0 -1 0 105)'
						},
						el( Path, { 
							d: "m1920 14.8827052c-116.23325 0-224.05162 88.3906828-395.09265 88.3906828-160.92196 0-254.53172-83.4344997-444.90735-83.4344997-154.297581 0-240.095847 39.6344097-367.66819 39.6344097-154.121863 0-198.902329-36.1223133-349.458242-36.1223133-144.878137 0-241.175717 80.8685493-362.873568 80.8685493 0-34.0793243 0-68.1494291 0-102.219534h1920z"
						} ),
						el( Path, { 
							d: "m1920 14.6612844c-116.11434 0-223.9659 88.8291396-395.06196 88.8291396-160.92415 0-254.54487-83.7874573-444.93804-83.7874573-154.317311 0-240.088941 39.8974838-367.565152 39.8974838-154.034172 0-198.792715-36.4840402-349.164477-36.4840402-144.965828 0-241.283139 81.1250467-363.270371 81.1250467 0-34.7474052 0-69.4948104 0-104.241457h1920z"
						} )
					)
				)
			);
		} else if( style.indexOf('is-style-waves') !== -1 ) {
			return (
				el( SVG, { 
						className: 'bne-divider-waves', 
						xmlns: "http://www.w3.org/2000/svg", 
						viewBox: '0 0 1000 300', 
						preserveAspectRatio: 'none' 
					},
					el( Path, { 
						d: "M 1000 299 l 2 -279 c -155 -36 -310 135 -415 164 c -102.64 28.35 -149 -32 -232 -31 c -80 1 -142 53 -229 80 c -65.54 20.34 -101 15 -126 11.61 v 54.39 z"
					} ),
					el( Path, { 
						d: "M 1000 286 l 2 -252 c -157 -43 -302 144 -405 178 c -101.11 33.38 -159 -47 -242 -46 c -80 1 -145.09 54.07 -229 87 c -65.21 25.59 -104.07 16.72 -126 10.61 v 22.39 z"
					} ),
					el( Path, { 
						d: "M 1000 300 l 1 -230.29 c -217 -12.71 -300.47 129.15 -404 156.29 c -103 27 -174 -30 -257 -29 c -80 1 -130.09 37.07 -214 70 c -61.23 24 -108 15.61 -126 10.61 v 22.39 z"
					} )
				)
			);
		} else if( style.indexOf('is-style-angled') !== -1 ) {
			return (
				el( SVG, { 
						className: 'bne-divider-angled', 
						xmlns: "http://www.w3.org/2000/svg", 
						viewBox: '0 0 100 100', 
						preserveAspectRatio: 'none' 
					},
					el( 'polygon', { 
						points: "0,100 100,0 100,100"
					} )
				)
			);
		} else if( style.indexOf('is-style-sloped') !== -1 ) {
			return (
				el( SVG, { 
						className: 'bne-divider-sloped', 
						xmlns: "http://www.w3.org/2000/svg", 
						width: '100%', 
						height: '100%', 
						viewBox: '0 0 100 100', 
						preserveAspectRatio: 'none' 
					},
					el( Path, { 
						d: "M0 100 C 20 0 50 0 100 100 Z",
					} )
				)
			);
		} else if( style.indexOf('is-style-rounded') !== -1 ) {
			return (
				el( SVG, { 
						className: 'bne-divider-rounded', 
						xmlns: "http://www.w3.org/2000/svg", 
						width: '100%', 
						height: '100%', 
						viewBox: '0 0 240 24', 
						enableBackground: 'new 0 0 240 24',
						preserveAspectRatio: 'none'
					},
					el( Path, { 
						d: "M119.849,0C47.861,0,0,24,0,24h240C240,24,191.855,0.021,119.849,0z",
					} )
				)
			);
		} else if( style.indexOf('is-style-triangle') !== -1 ) {
			return (
				el( SVG, { 
						className: 'bne-divider-triangle', 
						xmlns: "http://www.w3.org/2000/svg", 
						width: '100%', 
						height: '100%', 
						viewBox: '0 0 100 100', 
						preserveAspectRatio: 'none'
					},
					el( Path, { 
						d: "m0 0 50 100 50-100z",
						fillRule: 'evenodd',
						transform: 'matrix(1 0 0 -1 0 100)'
					} )
				)
			);
		} else if( style.indexOf('is-style-pointed') !== -1 ) {
			return (
				el( SVG, { 
						className: 'bne-divider-pointed', 
						xmlns: "http://www.w3.org/2000/svg", 
						viewBox: '0 0 1000 100', 
						preserveAspectRatio: 'none'
					},
					el( Path, { 
						d: "M737.9,94.7L0,0v100h1000V0L737.9,94.7z",
					} )
				)
			);
		} else if( style.indexOf('is-style-clouds') !== -1 ) {
			return (
				el( SVG, { 
						className: 'bne-divider-clouds', 
						xmlns: "http://www.w3.org/2000/svg", 
						width: '100%', 
						height: '100%', 
						viewBox: '0 0 283.5 27.8', 
						preserveAspectRatio: 'none'
					},
					el( Path, { 
						d: "M265.8 3.5c-10.9 0-15.9 6.2-15.9 6.2s-3.6-3.5-9.2-.9c-9.1 4.1-4.4 13.4-4.4 13.4s-1.2.2-1.9.9c-.6.7-.5 1.9-.5 1.9s-1-.5-2.3-.2c-1.3.3-1.6 1.4-1.6 1.4s.4-3.4-1.5-5c-3.9-3.4-8.3-.2-8.3-.2s-.6-.7-.9-.9c-.4-.2-1.2-.2-1.2-.2s-4.4-3.6-11.5-2.6-10.4 7.9-10.4 7.9-.5-3.3-3.9-4.9c-4.8-2.4-7.4 0-7.4 0s2.4-4.1-1.9-6.4-6.2 1.2-6.2 1.2-.9-.5-2.1-.5-2.3 1.1-2.3 1.1.1-.7-1.1-1.1c-1.2-.4-2 0-2 0s3.6-6.8-3.5-8.9c-6-1.8-7.9 2.6-8.4 4-.1-.3-.4-.7-.9-1.1-1-.7-1.3-.5-1.3-.5s1-4-1.7-5.2c-2.7-1.2-4.2 1.1-4.2 1.1s-3.1-1-5.7 1.4-2.1 5.5-2.1 5.5-.9 0-2.1.7-1.4 1.7-1.4 1.7-1.7-1.2-4.3-1.2c-2.6 0-4.5 1.2-4.5 1.2s-.7-1.5-2.8-2.4c-2.1-.9-4 0-4 0s2.6-5.9-4.7-9c-7.3-3.1-12.6 3.3-12.6 3.3s-.9 0-1.9.2c-.9.2-1.5.9-1.5.9S99.4 3 94.9 3.9c-4.5.9-5.7 5.7-5.7 5.7s-2.8-5-12.3-3.9-11.1 6-11.1 6-1.2-1.4-4-.7c-.8.2-1.3.5-1.8.9-.9-2.1-2.7-4.9-6.2-4.4-3.2.4-4 2.2-4 2.2s-.5-.7-1.2-.7h-1.4s-.5-.9-1.7-1.4-2.4 0-2.4 0-2.4-1.2-4.7 0-3.1 4.1-3.1 4.1-1.7-1.4-3.6-.7c-1.9.7-1.9 2.8-1.9 2.8s-.5-.5-1.7-.2c-1.2.2-1.4.7-1.4.7s-.7-2.3-2.8-2.8c-2.1-.5-4.3.2-4.3.2s-1.7-5-11.1-6c-3.8-.4-6.6.2-8.5 1v21.2h283.5V11.1c-.9.2-1.6.4-1.6.4s-5.2-8-16.1-8z",
					} )
				)
			);
		} else if( style.indexOf('is-style-brush') !== -1 ) {
			return (
				el( SVG, { 
						className: 'bne-divider-brush', 
						xmlns: "http://www.w3.org/2000/svg", 
						width: '100%', 
						height: '100%', 
						viewBox: '0 0 283.5 27.8', 
						preserveAspectRatio: 'none'
					},
					el( Path, { 
						d: "M283.5,9.7c0,0-7.3,4.3-14,4.6c-6.8,0.3-12.6,0-20.9-1.5c-11.3-2-33.1-10.1-44.7-5.7	s-12.1,4.6-18,7.4c-6.6,3.2-20,9.6-36.6,9.3C131.6,23.5,99.5,7.2,86.3,8c-1.4,0.1-6.6,0.8-10.5,2c-3.8,1.2-9.4,3.8-17,4.7	c-3.2,0.4-8.3,1.1-14.2,0.9c-1.5-0.1-6.3-0.4-12-1.6c-5.7-1.2-11-3.1-15.8-3.7C6.5,9.2,0,10.8,0,10.8V0h283.5V9.7z M260.8,11.3	c-0.7-1-2-0.4-4.3-0.4c-2.3,0-6.1-1.2-5.8-1.1c0.3,0.1,3.1,1.5,6,1.9C259.7,12.2,261.4,12.3,260.8,11.3z M242.4,8.6	c0,0-2.4-0.2-5.6-0.9c-3.2-0.8-10.3-2.8-15.1-3.5c-8.2-1.1-15.8,0-15.1,0.1c0.8,0.1,9.6-0.6,17.6,1.1c3.3,0.7,9.3,2.2,12.4,2.7	C239.9,8.7,242.4,8.6,242.4,8.6z M185.2,8.5c1.7-0.7-13.3,4.7-18.5,6.1c-2.1,0.6-6.2,1.6-10,2c-3.9,0.4-8.9,0.4-8.8,0.5	c0,0.2,5.8,0.8,11.2,0c5.4-0.8,5.2-1.1,7.6-1.6C170.5,14.7,183.5,9.2,185.2,8.5z M199.1,6.9c0.2,0-0.8-0.4-4.8,1.1	c-4,1.5-6.7,3.5-6.9,3.7c-0.2,0.1,3.5-1.8,6.6-3C197,7.5,199,6.9,199.1,6.9z M283,6c-0.1,0.1-1.9,1.1-4.8,2.5s-6.9,2.8-6.7,2.7	c0.2,0,3.5-0.6,7.4-2.5C282.8,6.8,283.1,5.9,283,6z M31.3,11.6c0.1-0.2-1.9-0.2-4.5-1.2s-5.4-1.6-7.8-2C15,7.6,7.3,8.5,7.7,8.6	C8,8.7,15.9,8.3,20.2,9.3c2.2,0.5,2.4,0.5,5.7,1.6S31.2,11.9,31.3,11.6z M73,9.2c0.4-0.1,3.5-1.6,8.4-2.6c4.9-1.1,8.9-0.5,8.9-0.8	c0-0.3-1-0.9-6.2-0.3S72.6,9.3,73,9.2z M71.6,6.7C71.8,6.8,75,5.4,77.3,5c2.3-0.3,1.9-0.5,1.9-0.6c0-0.1-1.1-0.2-2.7,0.2	C74.8,5.1,71.4,6.6,71.6,6.7z M93.6,4.4c0.1,0.2,3.5,0.8,5.6,1.8c2.1,1,1.8,0.6,1.9,0.5c0.1-0.1-0.8-0.8-2.4-1.3	C97.1,4.8,93.5,4.2,93.6,4.4z M65.4,11.1c-0.1,0.3,0.3,0.5,1.9-0.2s2.6-1.3,2.2-1.2s-0.9,0.4-2.5,0.8C65.3,10.9,65.5,10.8,65.4,11.1	z M34.5,12.4c-0.2,0,2.1,0.8,3.3,0.9c1.2,0.1,2,0.1,2-0.2c0-0.3-0.1-0.5-1.6-0.4C36.6,12.8,34.7,12.4,34.5,12.4z M152.2,21.1	c-0.1,0.1-2.4-0.3-7.5-0.3c-5,0-13.6-2.4-17.2-3.5c-3.6-1.1,10,3.9,16.5,4.1C150.5,21.6,152.3,21,152.2,21.1z",
					} ),
					el( Path, { 
						d: "M269.6,18c-0.1-0.1-4.6,0.3-7.2,0c-7.3-0.7-17-3.2-16.6-2.9c0.4,0.3,13.7,3.1,17,3.3	C267.7,18.8,269.7,18,269.6,18z",
					} ),
					el( Path, { 
						d: "M227.4,9.8c-0.2-0.1-4.5-1-9.5-1.2c-5-0.2-12.7,0.6-12.3,0.5c0.3-0.1,5.9-1.8,13.3-1.2	S227.6,9.9,227.4,9.8z",
					} ),
					el( Path, { 
						d: "M204.5,13.4c-0.1-0.1,2-1,3.2-1.1c1.2-0.1,2,0,2,0.3c0,0.3-0.1,0.5-1.6,0.4	C206.4,12.9,204.6,13.5,204.5,13.4z",
					} ),
					el( Path, { 
						d: "M201,10.6c0-0.1-4.4,1.2-6.3,2.2c-1.9,0.9-6.2,3.1-6.1,3.1c0.1,0.1,4.2-1.6,6.3-2.6	S201,10.7,201,10.6z",
					} ),
					el( Path, { 
						d: "M154.5,26.7c-0.1-0.1-4.6,0.3-7.2,0c-7.3-0.7-17-3.2-16.6-2.9c0.4,0.3,13.7,3.1,17,3.3	C152.6,27.5,154.6,26.8,154.5,26.7z",
					} ),
					el( Path, { 
						d: "M41.9,19.3c0,0,1.2-0.3,2.9-0.1c1.7,0.2,5.8,0.9,8.2,0.7c4.2-0.4,7.4-2.7,7-2.6	c-0.4,0-4.3,2.2-8.6,1.9c-1.8-0.1-5.1-0.5-6.7-0.4S41.9,19.3,41.9,19.3z",
					} ),
					el( Path, { 
						d: "M75.5,12.6c0.2,0.1,2-0.8,4.3-1.1c2.3-0.2,2.1-0.3,2.1-0.5c0-0.1-1.8-0.4-3.4,0	C76.9,11.5,75.3,12.5,75.5,12.6z",
					} ),
					el( Path, { 
						d: "M15.6,13.2c0-0.1,4.3,0,6.7,0.5c2.4,0.5,5,1.9,5,2c0,0.1-2.7-0.8-5.1-1.4	C19.9,13.7,15.7,13.3,15.6,13.2z",
					} ),
				)
			);
		}
	
	} // end Shapes()
	

	// ========================== //
	// Register Block
	// ========================== //
	registerBlockType( 'bne/shape-divider', {
		title: __( 'Shape Divider', 'bne' ),
		description: __( 'Add a shape divider to visually distinquish page sections.', 'bne' ),
		icon: blockIcon,
		category: 'bne-blocks',
		attributes: {
			   shapeHeight: {
				  type: 'number',
				  default: 100
			  },
			   backgroundHeight: {
				  type: 'number',
				  default: 10
			  },
			shapeColor: {
				  type: 'string',
				  default: ''
			  },
			   backgroundColor: {
				  type: 'string',
				  default: ''
			  },
			flipVertically: {
				type: 'boolean',
				default: 0				
			},
			flipHorizontally: {
				type: 'boolean',
				default: 0				
			},
			offset: {
				type: 'boolean',
				default: 0
			},
		},
		supports: {
			align: ['wide','full'],
			anchor: false,
			html: false,
			htmlValidation: false
		},
		styles: [
			{ name: 'wavey', label: __( 'Wavey', 'bne' ), isDefault: true },
			{ name: 'hills', label: __( 'Hills', 'bne' ) },
			{ name: 'waves', label: __( 'Waves', 'bne' ) },
			{ name: 'angled', label: __( 'Angled', 'bne' ) },
			{ name: 'sloped', label: __( 'Sloped', 'bne' ) },
			{ name: 'rounded', label: __( 'Rounded', 'bne' ) },
			{ name: 'triangle', label: __( 'Triangle', 'bne' ) },
			{ name: 'pointed', label: __( 'Pointed', 'bne' ) },
			{ name: 'clouds', label: __( 'Clouds', 'bne' ) },
			{ name: 'brush', label: __( 'Brush', 'bne' ) },
		],		
		
		// ========================== //
		// Admin Edit
		// ========================== //
		edit: function( props ) {
			var attributes = props.attributes;
			//console.log(attributes);
			
			// Make sure we have a default style variation classname set!!
			!attributes.className &&
				props.setAttributes( { className: 'is-style-wavey' } );
			
			// Set the align default value
			!attributes.align &&
				props.setAttributes( { align: 'full' } );

			
			// Block Classes
			var blockClasses =
				(attributes.flipVertically ? ' is-vertically-flipped' : '') + 
				(attributes.flipHorizontally ? ' is-horizontally-flipped' : '' ) +
				(attributes.offset ? ' has-offset' : ' ')
			;
						
			  return [

				// Panel Controls
				// ========================== //
				el( InspectorControls, {},
					el( PanelBody, {								
							title: __( 'Divider Settings', 'bne' ),
							initialOpen: true,
						},						
						el( RangeControl, {
								label: __( 'Shape Height', 'bne' ),
								value: attributes.shapeHeight,
								onChange: function( newShapeHeight ) {
									props.setAttributes( { shapeHeight: newShapeHeight } );
								},
								min: 0,
								max: 500,
								step: 1
							}
						),
						el( RangeControl, {
								label: __( 'Background Height', 'bne' ),
								value: attributes.backgroundHeight,
								onChange: function( newBackgroundHeight ) {
									props.setAttributes( { backgroundHeight: newBackgroundHeight } );
								},
								min: 0,
								max: 500,
								step: 1
							}
						),						
						el( ToggleControl, {
								label: __( 'Flip Vertically', 'bne' ),
								checked: !!attributes.flipVertically,
								onChange: function( newFlipVertically ) {
									props.setAttributes( { flipVertically: newFlipVertically } );
								}
							} 
						),
						el( ToggleControl, {
								label: __( 'Flip Horizontally', 'bne' ),
								checked: !!attributes.flipHorizontally,
								onChange: function( newFlipHorizontally ) {
									props.setAttributes( { flipHorizontally: newFlipHorizontally } );
								}
							}
						),
						el( ToggleControl, {
								label: __( 'Offset Shape', 'bne' ),
								checked: !!attributes.offset,
								onChange: function( newOffset ) {
									props.setAttributes( { offset: newOffset } );
								}
							}
						),				
					), // end PanelBody
						
					el( PanelColorSettings, {								
							title: __( 'Color Settings', 'bne' ),
							initialOpen: false,
							colorSettings: [ 
								{
									value: attributes.shapeColor,
									onChange: function( newShapeColor ) {
										props.setAttributes( { shapeColor: newShapeColor } );
									},
									label: __( 'Shape Color', 'bne' ),
								},
								{
									value: attributes.backgroundColor,
									onChange: function( newBackgroundColor ) {
										props.setAttributes( { backgroundColor: newBackgroundColor } );
									},
									label: __( 'Background Color', 'bne' ),
								}
							],
						}
					),
					
				
				), // End InspectorControls


				// Editor
				// ========================== //
				el( 'div', {
						className: props.className + ' bne-shape-divider' +blockClasses,
						style: {
							...(attributes.backgroundColor ? { backgroundColor: attributes.backgroundColor } : undefined ),
							...(attributes.shapeColor ? { color: attributes.shapeColor } : undefined ),
							...(attributes.shapeHeight ? { '--shapeHeight': attributes.shapeHeight+'px' } : undefined ),
							...(attributes.backgroundHeight ? { '--backgroundHeight': attributes.backgroundHeight+'px' } : undefined )
						},
						'aria-hidden': 'true'
					},
					el( 'div', {
							className: 'wp-block-bne-shape-divider-svg-wrapper'
						},
						
						// Get SVG Shape
						getShapes( attributes.className )

					),
					el( 'div', {
							className: 'wp-block-bne-shape-divider-alt-wrapper'
						},
					)
					
					
				) // End div.bne-shape-divider
			
			]; // END return
		}, // END edit
	
		
		// ========================== //
		// Save
		// ========================== //
		save: function (props) {
			var attributes = props.attributes;
			//console.log(attributes);
			
			// Block Classes
			var blockClasses =
				(attributes.flipVertically ? ' is-vertically-flipped' : '') + 
				(attributes.flipHorizontally ? ' is-horizontally-flipped' : '' ) +
				(attributes.offset ? ' has-offset' : ' ')
			;

			return (
				el( 'div', {
						className: 'bne-shape-divider' +blockClasses,
						style: {
							...(attributes.backgroundColor ? { backgroundColor: attributes.backgroundColor } : undefined ),
							...(attributes.shapeColor ? { color: attributes.shapeColor } : { color: '#000000' } ),
							...(attributes.shapeHeight ? { '--shapeHeight': attributes.shapeHeight+'px' } : '100px' ),
							...(attributes.backgroundHeight ? { '--backgroundHeight': attributes.backgroundHeight+'px' } : '50px' )
						},
						'aria-hidden': 'true'
					},
					el( 'div', {
							className: 'wp-block-bne-shape-divider-svg-wrapper'
						},

						// Get SVG Shape
						getShapes( attributes.className )

					),
					el( 'div', {
							className: 'wp-block-bne-shape-divider-alt-wrapper'
						},
					)
					
				) // End div.bne-shape-divider
			
			) // End return
		}, // End save


		// ========================== //
		// DEPRECATED BLOCK
		// ========================== //
		deprecated: [
			
			// @depreciated @v2.2.9
			{
				attributes:{shapeHeight:{type:'number',default:100},backgroundHeight:{type:'number',default:50},shapeColor:{type:'string',default:''},backgroundColor:{type:'string',default:''},flipVertically:{type:'boolean',default:0},flipHorizontally:{type:'boolean',default:0},},supports:{align:['wide','full'],anchor:!1,html:!1,htmlValidation:!1},save:function(props){var attributes=props.attributes;var blockClasses=(attributes.flipVertically?' is-vertically-flipped':'')+(attributes.flipHorizontally?' is-horizontally-flipped':'');return(el('div',{className:'bne-shape-divider mb-0 mt-0'+blockClasses,style:{...(attributes.backgroundColor?{backgroundColor:attributes.backgroundColor}:undefined),...(attributes.shapeColor?{color:attributes.shapeColor}:{color:'#000000'}),},'aria-hidden':'true'},el('div',{className:'wp-block-bne-shape-divider-svg-wrapper',style:{height:attributes.shapeHeight}},getShapes(attributes.className)),el('div',{className:'wp-block-bne-shape-divider-alt-wrapper',style:{height:attributes.backgroundHeight}},)))}
			},	
			
			
			// @depreciated @v2.2.4
			// Original block
			{
				attributes:{shapeHeight:{type:'number',default:100},backgroundHeight:{type:'number',default:50},shapeColor:{type:'string',default:'#000000'},backgroundColor:{type:'string',default:''},flipVertically:{type:'boolean',default:0},flipHorizontally:{type:'boolean',default:0},},supports:{align:['wide','full'],anchor:!1,html:!1,htmlValidation:!1},save:function(props){var attributes=props.attributes;var blockClasses=(attributes.flipVertically?' is-vertically-flipped':'')+(attributes.flipHorizontally?' is-horizontally-flipped':'');return(el('div',{className:'bne-shape-divider mb-0 mt-0'+blockClasses,style:{backgroundColor:attributes.backgroundColor,color:attributes.shapeColor,},'aria-hidden':'true'},el('div',{className:'wp-block-bne-shape-divider-svg-wrapper',style:{height:attributes.shapeHeight}},getShapes(attributes.className)),el('div',{className:'wp-block-bne-shape-divider-alt-wrapper',style:{height:attributes.backgroundHeight}},)))}
			}
		] // END DEPRECATED



	} ); // End registerBlockType


} )(
	window.wp.blocks,
	window.wp.components,
	window.wp.i18n,
	window.wp.element,
	window.wp.editor,
);